/*
 * ʸʸsplitsplitter
 *
 * ʸζ򸡽Ф
 * init_split_context() ʬѤΥƥȤä
 * mark_border() ʬ򤷤
 * release_split_context() ƥȤ
 *
 * commit_border() ߥåȤ줿ƤФƳؽ򤹤
 *
 * get_nr_seginfo()
 * get_nth_seginfo() Ϥʸι
 *
 * Funded by IPA̤Ƨեȥ¤ 2001 9/22
 * Copyright (C) 2000-2001 TABATA Yusuke, UGAWA Tomoharu
 */

#include <stdlib.h>
#include <stdio.h>

#include <record.h>
#include <splitter.h>
#include "wordborder.h"

/* ΩΥåι/ */
static void make_word_cache(struct splitter_context *);
static void release_info_cache(struct word_split_info_cache *);

static int get_seginfo_from_metaword(struct meta_word *, struct seg_info *);
static int real_seg_len(struct splitter_context *c, int, int);
static void proc_expanded_segment(struct splitter_context *c, int, int);

/*
 * make_word_cacheǺʸ
 */
void release_info_cache(struct word_split_info_cache *c)
{
  free_allocator(c->MwAllocator);
  free_allocator(c->WlAllocator);
  free(c->metawords);
  free(c->lists);
  free(c->seq_len);
  free(c->rev_seq_len);
  free(c);
}

/*
 * Ƥʬʸåơʸθ󤹤
 * ǳݤƤrelease_info_cacheǲ 
 */
void make_word_cache(struct splitter_context *c)
{
  int i;
  struct word_split_info_cache *info;
  c->word_split_info = malloc(sizeof(struct word_split_info_cache));
  info = c->word_split_info;
  info->MwAllocator = create_allocator(sizeof(struct meta_word), 0);
  info->WlAllocator = create_allocator(sizeof(struct word_list), 0);
  info->lists = malloc(sizeof(struct word_list) * (c->char_count + 1));
  info->metawords = malloc(sizeof(struct meta_word) * (c->char_count + 1));

  info->seq_len = malloc(sizeof(int) * (c->char_count + 1));
  info->rev_seq_len = malloc(sizeof(int) * (c->char_count + 1));

  /* ХꥢΤȤޤǽ */
  for (i = 0; i <= c->char_count; i++) {
    info->seq_len[i] = 0;
    info->rev_seq_len[i] = 0;
    info->lists[i].next = 0;
    info->metawords[i].next = 0;
  }

  /* word_listƤmetaword */
  make_word_list_all(c);
  make_metaword_all(c);
}

/*
 * metawordʸФ
 * NULLʤФϹԤʤ(פοȤ˻Ȥ)
 */
int get_seginfo_from_metaword(struct meta_word *mw, struct seg_info *i)
{
  if (mw->wl && mw->wl->len) {
    /* wordlistmetawordϤΤޤ޾Ф */
    struct word_list *wl = mw->wl;
    if (i) {
      i->type = SI_NORMAL;
      i->core.len = wl->core_len;
      i->prefix.len = wl->prefix_len;
      i->postfix.len = wl->postfix_len;
      i->core.wt = wl->core_wt;
      i->prefix.wt = wl->prefix_wt;
      i->postfix.wt = wl->postfix_wt;
      i->bias = wl->conn_score;
      i->len = wl->len;
    }
    return 0;
  }
  /* metawordΥפˤäƤȤѤ */
  switch (mw->type) {
  case MW_WRAP:
    /* wrap줿ΤξФ */
    return get_seginfo_from_metaword(mw->mw1, i);
  case MW_V_RENYOU_A:
  case MW_V_RENYOU_T:
    /* 2ʸ */
    if (i) {
      i->type = SI_NORMAL;
      i->core.len = mw->mw1->len + mw->mw2->len - mw->mw2->wl->follow_count;
      i->prefix.len = 0;
      i->postfix.len = 0;
      i->core.wt = wt_none;
      i->prefix.wt = wt_none;
      i->postfix.wt = wt_none;
      i->bias = 1;
      i->len = mw->mw1->len + mw->mw2->len;
    }
    return 0;
  case MW_OCHAIRE_LEAF:
    /* ؽˤ */
    if (i) {
      i->type = SI_CAND;
      i->cand.str = xstr_dup_str(mw->cand_hint);
      i->cand.len = mw->cand_hint->len;
    }
    return 0;
    break;
  case MW_NAMEPAIR:
  case MW_DUMMY:
  case MW_SINGLE:
  case MW_OCHAIRE:
    /* seginfoʤ */
  default:
    break;
  }
  return -1;
}

int get_nr_seginfo(struct splitter_context *c, int from, int len)
{
  struct meta_word *mw;
  int n;
  for (n = 0, mw = c->word_split_info->metawords[from].next;
       mw; mw = mw->next) {
    if (mw->len == len) {
      if (!get_seginfo_from_metaword(mw, NULL)) {
	n++;
      }
    }
  }
  return n;
}

int get_nth_seginfo(struct splitter_context *c, struct seg_info *i,
		    int from, int len, int nth)
{
  struct meta_word *mw;
  int n;
  for (n = 0, mw = c->word_split_info->metawords[from].next;
       mw; mw = mw->next) {
    if (mw->len == len) {
      if (n == nth) {
	if (!get_seginfo_from_metaword(mw, i)) {
	  return 0;
	}
      }
      if (!get_seginfo_from_metaword(mw, NULL)) {
	n++;
      }
    }
  }
  return -1;
}

/* ƤӽФwordsplitterΥȥåץ٥δؿ */
void mark_border(struct splitter_context *c, int from, int from2, int to)
{
  int i;
  struct word_split_info_cache *info;

  if ((to - from) <= 0) {
    return ;
  }

  info = c->word_split_info ;
  info->seg_border = alloca(sizeof(int)*(c->char_count + 1));
  for (i = 0; i < c->char_count + 1; i++) {
    info->seg_border[i] = c->ce[i].seg_border;
  }

  eval_border(c, from, to);
  for (i = from+1; i < from2; i++) {
    info->seg_border[i] = 0;
  }
  for (i = from; i < to; i++) {
    c->ce[i].seg_border = info->seg_border[i];
  }
}

/* ʸα¦դƤȤ */
int real_seg_len(struct splitter_context *c, int from, int limit)
{
  return limit;
}

/* ʸ᤬礵줿 */
void proc_expanded_segment(struct splitter_context *c, int from, int len)
{
  int initial_len = c->ce[from].initial_seg_len;
  int i, nr;
  xstr from_xs, to_xs, *xs;
  from_xs.str = c->ce[from].c;
  from_xs.len = initial_len;
  to_xs.str = c->ce[from].c;
  to_xs.len = len;
  if (select_section("EXPANDPAIR", 1) == -1) {
    return ;
  }
  if (select_column(&from_xs, 1) == -1) {
    return ;
  }
  nr = get_nr_values();
  for (i = 0; i < nr; i ++) {
    xs = get_nth_xstr(i);
    if (!xs || !xstrcmp(xs, &to_xs)) {
      /* ˤ */
      return ;
    }
  }
  set_nth_xstr(nr, &to_xs);
}

void commit_border(struct splitter_context *c, int n, struct seg_info *info)
{
  int i, from = 0;
  /* ʸΥޡؽ */
  for (i = 0; i < n; i++) {
    int l1, l2;
    l1 = c->ce[from].initial_seg_len;
    if (!l1 || from + l1 == c->char_count) {
      continue;
    }
    l2 = c->ce[from + l1].initial_seg_len;
    if (l1 + l2 <= info[i].len) {
      /* ʸޤĹ˳ĥ줿ʸ᤬ߥåȤ줿 */
      int r = real_seg_len(c, from, info[i].len);
      if (r <= l1) {
	continue;
      }
      proc_expanded_segment(c, from, r);
    }
    from += info[i].len;
  }
}

void init_split_context(xstr *xs, struct splitter_context *sc)
{
  int i;
  sc->char_count = xs->len;
  sc->ce = (struct char_ent*)
    malloc(sizeof(struct char_ent)*(xs->len + 1));
  for (i = 0; i <= xs->len; i++) {
    sc->ce[i].c = &xs->str[i];
    sc->ce[i].seg_border = 0;
    sc->ce[i].initial_seg_len = 0;
  }

  /* ξüʸζǤ */
  sc->ce[0].seg_border = 1;
  sc->ce[xs->len].seg_border = 1;

  make_word_cache(sc);
}

void release_split_context(struct splitter_context *sc)
{
  if (sc->word_split_info) {
    release_info_cache(sc->word_split_info);
    sc->word_split_info = 0;
  }
  if (sc->ce) {
    free(sc->ce);
    sc->ce = 0;
  }
}

int init_splitter()
{
  if (init_depword_tab()) {
    fprintf(stderr, "Anthy: Failed to init dependent word table.\n");
    return -1;
  }
  init_metaword_tab();
  return init_wordlist();
}

void quit_splitter()
{
  release_depword_tab();
}
