/* ʸᶭθФ˻Ȥǡ */
#ifndef _wordborder_h_included_
#define _wordborder_h_included_

#include <dic.h>
#include <alloc.h>

struct splitter_context;

enum constraint_stat {
  unchecked, ok, ng
};

/*
 * word_list: ʸ
 * Ƭ졢Ω졢졢°ޤ
 */
struct word_list{
  int from, len; /* ʸ */
  int core_from, core_len; /* Ω */
  int prefix_len, postfix_len; /* ƬĹ */
  int follow_count; /* 졢ưĹ */
  enum constraint_stat can_use; /* ȶ˸٤äƤʤ */
  int freq; /* Ω */
  int score;
  int node_id; /* °쥰դθϤnodeid*/
  int conn_score; /* °³Υ */
  seq_ent_t core_seq; /* Ωʬ */
  char *core_wt_name; /* word_listѤ롼ˤ뼫ΩΥ */
  wtype_t core_wt, prefix_wt, postfix_wt;
  struct word_list *next;
};

/* ȤꤢŬ䤷Ƥߤ꤬Фʬह */
enum metaword_type{
  /* ߡ : seginfoʤ */
  MW_DUMMY,
  /* wordlist0 or Ĵޤ */
  MW_SINGLE,
  /* ̤metawordĤޤ: metaword +  ʤ :seginfomw1 */
  MW_WRAP,
  /* Ļ̾Υڥ */
  MW_NAMEPAIR,
  /* ưϢѷ + ƻ */
  MW_V_RENYOU_A,
  /* ưϢѷ + ̾ */
  MW_V_RENYOU_T,
  MW_OCHAIRE,
  MW_OCHAIRE_LEAF
};

/* ᥿ */
struct meta_word{
  int from, len;
  int score;
  enum constraint_stat can_use; /* ȶ˸٤äƤʤ */
  enum metaword_type type;
  struct meta_word *next;
  struct word_list *wl;
  struct meta_word *mw1, *mw2;
  struct meta_word *parent;
  xstr* cand_hint;
};

/*
 * ƥμΩʤɤξ󡢺ǽѴܥ򲡤Ȥ
 * ۤ
 */
struct word_split_info_cache{
  struct meta_word *metawords;
  struct word_list *lists;/* ϤޤñΥꥹ */
  /* å幽˻Ȥ */
  int *seq_len;/* ϤޤĹñĹ */
  int *rev_seq_len;/* ǽĹñĹ */
  int *seg_border;/* contextΥԡ */
  /*  */
  allocator MwAllocator, WlAllocator;
};

/* defined in wordseq.c */
/* Ωʹߤ³ν */
void scan_node(struct splitter_context *c, struct word_list *wl,
	       xstr *follow, int node);
int get_node_id_by_name(char *name);
int init_depword_tab();
void release_depword_tab();

/* defined in wordlist.c */
void commit_word_list(struct splitter_context *, struct word_list *wl);
struct word_list *alloc_word_list(struct splitter_context *);
void print_word_list(struct splitter_context *, struct word_list *);
void make_word_list_all(struct splitter_context *);
int init_wordlist();

/* defined in metaword.c */
void init_metaword_tab();
void make_metaword_all(struct splitter_context *);
void print_metaword(struct splitter_context *, struct meta_word *);


/* defined in evalborder.c */
void eval_border(struct splitter_context *, int, int);

#endif
