/*
 * ʸμΩ(Ƭޤ)³
 * 졢ưʤɤ°Υѥ򸡽Ф
 * ѥϥդȤեѰդ롣
 *
 *
 *  +------+
 *  |      |
 *  |branch+--- node
 *  |      |
 *  | NODE |
 *  |      |
 *  |branch+--- node
 *  |      |
 *  |branch+--- node
 *  |      |
 *  +------+
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <conf.h>
#include <ruleparser.h>
#include <xstr.h>
#include "wordborder.h"

static int nrNodes;

#define WEAK_CONNECTION 8
#define WEAKER_CONNECTION 2
#define NORMAL_CONNECTION 1

struct dep_branch{
  /* ܾ° */
  int nr_strs;/* Ĺ */
  xstr *str;/*  */

  /* ΥΡ */
  int nr_nexts;
  int *next;/* ΥΡɤֹ */
  int *score;/* ܤΥ */
};

static struct dep_node{
  char *cn;/* Ρɤ̾ */
  int nr_branch;
  struct dep_branch *branch;
}*gNodes;

static void parse_line(char **, int );
static void match_nodes(struct splitter_context *, struct word_list *,
			xstr xs, int node);
static void match_branch(struct splitter_context *, struct word_list *wl,
			 xstr *xs, struct dep_branch *);
static void check_nodes();

/* ʸˡե˶ΥΡɤ뤫å */
void check_nodes()
{
  int i;
  for (i = 1; i < nrNodes; i++) {
    if (gNodes[i].nr_branch == 0) {
      printf("node %s has no branch.\n", gNodes[i].cn);
    }
  }
}

/*
 * ܤ¹ԤƤߤ
 *
 * tmpl ޤǤ˹word_list
 * xs Ĥʸ
 * db Ĵbranch
 */
void match_branch(struct splitter_context *c,struct word_list *tmpl,
		  xstr *xs, struct dep_branch *db)
{
  int i;
  /* ˥ȥ饤 */
  for (i = 0; i < db->nr_nexts; i++) {
    if (db->next[i]) {
      int conn_score = tmpl->conn_score;
      tmpl->conn_score *= db->score[i];
      match_nodes(c, tmpl, *xs, db->next[i]);
      tmpl->conn_score = conn_score;
    }else{
      /* 
       * üΡɤãΤǡ
       * word_listȤƥߥå
       */
      struct word_list *wl;
      wl = alloc_word_list(c);
      *wl = *tmpl;
      wl->len += wl->follow_count;
      commit_word_list(c, wl);
    }
  }
}

/*
 * ƥΡɤˤܾƥȤ
 *
 * wl Ωword_list
 * follow_str Ωʹߤʸ
 * node 롼ֹ
 */
void match_nodes(struct splitter_context *c, struct word_list *wl,
		 xstr follow_str, int node)
{
  struct dep_node *dn = &gNodes[node];
  struct dep_branch *db;
  int i,j;
  /* ƥ롼 */
  for (i = 0; i < dn->nr_branch; i++) {
    db = &dn->branch[i];
    /* ܾ */
    for (j = 0; j < db->nr_strs; j++) {
      if (follow_str.len >= db->str[j].len){
	xstr w;
	w.str = follow_str.str;
	w.len = db->str[j].len;
	if (!xstrcmp(&w, &db->str[j])) {
	  xstr new_follow;
	  new_follow.str = &follow_str.str[w.len];
	  new_follow.len = follow_str.len - w.len;
	  wl->follow_count += w.len;
	  match_branch(c, wl, &new_follow, db);
	  wl->follow_count -= w.len;
	}
      }
    }
  }
}

void scan_node(struct splitter_context *c, struct word_list *tmpl,
	       xstr *follow, int node)
{
  /* °դƤʤ֤鸡򳫻Ϥ */
  match_nodes(c, tmpl, *follow, node);
}

int get_node_id_by_name(char *name)
{
  int i;
  for (i = 0; i < nrNodes; i++) {
    if (!strcmp(name,gNodes[i].cn)) {
      return i;
    }
  }
  gNodes = realloc(gNodes, sizeof(struct dep_node)*(nrNodes+1));
  gNodes[nrNodes].cn = strdup(name);
  gNodes[nrNodes].nr_branch = 0;
  gNodes[nrNodes].branch = 0;
  nrNodes++;
  return nrNodes-1;
}

void parse_line(char **tokens, int nr)
{
  int id, i;
  struct dep_branch *db;
  struct dep_node *dn;

  /* ΡɤȤid */
  id = get_node_id_by_name(tokens[0]);
  dn = &gNodes[id];

  /*ΥΡɤ˥֥ɲä*/
  dn->branch = realloc(dn->branch,sizeof(struct dep_branch)*(dn->nr_branch+1));
  db = &dn->branch[dn->nr_branch];
  dn->nr_branch++;
  db->nr_strs = 0;
  db->str = 0;
  db->nr_nexts = 0;
  db->next = 0;
  db->score = 0;

  /*Υ֥°ΥꥹȤɲä*/
  for (i = 1; i < nr && tokens[i][0] == '\"'; i++) {
    char *s;
    xstr *xs;
    s = strdup(&tokens[i][1]);
    s[strlen(s)-1] =0;
    xs = cstr_to_xstr(s);
    db->str = realloc(db->str, sizeof(xstr)*(db->nr_strs+1));
    db->str[db->nr_strs] = *xs;
    db->nr_strs ++;
    free(s);
    free(xs);
  }

  /* ܾ郎ʤϷٹФơܾɲä */
  if (i == 1) {
    char *s;
    xstr *xs;
    printf("node %s has a branch without any transition condition.\n",
	   tokens[0]);
    s = strdup("");
    xs = cstr_to_xstr(s);
    db->str = malloc(sizeof(xstr));
    db->str[0] = *xs;
    db->nr_strs = 1;
    free(s);
    free(xs);
  }

  /*ΥΡɤɲä*/
  for ( ; i < nr; i++){
    int next_id;
    int c = NORMAL_CONNECTION;
    char *node_name = tokens[i];
    /*³Υץե*/
    switch(node_name[0]){
    case ':':
      c = WEAKER_CONNECTION;
      node_name ++;
      break;
    case '.':
      c = WEAK_CONNECTION;
      node_name ++;
      break;
    }
    next_id = get_node_id_by_name(node_name);
    db->next = realloc(db->next,sizeof(int)*(db->nr_nexts+1));
    db->next[db->nr_nexts] = next_id;
    db->score = realloc(db->score, sizeof(int)*(db->nr_nexts+1));
    db->score[db->nr_nexts] = c;
    db->nr_nexts ++;
  }
}

int init_depword_tab()
{
  char *fn;
  char **tokens;
  int nr;
  /*id 0 Ρɤ˳Ƥ*/
  get_node_id_by_name("@");
  fn = conf_get_str("DEPWORD");
  if (!fn) {
    printf("Dependent word dictionary is unspecified.\n");
    return -1;
  }
  if (open_file(fn) == -1) {
    printf("Failed to open dep word dict (%s).\n", fn);
    return -1;
  }
  while (!read_line(&tokens, &nr)) {
    parse_line(tokens, nr);
    free_line();
  }
  close_file();
  check_nodes();
  return 0;
}

void release_depword_tab()
{
  int i, j, k;
  for (i = 0; i < nrNodes; i++) {
    free(gNodes[i].cn);
    for (j = 0; j < gNodes[i].nr_branch; j++) {
      for (k = 0; k < gNodes[i].branch[j].nr_strs; k++) {
	free(gNodes[i].branch[j].str[k].str);
      }
      free(gNodes[i].branch[j].str);
      free(gNodes[i].branch[j].next);
      free(gNodes[i].branch[j].score);
    }
    free(gNodes[i].branch);
  }
}
