/* 
 * ΥץIPAΤǤǤޤ
 */

#include <stdlib.h>
#include "rkconv.h"
#include "rkhelper.h"

char* rk_wide_symbol[128] = {
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
  "", "", "", "", "", "", "", "", 
  "", "", "", "", "", "", "", "",
  "", "", "", "", "", "", "", "",
  "", "", "", "", "", "", "", "",

  "", NULL, NULL, NULL, NULL, NULL, NULL, NULL,
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
  NULL, NULL, NULL, "", "", "", "", "",
  "", NULL, NULL, NULL, NULL, NULL, NULL, NULL,
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 
  NULL, NULL, NULL, "", "", "", "", NULL
};

char* rk_wide_comma_jp = "";
char* rk_wide_period_jp = "";
char* rk_wide_backslash_jp = "";
char* rk_wide_minus_jp = "";
char* rk_wide_open_angle_bracket_jp = "";
char* rk_wide_close_angle_bracket_jp = "";

#include "rkmap.h"

void init_rk_option(struct rk_option* opt)
{
  opt->toggle_by_slash = 1;
  opt->comma         = RKOPT_JP;
  opt->period        = RKOPT_JP;
  opt->backslash     = RKOPT_JP;
  opt->minus         = RKOPT_JP;
  opt->angle_bracket = RKOPT_JP;
  memset(&opt->wide_symbol, 0, 128);
  memset(&opt->wide_symbol[(int) '0'], 1, 10);  /* number */
}

static void rkrule_set(struct rk_rule* r, char* lhs, char* rhs, char* follow)
{
  r->lhs = lhs;
  r->rhs = rhs;
  r->follow = follow;
}

struct rk_map* make_rkmap_ascii(struct rk_option* opt)
{
  struct rk_rule var_part[130];
  struct rk_rule* complete_rules;
  struct rk_map* map;
  struct rk_rule* p;
  char work[2*128];
  char* w;
  int c;
  
  p = var_part;
  w = work;
  for (c = 0; c < 128; c++)
    if (rk_wide_symbol[c]) {
      w[0] = c;
      w[1] = '\0';
      rkrule_set(p++, w, w, NULL);
      w += 2;
    }
  p->lhs = NULL;

  complete_rules = rk_merge_rules(rk_rule_alphabet, var_part);
  map = rk_map_create(complete_rules);
  rk_rules_free(complete_rules);

  return map;
}

struct rk_map* make_rkmap_wascii(struct rk_option* opt)
{
  struct rk_rule var_part[130];
  struct rk_rule* complete_rules;
  struct rk_map* map;
  struct rk_rule* p;
  char work[2*128];
  char* w;
  int c;
  
  p = var_part;
  w = work;
  for (c = 0; c < 128; c++)
    if (rk_wide_symbol[c]) {
      w[0] = c;
      w[1] = '\0';
      rkrule_set(p++, w, rk_wide_symbol[c], NULL);
      w += 2;
    }
  p->lhs = NULL;

  complete_rules = rk_merge_rules(rk_rule_walphabet, var_part);
  map = rk_map_create(complete_rules);

  rk_rules_free(complete_rules);

  return map;
}

struct rk_map* make_rkmap_shiftascii(struct rk_option* opt)
{
  struct rk_rule var_part[130];
  struct rk_rule* complete_rules;
  struct rk_map* map;
  struct rk_rule* p;
  char work[2*128];
  char* w;
  int c;
  
  p = var_part;
  w = work;
  for (c = 0; c < 128; c++)
    if (c == '/')
      rkrule_set(p++, "/", "\xff" "o", NULL);
    else if (rk_wide_symbol[c]) {
      w[0] = c;
      w[1] = '\0';
      rkrule_set(p++, w, w, NULL);
      w += 2;
    }
  rkrule_set(p++, "//", "/", NULL);
  p->lhs = NULL;

  complete_rules = rk_merge_rules(rk_rule_alphabet, var_part);
  map = rk_map_create(complete_rules);
  rk_rules_free(complete_rules);

  return map;
}

struct rk_map* make_rkmap_hirakata(struct rk_rule* rule, struct rk_option* opt)
{
  struct rk_rule var_part[130];
  struct rk_rule* complete_rules;
  struct rk_map* map;
  struct rk_rule* p;
  char work[2*128 + 1];
  char* w;
  int c;

  p = var_part;
  w = work;
  for (c = 0; c < 128; c++) {
    switch(c) {
    case '/':
      {
	char* slash = "/";
	if (opt->toggle_by_slash) {
	  w[0] = '\xff';
	  w[1] = '0' + RKMAP_SHIFT_ASCII;
	  w[2] = '\0';
	  rkrule_set(p++, "/", w, NULL);
	  slash = "//";
	  w += 3;
	}
	if (opt->wide_symbol[(int) '/'])
	  rkrule_set(p++, slash, rk_wide_symbol[(int) '/'], NULL);
	else
	  rkrule_set(p++, slash, "/", NULL);
      }	
      break;
    case ',':
      if (opt->comma == RKOPT_JP)
	rkrule_set(p++, ",", rk_wide_comma_jp, NULL);
      else if (opt->wide_symbol[(int) ','])
	rkrule_set(p++, ",", rk_wide_symbol[(int) ','], NULL);
      else
	rkrule_set(p++, ",", ",", NULL);
      break;
    case '.':
      if (opt->period == RKOPT_JP)
	rkrule_set(p++, ".", rk_wide_period_jp, NULL);
      else if (opt->wide_symbol[(int) '.'])
	rkrule_set(p++, ".", rk_wide_symbol[(int) '.'], NULL);
      else
	rkrule_set(p++, ".", ".", NULL);
      break;
    case '\\':
      if (opt->backslash == RKOPT_JP)
	rkrule_set(p++, "\\", rk_wide_backslash_jp, NULL);
      else if (opt->wide_symbol[(int) '\\'])
	rkrule_set(p++, "\\", rk_wide_symbol[(int) '\\'], NULL);
      else
	rkrule_set(p++, "\\", "\\", NULL);
      break;
    case '-':
      if (opt->period == RKOPT_JP)
	rkrule_set(p++, "-", rk_wide_minus_jp, NULL);
      else if (opt->wide_symbol[(int) '-'])
	rkrule_set(p++, "-", rk_wide_symbol[(int) '-'], NULL);
      else
	rkrule_set(p++, "-", "-", NULL);
      break;
    case '[':
      if (opt->angle_bracket == RKOPT_JP)
	rkrule_set(p++, "[", rk_wide_open_angle_bracket_jp, NULL);
      else if (opt->wide_symbol[(int) '['])
	rkrule_set(p++, "[", rk_wide_symbol[(int) '['], NULL);
      else
	rkrule_set(p++, "[", "[", NULL);
      break;
    case ']':
      if (opt->backslash == RKOPT_JP)
	rkrule_set(p++, "]", rk_wide_close_angle_bracket_jp, NULL);
      else if (opt->wide_symbol[(int) ']'])
	rkrule_set(p++, "]", rk_wide_symbol[(int) ']'], NULL);
      else
	rkrule_set(p++, "]", "]", NULL);
      break;
    default:
      w[0] = c;
      w[1] = '\0';
      if (opt->wide_symbol[c] && rk_wide_symbol[c])
	rkrule_set(p++, w, rk_wide_symbol[c], NULL);
      else if (rk_wide_symbol[c])
	rkrule_set(p++, w, w, NULL);
      w += 2;
      break;
    }
  }
  p->lhs = NULL;

  complete_rules = rk_merge_rules(rule, var_part);
  map = rk_map_create(complete_rules);
  rk_rules_free(complete_rules);

  return map;
}

struct rk_map* make_rkmap_hiragana(struct rk_option* opt)
{
  return make_rkmap_hirakata(rk_rule_hiragana, opt);
}

struct rk_map* make_rkmap_katakana(struct rk_option* opt)
{
  return make_rkmap_hirakata(rk_rule_katakana, opt);
}
