/* 
 * ΥץIPAΤǤǤޤ
 */

#ifndef RKHELPER_H_INCLUDE
#define RKHELPER_H_INCLUDE

#define RKOPT_US 0
#define RKOPT_JP 1

enum {
  RKMAP_ASCII, RKMAP_SHIFT_ASCII, RKMAP_HIRAGANA, RKMAP_KATAKANA,
  RKMAP_WASCII, NR_RKMAP
};

struct rk_option {
  int toggle_by_slash;
  int comma;
  int period;
  int backslash;
  int minus;
  int angle_bracket;
  char wide_symbol[128];
};

extern char* rk_wide_symbol[];

void init_rk_option(struct rk_option* opt);
struct rk_map* make_rkmap_ascii(struct rk_option* opt);
struct rk_map* make_rkmap_wascii(struct rk_option* opt);
struct rk_map* make_rkmap_shiftascii(struct rk_option* opt);
struct rk_map* make_rkmap_hiragana(struct rk_option* opt);
struct rk_map* make_rkmap_katakana(struct rk_option* opt);

#endif /* RKHELPER_H_INCLUDE */
