/* 饤֥δؿƤӽФΥƥ */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <anthy.h>
#include <config.h>

#define TESTDATA "testdata.txt"
char *testdata = TESTDATA;

struct input{
  char *str;
  char *kw;
  int serial;
}cur_input;

struct condition{
  int serial;
  int from;
  int to;
  char *kw;
  int loop;
  int silent;
}cond;

int read_file(FILE *fp)
{
  char buf[256];
  while(fgets(buf, 256, fp)) {
    switch(buf[0]){
    case '#':
      break;
    case '*':
      if (cur_input.str) {
	free(cur_input.str);
	cur_input.str = 0;
      }
      buf[strlen(buf)-1] = 0;
      cur_input.str = strdup(&buf[1]);
      break;
    case ':':
      break;
    case '-':
      cur_input.serial ++;
      if (cur_input.kw) {
	free(cur_input.kw);
	cur_input.kw = 0;
      }
      return 0;
      break;
    }
  }
  return -1;
}

int check_cond()
{
  if (cur_input.serial == cond.serial) {
    return 1;
  }
  if (cur_input.kw && cond.kw && strstr(cur_input.kw, cond.kw)) {
    return 1;
  }
  if (cur_input.serial <= cond.to && cur_input.serial >= cond.from) {
    return 1;
  }
  return 0;
}

void init_lib()
{
  anthy_conf_override("STRUCT", "struct.txt");
  anthy_conf_override("INDEPWORD", "indepword.txt");
  anthy_conf_override("DEPWORD", "master.depword");
  anthy_conf_override("SDIC", "../mkanthydic/anthy.dic");
  anthy_conf_override("ANTHYDIR", "../mkanthydic/");
  if (anthy_init()) {
    printf("failed to init anthy\n");
    exit(0);
  }
}

void print_usage()
{
  printf("Anthy "VERSION"\n"
	 "./anthy [test-id]\n"
	 " For example.\n"
	 "  ./anthy 1\n"
	 "  ./anthy --to 100\n"
	 "  ./anthy --from 10 --to 100\n"
	 "  ./anthy --loop\n"
	 "  ./anthy --silent\n"
	 "  ./anthy --all\n\n");
  exit(0);
}

void parse_args(int argc, char **argv)
{
  int i;
  char *arg;
  for (i = 1; i < argc; i++) {
    arg = argv[i];
    if (!strncmp(arg, "--", 2)) {
      arg = &arg[2];
      if (!strcmp(arg, "help") || !strcmp(arg, "version")) {
	print_usage();
      }
      if (!strcmp(arg, "all")) {
	cond.from = 0;
	cond.to = 100000000;
      } else if (!strcmp(arg, "loop")) {
	cond.loop = 1;
      } else if (!strcmp(arg, "silent")) {
	cond.silent = 1;
      }
      if (i + 1 < argc) {
	if (!strcmp(arg,"from")){
	  cond.from = atoi(argv[i+1]);
	  i++;
	}else if (!strcmp(arg,"to")){
	  cond.to = atoi(argv[i+1]);
	  i++;
	}else if (!strcmp(arg,"file")){
	  testdata = argv[i+1];
	  i++;
	}
      }
    }else{
      cond.serial = atoi(arg);
      if ( !cond.serial ){
	print_usage();
      }
    }
  }
}

int main(int argc,char **argv)
{
  anthy_context_t ac;
  FILE *fp;

  parse_args(argc,argv);
  printf("./test_anthy --help to print usage.\n");

  init_lib();

 begin:;
  fp = fopen(testdata, "r");
  if (!fp) {
    printf("failed to open %s.\n", testdata);
    return 0;
  }
  
  ac = anthy_create_context();
  
  while (!read_file(fp)) {
    if (check_cond()) {
      anthy_set_string(ac,cur_input.str);
      if (!cond.silent) {
	printf("%d:(%s)\n", cur_input.serial, cur_input.str);
	anthy_print_context(ac);
      }
      anthy_reset_context(ac);
    }
  }
  anthy_release_context(ac);

  if (cond.loop) {
    fclose(fp);
    goto begin;
  }
  anthy_quit();

  return 0;
}
