#include <stdio.h>
#include <stdlib.h>
#include "da.h"

static void
write_int(FILE *fp, int num)
{
  fwrite(&num, sizeof(num), 1, fp);
}

int
da_write_file(struct da *da, const char *fn)
{
  int i;
  FILE *fp;
  fp = fopen(fn, "w");
  if (!fp) {
    return 0;
  }
  write_int(fp, da->size);
  for (i = 0; i < da->size; i++) {
    write_int(fp, da_get_base(da, i));
    write_int(fp, da_get_check(da, i));
    write_int(fp, da_get_value(da, i));
  }
  fclose(fp);
  return 0;
}

static int
im_get_base(struct da *da, int idx)
{
  return da->ptr[idx * 3 + 1];
}

static int
im_get_check(struct da *da, int idx)
{
  return da->ptr[idx * 3 + 1 + 1];
}

static int
im_get_value(struct da *da, int idx)
{
  return da->ptr[idx * 3 + 1 + 2];
}

static void
im_set_value(struct da *da, int idx, int value)
{
}

struct da *
da_create_from_image(void *image)
{
  struct da *da;
  da = malloc(sizeof(struct da));
  da->ptr = image;
  da->size = da->ptr[0];
  /**/
  da->set_base = NULL;
  da->get_base = im_get_base;
  da->set_check = NULL;
  da->get_check = im_get_check;
  da->set_value = NULL;
  da->get_value = im_get_value;
  /**/
  return da;
}
