#ifndef _da_h_included_
#define _da_h_included_

struct da {
  int size;
  /* array implementation */
  struct delm *arr;
  /* file implementation */
  int *ptr;
  /**/
  /* operations */
  void (*set_base)(struct da *da, int idx, int base);
  int (*get_base)(struct da *da, int idx);
  void (*set_check)(struct da *da, int idx, int check);
  int (*get_check)(struct da *da, int idx);
  void (*set_value)(struct da *da, int idx, int value);
  int (*get_value)(struct da *da, int idx);
};

/* main API */
struct da *da_create(void);
void da_add(struct da *da, const char *str, int len, int value);
void da_traverse(struct da *da, int idx, char *buf, int len);
void da_dump(struct da *da);

/* normal image API */
int da_get_check(struct da *da, int idx);
int da_get_base(struct da *da, int idx);
int da_get_value(struct da *da, int idx);
void da_set_value(struct da *da, int idx, int value);

/* file */
int da_write_file(struct da *da, const char *fn);
struct da *da_create_from_image(void *image);

#endif
