#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <string.h>
#include <stdio.h>
#include "main.h"

struct http_url {
  int is_valid;
  int port;
  const char *host;
  const char *path;
};

static int
open_socket(const char *name, int port)
{
  struct hostent *entry;
  struct sockaddr_in hostaddr;
  int fd;
  /**/
  entry = gethostbyname(name);
  if (!entry) {
    return -1;
  }
  fd = socket(AF_INET, SOCK_STREAM, 0);
  if (fd < 0) {
    return -1;
  }
  hostaddr.sin_family = AF_INET;
  hostaddr.sin_port = htons(port);
  memcpy(&hostaddr.sin_addr, entry->h_addr, entry->h_length);
  if (connect(fd, (struct sockaddr *)&hostaddr, sizeof(struct sockaddr_in)) < 0) {
    return -1;
  }
  return fd;
}

static int
do_get(int fd, const char *path, const char *host, FILE *out)
{
  FILE *rfp, *wfp;
  int ch;
  rfp = fdopen(fd, "r");
  wfp = fdopen(fd, "w");
  fprintf(wfp, "GET %s HTTP/1.0\n", path);
  fprintf(wfp, "Host: %s\n\n", host);
  fflush(wfp);
  while ((ch = fgetc(rfp)) > -1) {
    fputc(ch, out);
  }
  fclose(rfp);
  fclose(wfp);
  return 0;
}

static void
parse_url(struct http_url *url, const char *url_str)
{
  int i, len;
  char *host;
  /**/
  url->is_valid = 0;
  url->port = 80;
  url->host = NULL;
  url->path = NULL;
  /**/
  if (strncmp(url_str, "http://", 7)) {
    return ;
  }
  host = strdup(&url_str[7]);
  len = strlen(host);
  for (i = 0; i < len; i++) {
    if (host[i] == ':' ||
	host[i] == '/') {
      host[i] = 0;
      break;
    }
  }
  url->host = host;
  /**/
  url->path = &url_str[7];
  url->path = strchr(url->path, '/');
  if (!url->path) {
    url->path = "/";
  }
  url->path = strdup(url->path);
  url->is_valid = 1;
}

static void
release_url(struct http_url *url)
{
  free(url->host);
  free(url->path);
}

int
http_get(const char *url_str, FILE *fp)
{
  int fd;
  struct http_url url;
  int res;

  parse_url(&url, url_str);
  if (!url.is_valid) {
    release_url(&url);
    return -1;
  }

  fd = open_socket(url.host, url.port);
  if (fd < 0) {
    printf("failed to connect\n");
    return -1;
  }
  res = do_get(fd, url.path, url.host, fp);
  close(fd);
  return res;
}
