;;
(define alphabet-char?
  (lambda (c)
    (and (number? c)
	 (or
	  (and (> c 64) (< c 91))
	  (and (> c 96) (< c 123))))))
;;
(define to-lower-char
  (lambda (c)
    (if (and (alphabet-char? c) (< c 91))
	(+ c 32)
	c)))
;;
(define string-list-concat
  (lambda (lst)
    (let ((len (length lst)))
      (if (= len 0)
	  ""
	  (string-append
	   (string-list-concat (cdr lst))
	   (car lst))))))
;;
(define string-find
  (lambda (lst str)
    (if lst
	(if
	 (string-equal? (car lst) str)
	 #t
	 (string-find (cdr lst) str))
	())))
;;
(define truncate-list
  (lambda (lst len)
    (if (< (length lst) len)
	nil
	(if (= len 0)
	    '()
	    (cons (car lst)
		  (truncate-list
		   (cdr lst)
		   (- len 1)))))))
;;
