#include <stdio.h>
#include "context.h"

static char *
get_sym(int key)
{
  switch (key) {
  case UKey_Backspace: return "backspace";
  case UKey_Delete: return "delete";
  case UKey_Escape: return "escape";
  case UKey_Return: return "return";
  case UKey_Left: return "left";
  case UKey_Up: return "up";
  case UKey_Right: return "right";
  case UKey_Down: return "down";
  }
  return NULL;
}

static int
keycode_to_sym(int key, char *buf)
{
  char *s = get_sym(key);
  if (!s) {
    if (key > 128) {
      return -1;
    }
    snprintf(buf, 19, "%d", key);
  } else {
    snprintf(buf, 19, "'%s", s);
  }
  return 0;
}

static void
handle_key(uim_context uc, char *p, int key, int state)
{
  char buf[100];
  char keybuf[20];
  int rv;

  rv = keycode_to_sym(key, keybuf);
  if (rv == -1) {
    return;
  }
  snprintf(buf, 99, "(key-%s-handler %d %s %d)", p,
	   uc->id, keybuf, state);
  uim_eval_string(uc, buf);
}

int
uim_press_key(uim_context uc, int key, int state)
{
  uc->commit_raw_flag = 0;
  handle_key(uc, "press", key, state);
  return uc->commit_raw_flag;
}

int
uim_release_key(uim_context uc, int key, int state)
{
  uc->commit_raw_flag = 0;
  handle_key(uc, "release", key, state);
  return uc->commit_raw_flag;
}
