(require "rk.scm")
(require "generic-key.scm")
;;

(define generic-context-rk-context
  (lambda (pc)
    (car (nthcdr 0 pc))))

(define generic-context-set-rk-context!
  (lambda (pc rkc)
    (set-car! (nthcdr 0 pc) rkc)))

(define generic-context-rk-nth
  (lambda (pc)
    (car (nthcdr 1 pc))))

(define generic-context-set-rk-nth!
  (lambda (pc n)
    (set-car! (nthcdr 1 pc) n)))

(define generic-context-on
  (lambda (pc)
    (car (nthcdr 2 pc))))

(define generic-context-set-on!
  (lambda (pc n)
    (set-car! (nthcdr 2 pc) n)))

(define generic-update-preedit
  (lambda (id pc)
    (let* ((rkc (generic-context-rk-context pc))
	   (cs (rk-current-seq rkc))
	   (n (generic-context-rk-nth pc)))
      (im-clear-preedit id)
      (im-pushback-preedit
       id preedit-reverse
       (if cs
	   (nth n (cadr cs))
	   (rk-pending rkc)))
      (im-update-preedit id))))

;; (context nth)
(define generic-context-new
  (lambda (rule back)
    (let ((c (copy-list '(() 0 ()))))
      (generic-context-set-rk-context!
       c (rk-context-new rule #f back))
      (generic-context-set-rk-nth!
       c 0)
      (generic-context-set-on!
       c #f)
      c)))

(define generic-proc-on-mode
  (lambda (id pc key state)
    (let* ((rkc (generic-context-rk-context pc))
	   (res))
      (and 
       (if (generic-off-key key state)
	   (begin
	     (rk-flush rkc)
	     (generic-context-set-on! pc #f)
	     (im-update-mode id 0)
	     #f)
	   #t)
       (if (generic-next-candidate-key key state)
	   (begin
	     (let ((n (generic-context-rk-nth pc))
		   (cs (cadr (rk-current-seq rkc))))
	       (generic-context-set-rk-nth! pc
					    (+ 1 n))
	       (if (<= (length cs) n)
		   (generic-context-set-rk-nth! pc 0)))
	     #f)
	   #t)
       (if (backspace-key key state)
	   (begin
	     (if (not (rk-backspace rkc))
		 (im-commit-raw id))
	     (generic-context-set-rk-nth! pc 0)
	     #f)
	   #t)
       (begin
	 (set! res
	       (rk-push-key!
		rkc
		(charcode->string key)))
	 #t))
      (if (not (rk-partial? rkc))
	  (let ((cs (rk-current-seq rkc)))
	    (if (= (length (cadr cs)) 1)
		(begin
		  (im-commit id
			     (nth (generic-context-rk-nth pc) (cadr cs)))
		  (generic-context-set-rk-nth! pc 0)
		  (rk-flush rkc)))))
      (if res
	  (begin
	    (im-commit id (nth (generic-context-rk-nth pc) res))
	    (generic-context-set-rk-nth! pc 0))))))

(define generic-proc-off-mode
  (lambda (id pc key state)
    (and
     (if (generic-on-key key state)
	 (begin
	   (generic-context-set-on! pc #t)
	   (im-update-mode id 1)
	   #f)
	 #t)
     ;;
     (im-commit-raw id))))

(define generic-key-press-handler
  (lambda (id key state)
    (let* ((c (find-context id))
	   (pc (context-data c)))
      (if (generic-context-on pc)
	  (generic-proc-on-mode id pc key state)
	  (generic-proc-off-mode id pc key state))
      (generic-update-preedit id pc)
      ())))

(define generic-key-release-handler
  (lambda (id key state)
    ()))

(define generic-reset-handler
  (lambda (id)
    ()))

(define generic-mode-handler
  (lambda (id mode)
    (let* ((c (find-context id))
	   (pc (context-data c))
	   (rkc (generic-context-rk-context pc)))
      (if (= mode 0)
	  (generic-context-set-on! pc #f)
	  (generic-context-set-on! pc #t))
      (rk-flush rkc)
      (generic-update-preedit id pc))))

(define generic-get-candidate-handler
  (lambda (id idx)
    ()))
(define generic-set-candidate-index-handler
  (lambda (id idx)
    ()))

(define generic-init-handler
  (lambda (id init-handler)
    (init-handler id nil)
    (im-clear-mode-list id)
    (im-pushback-mode-list id "RAW")
    (im-pushback-mode-list
     id
     (im-name (context-im (find-context id))))
    (im-update-mode id 0)))

(define generic-register-im
  (lambda (name lang code init)
    (register-im
     name lang code init generic-init-handler nil
     generic-mode-handler
     generic-key-press-handler
     generic-key-release-handler
     generic-reset-handler
     generic-get-candidate-handler
     generic-set-candidate-index-handler)))
