#include <stdio.h>
#include <stdlib.h>
#include "ui.h"
#include "reader.h"

static void
do_dump()
{
  system("fossil-backend --dump > tmp-tmp");
}

static void
update_word_attrs(app_win *aw, Word *w)
{
  gtk_list_store_clear(GTK_LIST_STORE(aw->attr_model));
  if (!w) {
    return ;
  }
  std::list<Attr *>::iterator it;
  for (it = w->m_attrs.begin(); it != w->m_attrs.end(); it++) {
    Attr *a = *it;
    std::list<Sign *>::iterator jt;
    for (jt = a->m_signs.begin(); jt != a->m_signs.end(); jt++) {
      Sign *s = *jt;
      GtkTreeIter iter;
      char buf[10];
      s->m_stamp.get_str(buf);
      gtk_list_store_append(GTK_LIST_STORE(aw->attr_model), &iter);
      gtk_list_store_set(GTK_LIST_STORE(aw->attr_model), &iter,
			 0, s,
			 1, s->m_user,
			 2, buf,
			 3, s->m_is_ok ? "ok" : "no",
			 4, a->m_attr,
			 -1);
    }
  }
}


static void
set_edit_attrs(app_win *win, Sign *sign)
{
  if (!sign) {
    gtk_label_set_text(GTK_LABEL(win->index_label), "");
    gtk_label_set_text(GTK_LABEL(win->word_label), "");
    gtk_label_set_text(GTK_LABEL(win->name_label), "");
    gtk_label_set_text(GTK_LABEL(win->attr_label), "");
    gtk_label_set_text(GTK_LABEL(win->stamp_label), "");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(win->ok_check), 0);
    return ;
  }
  Attr *a = sign->m_owner;
  gtk_label_set_text(GTK_LABEL(win->index_label), a->m_owner->m_index);
  gtk_label_set_text(GTK_LABEL(win->word_label), a->m_owner->m_word);
  gtk_label_set_text(GTK_LABEL(win->name_label), sign->m_user);
  gtk_label_set_text(GTK_LABEL(win->attr_label), a->m_attr);
  //
  char buf[10];
  sign->m_stamp.get_str(buf);
  gtk_label_set_text(GTK_LABEL(win->stamp_label), buf);
  //
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(win->ok_check),
			       sign->m_is_ok);
}

void
word_selection_cb(GtkTreeSelection *selection,
		  app_win *win)
{
  GtkTreeIter iter;
  GValue value = {0};
  const char *s;
  if (!gtk_tree_selection_get_selected(selection, NULL, &iter)) {
    win->current_word = NULL;
    win->current_sign = NULL;
    update_word_attrs(win, NULL);
    set_edit_attrs(win, NULL);
    return ;
  }

  gtk_tree_model_get_value(win->words_model, &iter,
			   0, &value);
  //
  Word *w = (Word *)g_value_get_pointer(&value);
  if (w != win->current_word) {
    win->current_sign = NULL;
    set_edit_attrs(win, NULL);
  }
  win->current_word = w;
  g_value_unset(&value);
  update_word_attrs(win, w);
}

void
check_cb(GtkWidget *ok_check,
	 app_win *win)
{
  Sign *sign = win->current_sign;
  if (!sign) {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(win->ok_check), 0);
    return ;
  }
  if (!strcmp(sign->m_user, get_user_name())) {
    // my decision
    int active;
    active = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(win->ok_check));
    if (active) {
      sign->m_is_ok = true;
    } else {
      sign->m_is_ok = false;
    }
  } else {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(win->ok_check),
				 sign->m_is_ok);
  }
  update_word_attrs(win, win->current_word);
}

void
new_attr_cb(GtkWidget *button, app_win *win)
{
  if (!win->current_word) {
    return ;
  }
  Stamp stamp;
  win->ws.add_word(get_user_name(), stamp,
		   "add", true,
		   win->current_word->m_index,
		   win->current_word->m_word);
  update_word_attrs(win, win->current_word);
}

void
quit_cb(GtkWidget *button, app_win *win)
{
  gtk_exit(0);
}

void
save_cb(GtkWidget *button, app_win *win)
{
  FILE *fp = fopen("tmp-tmp", "w");
  if (!fp) {
    fprintf(stderr, "failed to open tmpfile.\n");
    return ;
  }
  win->ws.write_words(fp, NULL);
  fclose(fp);
  system("fossil-backend --read tmp-tmp");
  system("fossil-backend --update-index");
  fprintf(stderr, "save done\n");
}

void
attr_selection_cb(GtkTreeSelection *selection,
		  app_win *win)
{
  GtkTreeIter iter;
  GValue value = {0};
  const char *s;
  if (!gtk_tree_selection_get_selected(selection, NULL, &iter)) {
    win->current_sign = NULL;
    return ;
  }

  gtk_tree_model_get_value(win->attr_model, &iter,
			   0, &value);
  Sign *sign;
  sign = (Sign *)g_value_get_pointer(&value);
  win->current_sign = sign;
  g_value_unset(&value);
  if (sign) {
    set_edit_attrs(win, sign);
  }
}

static void
update_model(struct app_win *aw)
{
  std::list<Word *>::iterator it;
  GtkTreeIter iter;

  for (it = aw->ws.m_word_array.begin();
       it != aw->ws.m_word_array.end(); it++) {
    Word *w = *it;

    gtk_list_store_append(GTK_LIST_STORE(aw->words_model), &iter);
    gtk_list_store_set(GTK_LIST_STORE(aw->words_model), &iter,
		       0, w,
		       1, w->m_index,
		       2, w->m_word,
		       -1);

  }
}

static void
read_words(WordSet *ws, const char *fn)
{
  FILE *fp = fopen(fn, "r");
  if (!fp) {
    return ;
  }
  char buf[1024];
  while (fgets(buf, 1024, fp)) {
    DictLine dl(buf);
    if (dl.nr != 6) {
      continue;
    }
    ws->add_word(dl.user, dl.stamp,
		 dl.attr, dl.approve,
		 dl.index, dl.word);
  }
  fclose(fp);
}

int
main(int argc, char **argv)
{
  struct app_win win;
  do_dump();
  fprintf(stderr, "dump words done\n");
  read_words(&win.ws, "tmp-tmp");
  fprintf(stderr, "load words done\n");
  gtk_init(&argc, &argv);
  win.current_sign = NULL;
  win.current_word = NULL;

  build_win(&win);

  update_model(&win);

  gtk_main();
  return 0;
}
