// -*- C++ -*-
#ifndef _ui_h_included_
#define _ui_h_included_

#include <gtk/gtk.h>
#include "word.h"
#include "storage.h"

struct app_win {
  GtkWidget *main_top;
  //
  GtkTreeModel *words_model;
  GtkWidget *words_view;
  Word *current_word;
  //
  GtkTreeModel *attr_model;
  GtkWidget *attr_view;
  //
  WordSet ws;

  // edit window
  GtkWidget *edit_top;
  GtkWidget *index_label;
  GtkWidget *word_label;
  GtkWidget *name_label;
  GtkWidget *attr_label;
  GtkWidget *stamp_label;
  GtkWidget *ok_check;
  Sign *current_sign;
};

void build_win(app_win *win);
void check_cb(GtkWidget *ok_check, app_win *win);
void word_selection_cb(GtkTreeSelection *selection, app_win *win);
void attr_selection_cb(GtkTreeSelection *selection, app_win *win);
void new_attr_cb(GtkWidget *button, app_win *win);
void save_cb(GtkWidget *button, app_win *win);
void quit_cb(GtkWidget *button, app_win *win);


#endif
