#include "ui.h"

struct label_table word_types[] = {
  {"一般名詞","nn"},
  {"サ変名詞(〜する)","sn"},
  {"形容動詞(〜だ)","vn"},
  {0, 0}
};

struct label_table word_attrs[] = {
  {"一般", "gn"},
  {"人名", "nm"},
  {"地名", "pl"},
  {"時事", "tm"},
  {"文化", "cl"},
  {"学術", "ac"},
  {0, 0}
};

static GtkWidget *
build_word_type_chooser()
{
  GtkWidget *combo;
  GtkListStore *model;
  GtkTreeIter iter;
  GtkCellRenderer *renderer;
  model = gtk_list_store_new(1, G_TYPE_STRING);

  int i;
  for (i = 0; word_types[i].label; i++) {
    const char *wt = word_types[i].label;
    gtk_list_store_append(model, &iter);
    gtk_list_store_set(model, &iter,
		       0, word_types[i].label,
		       -1);
  }

  combo = gtk_combo_box_new_with_model(GTK_TREE_MODEL(model));

  renderer = gtk_cell_renderer_text_new();
  gtk_cell_layout_pack_start(GTK_CELL_LAYOUT(combo), renderer, TRUE);
  gtk_cell_layout_set_attributes(GTK_CELL_LAYOUT(combo), renderer,
				 "text", 0, NULL);

  GtkTreePath *path;
  path = gtk_tree_path_new_from_indices (0, -1);
  gtk_tree_model_get_iter(GTK_TREE_MODEL(model), &iter, path);
  gtk_combo_box_set_active_iter(GTK_COMBO_BOX(combo), &iter);
  gtk_tree_path_free(path);

  return combo;
}

static void
build_attr_check_boxes(struct app_win *win, GtkWidget *vbox)
{
  int i;
  for (i = 0; word_attrs[i].label; i++) {
    word_attr_check_box box;
    box.check_box = gtk_check_button_new_with_label(word_attrs[i].label);
    gtk_box_pack_start(GTK_BOX (vbox), box.check_box, TRUE, TRUE, 0);
    gtk_widget_show(box.check_box);
    win->word_attr_checks.push_back(box);
  }
}

static GtkWidget *
add_window_create_field(const char *word, GtkWidget *vbox)
{
  GtkWidget *label;
  GtkWidget *entry;
  //
  label = gtk_label_new(word);
  gtk_widget_show(label);
  gtk_box_pack_start(GTK_BOX (vbox), label, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_RIGHT);
  //
  entry = gtk_entry_new_with_max_length (60);
  gtk_widget_show(entry);
  gtk_box_pack_start(GTK_BOX (vbox), entry, FALSE, FALSE, 0);

  return entry;
}


static GtkWidget *
build_add_word_window(struct app_win *win)
{
  GtkWidget *vbox;
  GtkWidget *add_hbbox;
  GtkWidget *add_button;
  GtkWidget *clear_button;
  GtkWidget *close_button;

  win->add_top = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(win->add_top), "Add new word");

  vbox = gtk_vbox_new(FALSE, 0);
  gtk_widget_show(vbox);
  gtk_container_add(GTK_CONTAINER(win->add_top), vbox);

  /**/
  win->entry_index = add_window_create_field("Index", vbox);
  win->entry_word = add_window_create_field("Word", vbox);

  win->type_chooser = build_word_type_chooser();
  gtk_widget_show(win->type_chooser);
  gtk_box_pack_start(GTK_BOX (vbox), win->type_chooser, TRUE, TRUE, 0);

  build_attr_check_boxes(win, vbox);

  /**/
  add_hbbox = gtk_hbutton_box_new();
  gtk_widget_show(add_hbbox);
  gtk_box_pack_start(GTK_BOX (vbox), add_hbbox, TRUE, TRUE, 0);
  gtk_button_box_set_layout(GTK_BUTTON_BOX (add_hbbox), GTK_BUTTONBOX_END);

  /**/
  add_button = gtk_button_new_with_label("Add");
  gtk_signal_connect(GTK_OBJECT(add_button), "clicked",
		     GTK_SIGNAL_FUNC(add_window_commit_cb),
		     win);
  gtk_container_add (GTK_CONTAINER (add_hbbox), add_button);
  gtk_widget_show(add_button);

  /**/
  clear_button = gtk_button_new_with_label("Clear");
  gtk_signal_connect(GTK_OBJECT(clear_button), "clicked",
		     GTK_SIGNAL_FUNC(add_window_clear_cb),
		     win);
  gtk_container_add (GTK_CONTAINER (add_hbbox), clear_button);
  gtk_widget_show(clear_button);

  /**/
  close_button = gtk_button_new_with_label("Close");
  gtk_signal_connect(GTK_OBJECT (close_button), "clicked",
                      GTK_SIGNAL_FUNC(add_window_close_cb),
                      win);
  gtk_container_add (GTK_CONTAINER (add_hbbox), close_button);
  gtk_widget_show(close_button);

}
static GtkWidget *
build_resource_window(struct app_win *win)
{
  GtkWidget *vbox;
  GtkWidget *hbox;
  GtkWidget *sw;
  GtkWidget *add_button;
  GtkWidget *update_button;
  GtkWidget *close_button;

  win->resource_top = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW (win->resource_top), "Resource List");
  gtk_widget_set_size_request(win->resource_top, 500, 320);
  
  vbox = gtk_vbox_new(FALSE, 0);
  gtk_widget_show(vbox);
  gtk_container_add(GTK_CONTAINER(win->resource_top), vbox);

  sw = gtk_scrolled_window_new(NULL, NULL);
  gtk_widget_show(sw);
  gtk_scrolled_window_set_shadow_type(GTK_SCROLLED_WINDOW (sw),
				       GTK_SHADOW_ETCHED_IN);
  gtk_box_pack_start (GTK_BOX (vbox), sw, TRUE, TRUE, 0);

  win->resource_model = build_resource_model();
  win->resource_view  = gtk_tree_view_new_with_model(win->resource_model);
  gtk_widget_show(win->resource_view);
  gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (win->resource_view), TRUE);

  add_column(GTK_TREE_VIEW(win->resource_view), "URL", RESOURCE_COL_URL);
  add_column(GTK_TREE_VIEW(win->resource_view), "Username", RESOURCE_COL_USERNAME);
  add_column(GTK_TREE_VIEW(win->resource_view), "Status", RESOURCE_COL_STATUS);
  add_column(GTK_TREE_VIEW(win->resource_view), "Filter", RESOURCE_COL_FILTER);

  gtk_container_add(GTK_CONTAINER(sw), win->resource_view);

  /**/
  hbox = gtk_hbox_new(TRUE, 0);
  gtk_widget_show(hbox);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, TRUE, 0);

  /**/
  add_button = gtk_button_new_with_label("Add");
  gtk_widget_show(add_button);
  gtk_signal_connect(GTK_OBJECT (add_button), "clicked",
		     GTK_SIGNAL_FUNC(resource_window_show_add_url_cb),
		     win);
  gtk_box_pack_start(GTK_BOX (hbox), add_button, FALSE, TRUE, 0);

  /**/
  update_button = gtk_button_new_with_label("Update");
  gtk_widget_show(update_button);
  gtk_signal_connect(GTK_OBJECT (update_button), "clicked",
                      GTK_SIGNAL_FUNC(resource_window_update_cb),
                      win);
  gtk_box_pack_start(GTK_BOX (hbox), update_button, FALSE, TRUE, 0);

  /**/
  close_button = gtk_button_new_with_label("Close");
  gtk_widget_show(close_button);
  gtk_signal_connect(GTK_OBJECT (close_button), "clicked",
                      GTK_SIGNAL_FUNC(resource_window_close_cb),
                      win);
  gtk_box_pack_start(GTK_BOX (hbox), close_button, FALSE, TRUE, 0);


  /* */
  g_signal_connect(G_OBJECT(win->resource_view), "delete_event",
		    G_CALLBACK(resource_window_close_cb), NULL);
}


static void
build_resource_window_add_url_window(struct app_win *win)
{
  GtkWidget *add_button;
  GtkWidget *url_label;
  GtkWidget *hbox;

  win->add_url_top = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (win->add_url_top), "Add Resource URL");
  gtk_widget_set_size_request (win->add_url_top, 500, 30);

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox);
  gtk_container_add (GTK_CONTAINER(win->add_url_top), hbox);
		    
  url_label = gtk_label_new ("URL");
  gtk_widget_show (url_label);
  gtk_box_pack_start (GTK_BOX (hbox), url_label, TRUE, TRUE, 0);
  
  win->add_url_entry = gtk_entry_new();
  gtk_widget_show (win->add_url_entry);
  gtk_box_pack_start (GTK_BOX (hbox), win->add_url_entry, TRUE, TRUE, 0);
  
  add_button = gtk_button_new_with_mnemonic ("Add");
  gtk_widget_show (add_button);
  gtk_box_pack_start (GTK_BOX (hbox), add_button, FALSE, FALSE, 0);
  
  gtk_signal_connect (GTK_OBJECT (add_button), "clicked",
		      GTK_SIGNAL_FUNC(resource_window_add_url_cb),
		      win);
  /* */
  g_signal_connect (G_OBJECT(win->resource_view), "delete_event",
		    G_CALLBACK(resource_window_close_add_url_cb), 
		    win);
}

static GtkWidget *
build_menu(struct app_win *win)
{
  GtkWidget *menu_bar;
  GtkWidget *file_menu;
  GtkWidget *word_menu;
  GtkWidget *resource_menu;
  GtkWidget *file_item;
  GtkWidget *word_item;
  GtkWidget *resource_item;
  GtkWidget *quit_item;
  GtkWidget *add_item;
  GtkWidget *list_item;

  menu_bar = gtk_menu_bar_new();
  file_menu = gtk_menu_new();
  word_menu = gtk_menu_new();
  resource_menu = gtk_menu_new();

  file_item = gtk_menu_item_new_with_label("File");
  quit_item = gtk_menu_item_new_with_label("Quit");
  word_item = gtk_menu_item_new_with_label("Word");
  add_item = gtk_menu_item_new_with_label("Add new word");
  resource_item = gtk_menu_item_new_with_label("Resource");
  list_item = gtk_menu_item_new_with_label("List");

  gtk_menu_shell_append(GTK_MENU_SHELL(file_menu), quit_item);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (file_item), file_menu);

  gtk_menu_shell_append(GTK_MENU_SHELL(word_menu), add_item);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (word_item), word_menu);

  gtk_menu_shell_append(GTK_MENU_SHELL(resource_menu), list_item);
  gtk_menu_item_set_submenu(GTK_MENU_ITEM (resource_item), resource_menu);

  gtk_menu_bar_append(GTK_MENU_BAR (menu_bar), file_item);
  gtk_menu_bar_append(GTK_MENU_BAR (menu_bar), word_item);
  gtk_menu_bar_append(GTK_MENU_BAR (menu_bar), resource_item);

  g_signal_connect(G_OBJECT(add_item), "activate",
		   GTK_SIGNAL_FUNC(add_window_show_cb),
		   win);
  g_signal_connect(G_OBJECT(list_item), "activate",
		   GTK_SIGNAL_FUNC(resource_window_show_cb),
		   win);
  g_signal_connect(G_OBJECT(quit_item), "activate",
		   GTK_SIGNAL_FUNC(quit_cb),
		   win);

  gtk_widget_show(quit_item);
  gtk_widget_show(file_item);
  gtk_widget_show(file_menu);

  gtk_widget_show(add_item);
  gtk_widget_show(word_item);
  gtk_widget_show(word_menu);

  gtk_widget_show(list_item);
  gtk_widget_show(resource_item);
  gtk_widget_show(resource_menu);

  gtk_widget_show(menu_bar);

  return menu_bar;
}

static void
build_button_bar(struct app_win *win, GtkWidget *vbox)
{
  GtkWidget *hbox;
  GtkWidget *quit_button;
  GtkWidget *save_button;
  GtkWidget *sign_button;

  hbox = gtk_hbox_new(TRUE, 0);
  gtk_widget_show(hbox);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, TRUE, 0);
  //
  sign_button = gtk_button_new_with_mnemonic("MySign");
  gtk_widget_show(sign_button);
  gtk_box_pack_start (GTK_BOX (hbox), sign_button, FALSE, TRUE, 0);

  save_button = gtk_button_new_from_stock("gtk-save");
  gtk_widget_show(save_button);
  gtk_box_pack_start (GTK_BOX (hbox), save_button, FALSE, TRUE, 0);

  quit_button = gtk_button_new_from_stock("gtk-quit");
  gtk_widget_show(quit_button);
  gtk_box_pack_start (GTK_BOX (hbox), quit_button, FALSE, TRUE, 0);


  gtk_signal_connect(GTK_OBJECT(sign_button), "clicked",
		     GTK_SIGNAL_FUNC(new_attr_cb),
		     win);
  gtk_signal_connect(GTK_OBJECT(save_button), "clicked",
		     GTK_SIGNAL_FUNC(save_cb),
		     win);
  gtk_signal_connect(GTK_OBJECT(quit_button), "clicked",
		     GTK_SIGNAL_FUNC(quit_cb),
		     win);
}

static void
add_column(GtkTreeView *treeview, const char *name, int idx)
{
  GtkCellRenderer *renderer;
  GtkTreeViewColumn *column;
  
  renderer = gtk_cell_renderer_text_new();
  column = gtk_tree_view_column_new_with_attributes(name,
						    renderer,
						    "text", idx,
						    NULL);

  // gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
  //				   GTK_TREE_VIEW_COLUMN_FIXED);
  // gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 100);
  gtk_tree_view_column_set_sort_column_id(column, 1);
  gtk_tree_view_append_column (treeview, column);
}

static void
add_word_view_column(struct app_win *aw, GtkTreeView *treeview)
{
  GtkCellRenderer *renderer;
  GtkTreeViewColumn *column;
  /**/
  add_column(treeview, "Word", 1);
  /**/
  add_column(treeview, "Index", 2);
}

static void
add_attr_view_column(struct app_win *aw, GtkTreeView *treeview)
{
  GtkCellRenderer *renderer;
  GtkTreeViewColumn *column;
  /**/
  add_column(treeview, "Name", SIGN_COL_USER);
  add_column(treeview, "Stamp", SIGN_COL_STAMP);
  add_column(treeview, "Ok?", SIGN_COL_IS_OK);
  add_column(treeview, "Attribute", SIGN_COL_ATTR);
}

static GtkTreeModel *
build_resource_model()
{
  GtkListStore *model;
  model = gtk_list_store_new(5,
			     G_TYPE_POINTER, // resource itself
			     G_TYPE_STRING,  // url
			     G_TYPE_STRING,  // username
			     G_TYPE_STRING,  // status
			     G_TYPE_STRING   // filter
			     );
  return GTK_TREE_MODEL(model);
}

static GtkTreeModel *
build_words_model()
{
  GtkListStore *model;
  model = gtk_list_store_new(3,
			     G_TYPE_POINTER,
			     G_TYPE_STRING,
			     G_TYPE_STRING);
  return GTK_TREE_MODEL(model);
}

static GtkTreeModel *
build_attr_model()
{
  GtkListStore *model;
  model = gtk_list_store_new(5,
			     G_TYPE_POINTER,
			     G_TYPE_STRING, // stamp
			     G_TYPE_STRING, // user
			     G_TYPE_STRING, // day
			     G_TYPE_STRING  // approve
			     );
  return GTK_TREE_MODEL(model);
}

static void
build_tree_view(struct app_win *aw, GtkWidget *vbox)
{
  GtkWidget *words_sw;
  GtkWidget *attr_sw;

  words_sw = gtk_scrolled_window_new(NULL, NULL);
  gtk_widget_show(words_sw);

  gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (words_sw),
				       GTK_SHADOW_ETCHED_IN);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (words_sw),
				  GTK_POLICY_NEVER,
				  GTK_POLICY_AUTOMATIC);
  gtk_box_pack_start (GTK_BOX (vbox), words_sw, TRUE, TRUE, 0);

  aw->words_model = build_words_model();
  aw->words_view = gtk_tree_view_new_with_model(aw->words_model);
  gtk_widget_show(aw->words_view);
  add_word_view_column(aw, GTK_TREE_VIEW(aw->words_view));
  gtk_widget_set_size_request(aw->words_view, 500, 150);
  gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (aw->words_view), TRUE);
  gtk_container_add(GTK_CONTAINER(words_sw), aw->words_view);

  /* */
  attr_sw = gtk_scrolled_window_new(NULL, NULL);
  gtk_widget_show(attr_sw);
  gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (attr_sw),
				       GTK_SHADOW_ETCHED_IN);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (attr_sw),
				  GTK_POLICY_NEVER,
				  GTK_POLICY_AUTOMATIC);
  gtk_box_pack_start (GTK_BOX (vbox), attr_sw, TRUE, TRUE, 0);

  aw->attr_model = build_attr_model();
  aw->attr_view = gtk_tree_view_new_with_model(aw->attr_model);
  gtk_widget_show(aw->attr_view);
  add_attr_view_column(aw, GTK_TREE_VIEW(aw->attr_view));
  gtk_widget_set_size_request(aw->attr_view, 500, 150);
  gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (aw->attr_view), TRUE);
  gtk_container_add(GTK_CONTAINER(attr_sw), aw->attr_view);

  /* */
  GtkTreeSelection *selection;
  selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(aw->words_view));
  g_signal_connect(selection, "changed",
		   G_CALLBACK(word_selection_cb), aw);
  selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(aw->attr_view));
  g_signal_connect(selection, "changed",
		   G_CALLBACK(attr_selection_cb), aw);
}

void
build_app_win(struct app_win *win, GtkWidget *vbox)
{
  build_tree_view(win, vbox);
  build_button_bar(win, vbox);
}

void
build_win(app_win *win)
{
  win->main_top = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(win->main_top), "fossil ui");

  g_signal_connect(G_OBJECT(win->main_top), "delete_event",
		   G_CALLBACK(quit_cb), NULL);

  GtkWidget *vbox;
  vbox = gtk_vbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(win->main_top), vbox);

  GtkWidget *menu_bar;
  menu_bar = build_menu(win);
  gtk_box_pack_start(GTK_BOX(vbox), menu_bar, FALSE, FALSE, 0);

  build_app_win(win, vbox);
  
  gtk_widget_show(vbox);
  gtk_widget_show(win->main_top);
  
  // Just create these windows at here (not show) 
  build_add_word_window(win); 
  build_resource_window(win);
  build_resource_window_add_url_window(win);
 
}
/*
  Local Variables:
  coding: utf-8
  End:
 */
