// fossil 0.6 word storage backend program
//
#include <iostream>
#include <stdio.h>
#include <string.h>
#include <pwd.h>
//#include "db.h"
#include "word.h"
#include "reader.h"
#include "storage.h"
#include "misc.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif // HAVE_CONFIG_H

#ifndef __VERSION_H__
#include "version.h"
#endif // __VERSION_H__


using namespace std;

#define USAGE \
 "fossil, a distributed dictionary share tool. %s \n"\
 "fossil-backend [options]\n"\
 " --help: Show this usage text\n"\
 " --version: Show version\n"\
 " --dump: Show stored information\n"\
 " --add-word: Add a new word\n"\
 " --read <filename>: Read and add words from the file\n"\
 " --update-index: update index list \n"\
 "\n"

static void
print_usage()
{
  printf(USAGE, VERSION);

  exit(0);
}

Storage *
create_storage()
{
  char path[50];
  static struct passwd *pw;

  pw = getpwuid(getuid());
  snprintf(path,sizeof(path),"%s/.fossil/_dict/",pw->pw_dir);

  return new Storage(path);
}

static void
read_file(int argc, char **argv)
{
  printf("read file\n");
  int i;

  Storage *st = create_storage();
  st->check();

  Ident *id = new Ident();
  Stamp *stamp = id->get_stamp();
  char stamp_buf[10];
  stamp->get_str(stamp_buf);
  printf("Ident name=[%s], time=[%s]\n",
	 id->get_name(), stamp_buf);

  Reader *r = new Reader();
  for (i = 1; i < argc; i++) {
    printf(" (%s)\n", argv[i]);
    r->read_file(st, id, argv[i]);
  }

  st->update();

  exit(0);
}

static void
update_index(int argc, char **argv)
{
  Storage *st = create_storage();
  st->update_index();
}

static void
diff_words(int argc, char **argv)
{
  Storage *st = create_storage();
  int i;
  for (i = 1; i < argc; i++) {
    FILE *fp = fopen(argv[i], "r");
    if (!fp) {
      continue;
    }
    char buf[1024];
    while (fgets(buf, 1024, fp)) {
      DictLine dl(buf);
    }
  }
}

static void
dump_file(int argc, char **argv)
{
  Storage *st = create_storage();
  st->dump();
}

int
main(int argc, char **argv)
{
  init_word();
  //DB *d = DB::openDB("tmp");
  //d->execute("PRAGMA database_list;", NULL, NULL);

  int i;
  argv ++;
  for (i = 1; i < argc; i++) {
    char *arg = argv[0];
    int nr = argc - i;
    if (!strcmp(arg, "--help")) {
      print_usage();
    } else if (!strcmp(arg, "--read")) {
      read_file(nr, argv);
    } else if (!strcmp(arg, "--dump")) {
      dump_file(nr, argv);
    } else if (!strcmp(arg, "--update-index")) {
      update_index(nr, argv);
    } else if (!strcmp(arg, "--diff")) {
      diff_words(nr, argv);
    } else if (!strcmp(arg, "--user")) {
      argv ++;
      i++;
      set_user_name(argv[0]);
    } else if (!strcmp(arg, "--encoding")) {
      argv ++;
      i++;
      set_encoding(argv[0]);
    } else {
      print_usage();
    }
    //
    argv ++;
  }

  
  return 0;
}
