#include <unistd.h>
#include <sys/types.h>
#include <pwd.h>
#include <time.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "misc.h"

static const char *current_user_name;

Stamp::Stamp()
{
  time_t now;
  struct tm *t;
  time(&now);
  t = localtime(&now);
  m_stamp = (t->tm_year - 100) * 1000000 +
    (t->tm_mon + 1) * 10000 +
    t->tm_mday * 100 +
    t->tm_hour;
}

Stamp::Stamp(const char *s)
{
  m_stamp = atoi(s);
}

Stamp::Stamp(int n)
{
  m_stamp = n;
}

int
Stamp::get_stamp()
{
  return m_stamp;
}

void
Stamp::get_str(char *str)
{
  sprintf(str, "%.8d", m_stamp);
}

Ident::Ident()
{
  m_stamp = new Stamp();
  //
  m_name = get_user_name();
}

Ident::~Ident()
{
}

const char *
Ident::get_name()
{
  return m_name;
}

Stamp *
Ident::get_stamp()
{
  return m_stamp;
}

void
set_user_name(const char *name)
{
  current_user_name = strdup(name);
}

const char *
get_user_name()
{
  if (!current_user_name) {
    struct passwd *pw = getpwuid(getuid());
    current_user_name = pw->pw_name;
  }
  return current_user_name;
}
