#include <ctype.h>
#include <string.h>
#include "reader.h"
#include "storage.h"
#include "word.h"
#include "misc.h"

char *
do_gets(gzFile fp, char *buf, int size)
{
  if (fp) {
    return gzgets(fp, buf, size);
  }
  return fgets(buf, size, stdin);
}

bool
is_approve(const char *str)
{
  if (!strcmp(str, "ok")) {
    return true;
  }
  return false;
}

DictLine::DictLine(char *line)
{
  char buf1[128];
  char buf2[1284];

  nr = sscanf(line, "%s %s %s %s %s %s",
              index, word, buf1, user, attr, buf2);

  if (nr == 6) {
    if (!strcmp(buf1, "?")) {
      // default constructor may setup
    } else {
      stamp = Stamp(buf1);
    }
    if (!strcmp(user, "?")) {
      sprintf(user, "%s", get_user_name());
    }
    approve = is_approve(buf2);
  }
}

Reader::Reader()
{
}

void
Reader::read_file(Storage *st, Ident *id, const char *fn)
{
  if (fn) {
    gzFile fp;
    fp = gzopen(fn, "r");
    if (fp) {
      do_read_file(st, id, fp);
      gzclose(fp);
    }
  } else {
    do_read_file(st, id, NULL);
  }
}

void
Reader::add_word(Storage *st, const char *name, Stamp stamp,
		 const char *attr, bool approve,
		 const char *index, const char *word)
{
  char *s1 = to_utf8(index);
  char *s2 = to_utf8(word);
  st->add_word(name, stamp, attr, approve, s1, s2);
  free(s1);
  free(s2);
}

void
Reader::do_read_file(Storage *st, Ident *id, gzFile fp)
{
  char buf[1024];
  while (do_gets(fp, buf, 1024)) {
    if (isspace((unsigned char)buf[0]) ||
	buf[0] == '#') {
      continue;
    }
    chomp(buf);
    //
    DictLine dl(buf);
    //
    if (dl.nr == 6) {
      add_word(st, dl.user, dl.stamp, dl.attr, dl.approve, dl.index, dl.word);
    } else if (dl.nr == 2) {
      add_word(st, id->get_name(), *(id->get_stamp()),
	       "add", true, dl.index, dl.word);
    }
  }
}

void
Reader::chomp(char *buf)
{
  int len = strlen(buf);
  if (len > 1 && buf[len - 1] == '\n') {
    buf[len - 1] = 0;
  }
}
