// -*- C++ -*-
#ifndef _reader_h_included_
#define _reader_h_included_

#include <stdio.h>
#include <zlib.h>
#include "misc.h"

class Storage;
class Ident;

struct DictLine {
  DictLine(char *line);
  int nr;
  char index[1024];
  char word[1024];
  char user[1024];
  char attr[1024];
  Stamp stamp;
  bool approve;
private:
};

class Reader {
public:
  Reader();
  void read_file(Storage *st, Ident *id, const char *fn);
private:
  void do_read_file(Storage *st, Ident *id, gzFile fp);
  void add_word(Storage *st, const char *name, Stamp stamp,
		const char *attr, bool approve, const char *index,
		const char *word);
  void chomp(char *buf);
};

char *do_gets(gzFile fp, char *buf, int size);
bool is_approve(const char *str);

#endif
