#include "resource.h"

#define MAXBUFSIZE 1024

ResourceManager::ResourceManager(const char *filename){
  read_resource_file(filename);
}


Resource *
ResourceManager::add_resource(const char *url, const char *username,
			      const char *status, const char *filter)
{
  Resource *r = find_resource_by_url(url);
  if (r) {
    return false; // already has
  }

  // create new resource 
  r = new Resource();
  r->url = strdup(url);
  r->username = strdup(username);
  r->status = strdup(status);
  r->filter = strdup(filter);
  resource_array.push_back(r);

  return r;
}

Resource *
ResourceManager::find_resource_by_url(const char *url)
{
  std::list <Resource *>::iterator it;

  for (it = resource_array.begin();
       it != resource_array.end();it++){
    Resource *r = *it;

    if (!strcmp(url, r->url)){
      return r;
    }
  }
  return NULL;
}

void
ResourceManager::read_resource_file(const char *filename){
  FILE *fp;
  char line[MAXBUFSIZE];
  int index;
  char *url;
  char *username;
  char *status;
  char *filter;

  Resource *r_tmp;

  if ((fp = fopen(filename,"r")) == NULL){
    printf("Could not open resource list : %s\n",filename);
    printf("Creating...\n");
    system("fossil --update-url");
    if ((fp = fopen(filename,"r")) == NULL){ // try agein 
      printf("Could not open resource list : %s\n",filename);
      printf("Giving up.\n");
      exit(1);
    }
    printf("Done...\n");
  }

  fgets(line, MAXBUFSIZE, fp); // skip the first comment line
  while ((fgets(line, MAXBUFSIZE, fp) != NULL)){
    index = atoi(strtok(line,","));
    url = strtok(NULL,",");
    if (url == NULL) // skip blank line
      continue;
    username = strtok(NULL,",");
    status = strtok(NULL,",");
    filter = strtok(NULL,"\n"); // cut the last '\n'

    printf("%d:%s %s %s %s\n", index, url, username, status, filter);
    r_tmp = add_resource(url, username, status, filter);
  }
  fclose(fp);
}
