// -*- C++ -*-
#ifndef _resource_h_included_
#define _resource_h_included_

#include <list>

class ResourceManager;
class Resource;

class ResourceManager {
public:
  ResourceManager(const char *filename);
  ~ResourceManager();

  std::list <Resource *> resource_array;

  void read_resource_file(const char *filename);
  Resource *add_resource(const char *url, const char *username,
			 const char *status, const char *filter); 
  Resource *find_resource_by_username(const char *username);
  Resource *find_resource_by_url(const char *url);

};

class Resource {
public:
  int index;
  char *url;
  char *username;
  char *status;
  char *filter;
};

#endif
