// fossil 0.6 GUI frontend program
//
#include <stdio.h>
#include <stdlib.h>
#include "ui.h"
#include "resource.h"
#include "reader.h"
#include <pwd.h>

static void do_dump();
static void read_words(WordSet *ws, const char *fn);
static void clear_words(struct app_win *win);

const char *
find_label_by_tag(label_table *tab, const char *tag)
{
  while (tab->label) {
    if (!strcmp(tab->tag, tag)) {
      return tab->label;
    }
    tab ++;
  }
  return NULL;
}

static void
add_word_output_attr(FILE *fp, const char *index,
		     const char *word, const char *attr)
{
  fprintf(fp, "%s %s ? ? %s ok\n", index, word, attr);
}

void
add_window_do_add_word(struct app_win *win, const char *index,
		       const char *word)
{
  int type;
  type = gtk_combo_box_get_active(GTK_COMBO_BOX(win->type_chooser));
  printf("add index=(%s) word=(%s) type=(%d)\n",index, word, type);

  FILE *fp ;
  fp = fopen("tmp-tmp", "w");
  if (!fp) {
    return ;
  }

  add_word_output_attr(fp, index, word, "add");
  add_word_output_attr(fp, index, word, word_types[type].tag);
  int i;
  for (i = 0; i < win->word_attr_checks.size(); i++) {
    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(win->word_attr_checks[i].check_box))) {
      add_word_output_attr(fp, index, word, word_attrs[i].tag);
    }
  }
  fclose(fp);

  system("fossil-backend --encoding utf-8 --read tmp-tmp");
}

void
add_window_commit_cb(const GtkWidget *widget,
		     struct app_win *win)
{
  const gchar *index;
  const gchar *word;

  index = gtk_entry_get_text(GTK_ENTRY(win->entry_index));
  word = gtk_entry_get_text(GTK_ENTRY(win->entry_word));
  if (!index || !strlen(index) ||
      !word || !strlen(word)) {
    return ;
  }
  printf("add index=(%s) word=(%s)\n",index, word);

  add_window_do_add_word(win, index, word);
  //
  do_dump();
  clear_words(win);
  read_words(win->ws, "tmp-tmp");
  update_words_model(win);
}

void
add_window_clear_cb(const GtkWidget *widget,
		     struct app_win *win)
{
  gtk_entry_set_text(GTK_ENTRY(win->entry_index), "");
  gtk_entry_set_text(GTK_ENTRY(win->entry_word), "");
}


void
add_window_show_cb(const GtkWidget *widget, struct app_win *win)
{
  gtk_widget_show(win->add_top);
}

void
add_window_close_cb(const GtkWidget *close_button, struct app_win *win)
{
  system("fossil-backend --update-index");
  gtk_widget_hide(win->add_top);
}

void
resource_window_show_cb(const GtkWidget *widget, struct app_win *win)
{
  gtk_widget_show(win->resource_top);
}

void
resource_window_add_url_cb(const GtkWidget *button, struct app_win *win)
{
  char system_line[40];

  printf("fossil --add-url %s\n", 
	 gtk_entry_get_text(GTK_ENTRY(win->add_url_entry)));
  snprintf(system_line, sizeof(system_line),"fossil --add-url %s",
	 gtk_entry_get_text(GTK_ENTRY(win->add_url_entry)));

  system(system_line);

  resource_window_close_add_url_cb(button, win);
  resource_window_update_list(win);
}

void
resource_window_close_add_url_cb(const GtkWidget *button, struct app_win *win)
{
  gtk_widget_hide(win->add_url_top);
}

void
resource_window_show_add_url_cb(const GtkWidget *button, struct app_win *win)
{
  gtk_widget_show(win->add_url_top);
}

void
resource_window_update_cb(const GtkWidget *widget, struct app_win *win)
{
  system("fossil --update-url");
  resource_window_update_list(win);
}

void
resource_window_close_cb(const GtkWidget *button, struct app_win *win)
{
  gtk_widget_hide(win->resource_top);
}

void
resource_window_update_list(struct app_win *win)
{
  gtk_list_store_clear(GTK_LIST_STORE(win->resource_model));

  std::list<Resource *>::iterator it;
  GtkTreeIter iter;

  for (it = win->rsmanagr->resource_array.begin();
       it != win->rsmanagr->resource_array.end(); it++){
    Resource *r = *it;

    gtk_list_store_append(GTK_LIST_STORE(win->resource_model), &iter);
    gtk_list_store_set(GTK_LIST_STORE(win->resource_model), &iter,
		       RESOURCE_COL_RESOURCE, r,
		       RESOURCE_COL_URL,      r->url,
		       RESOURCE_COL_USERNAME, r->username,
		       RESOURCE_COL_STATUS,   r->status,
		       RESOURCE_COL_FILTER,   r->filter,
		       -1);
  }

}

static void
do_dump()
{
  system("fossil-backend --dump > tmp-tmp");
}

static const char *
get_attr_string(Attr *a)
{
  const char *attr;
  attr = find_label_by_tag(word_attrs, a->m_attr);
  if (!attr) {
    attr = a->m_attr;
  }
  return attr;
}

static void
update_word_attrs(app_win *aw, Word *w)
{
  gtk_list_store_clear(GTK_LIST_STORE(aw->attr_model));
  if (!w) {
    return ;
  }
  std::list<Attr *>::iterator it;
  for (it = w->m_attrs.begin(); it != w->m_attrs.end(); it++) {
    Attr *a = *it;
    std::list<Sign *>::iterator jt;
    for (jt = a->m_signs.begin(); jt != a->m_signs.end(); jt++) {
      Sign *s = *jt;
      GtkTreeIter iter;
      char buf[10];
      const char *attr = get_attr_string(a);
      //
      s->m_stamp.get_str(buf);
      gtk_list_store_append(GTK_LIST_STORE(aw->attr_model), &iter);
      gtk_list_store_set(GTK_LIST_STORE(aw->attr_model), &iter,
			 SIGN_COL_SIGN, s,
			 SIGN_COL_USER, s->m_user,
			 SIGN_COL_STAMP, buf,
			 SIGN_COL_IS_OK, s->m_is_ok ? "ok" : "ng",
			 SIGN_COL_ATTR, attr,
			 -1);
    }
  }
}

void
word_selection_cb(GtkTreeSelection *selection,
		  app_win *win)
{
  GtkTreeIter iter;
  GValue value = {0};
  const char *s;

  if (!gtk_tree_selection_get_selected(selection, NULL, &iter)) {
    win->current_word = NULL;
    win->current_sign = NULL;
    update_word_attrs(win, NULL);
    return ;
  }

  gtk_tree_model_get_value(win->words_model, &iter,
			   0, &value);
  //
  Word *w = (Word *)g_value_get_pointer(&value);
  if (w != win->current_word) {
    win->current_sign = NULL;
  }
  win->current_word = w;
  g_value_unset(&value);
  update_word_attrs(win, w);
}

void
check_cb(GtkWidget *ok_check,
	 app_win *win)
{
  Sign *sign = win->current_sign;
  if (!sign) {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(win->ok_check), 0);
    return ;
  }
  if (!strcmp(sign->m_user, get_user_name())) {
    // my decision
    int active;
    active = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(win->ok_check));
    if (active) {
      sign->m_is_ok = true;
    } else {
      sign->m_is_ok = false;
    }
  } else {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(win->ok_check),
				 sign->m_is_ok);
  }
  update_word_attrs(win, win->current_word);
}

void
new_attr_cb(GtkWidget *button, app_win *win)
{
  if (!win->current_word) {
    return ;
  }
  Stamp stamp;
  win->ws->add_word(get_user_name(), stamp,
		    "add", true,
		    win->current_word->m_index,
		    win->current_word->m_word);
  update_word_attrs(win, win->current_word);
}

void
quit_cb(GtkWidget *button, app_win *win)
{
  gtk_exit(0);
}

void
save_cb(GtkWidget *button, app_win *win)
{
  FILE *fp = fopen("tmp-tmp", "w");
  if (!fp) {
    fprintf(stderr, "failed to open tmpfile.\n");
    return ;
  }
  win->ws->write_words(fp, NULL);
  fclose(fp);
  system("fossil-backend --read tmp-tmp");
  system("fossil-backend --update-index");
  fprintf(stderr, "save done\n");
}

void
attr_selection_cb(GtkTreeSelection *selection,
		  app_win *win)
{
  GtkTreeIter iter;
  GValue value = {0};
  const char *s;
  if (!gtk_tree_selection_get_selected(selection, NULL, &iter)) {
    win->current_sign = NULL;
    return ;
  }

  gtk_tree_model_get_value(win->attr_model, &iter,
			   0, &value);
  Sign *sign;
  sign = (Sign *)g_value_get_pointer(&value);
  win->current_sign = sign;
  g_value_unset(&value);
  if (sign) {
    if (sign->m_is_ok)
      sign->m_is_ok = false;
    else
      sign->m_is_ok = true;
    update_word_attrs(win, win->current_word);
  }
}

void
update_words_model(struct app_win *aw)
{
  gtk_list_store_clear(GTK_LIST_STORE(aw->words_model));

  std::list<Word *>::iterator it;
  GtkTreeIter iter;

  for (it = aw->ws->m_word_array.begin();
       it != aw->ws->m_word_array.end(); it++) {
    Word *w = *it;

    gtk_list_store_append(GTK_LIST_STORE(aw->words_model), &iter);
    gtk_list_store_set(GTK_LIST_STORE(aw->words_model), &iter,
		       0, w,
		       1, w->m_index,
		       2, w->m_word,
		       -1);

  }
}

static void
clear_words(struct app_win *win)
{
  if (win->ws) {
    delete win->ws;
    win->ws = NULL;
  }
  win->ws = new WordSet();
}

static void
read_words(WordSet *ws, const char *fn)
{
  FILE *fp = fopen(fn, "r");
  if (!fp) {
    return ;
  }
  char buf[1024];
  while (fgets(buf, 1024, fp)) {
    DictLine dl(buf);
    if (dl.nr != 6) {
      continue;
    }
    ws->add_word(dl.user, dl.stamp,
		 dl.attr, dl.approve,
		 dl.index, dl.word);
  }
  fclose(fp);
}

int
main(int argc, char **argv)
{
  char path[50];
  struct app_win win;
  win.ws = new WordSet();
  do_dump();
  fprintf(stderr, "dump words done\n");
  read_words(win.ws, "tmp-tmp");
  fprintf(stderr, "load words done\n");
  gtk_init(&argc, &argv);
  win.current_sign = NULL;
  win.current_word = NULL;
  
  pw = getpwuid(getuid());
  snprintf(path,sizeof(path),"%s/.fossil/_dict/urllist",pw->pw_dir);
  //  snprintf(tmp_file_path,sizeof(tmp_file_path),"%s/.fossil/tmp-tmp",pw->pw_dir);

  win.rsmanagr = new ResourceManager(path);

  build_win(&win);

  update_words_model(&win);

  resource_window_update_list(&win);
  
  gtk_main();
  return 0;
}
