// -*- C++ -*-
#ifndef _ui_h_included_
#define _ui_h_included_

#include <gtk/gtk.h>
#include "word.h"
#include "storage.h"
#include "resource.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

class ResourceManager;
class Resource;

struct label_table {
  const char *label;
  const char *tag;
};

struct word_attr_check_box {
  GtkWidget *check_box;
};

struct app_win {
  GtkWidget *main_top;
  //
  GtkTreeModel *words_model;
  GtkWidget *words_view;
  Word *current_word;
  //
  GtkTreeModel *attr_model;
  GtkWidget *attr_view;
  //
  WordSet *ws;

  // edit window
  GtkWidget *ok_check;
  Sign *current_sign;

  // add window
  GtkWidget *add_top;
  GtkWidget *entry_index;
  GtkWidget *entry_word;
  GtkWidget *type_chooser;
  std::vector<word_attr_check_box> word_attr_checks;

  // resource window
  ResourceManager *rsmanagr; 
  GtkWidget *resource_top;
  GtkTreeModel *resource_model;
  GtkWidget *resource_view;
  // add url
  GtkWidget *add_url_top;
  GtkWidget *add_url_entry;


};

enum {
  SIGN_COL_SIGN,
  SIGN_COL_USER,
  SIGN_COL_STAMP,
  SIGN_COL_IS_OK,
  SIGN_COL_ATTR
};

enum {
  RESOURCE_COL_RESOURCE,
  RESOURCE_COL_URL,
  RESOURCE_COL_USERNAME,
  RESOURCE_COL_STATUS,
  RESOURCE_COL_FILTER
};


static gchar *labels[] = {
  ("Orange"),
  ("Red") ,
  ("Pink"),
  ("Sky blue"),
  ("Blue"),
  ("Green"),
  ("Brown")
};

static GdkColor untrusted_color = {
  (gulong)0,
  (gushort)0xefff,
  (gushort)0,
  (gushort)0
};
static GdkColor normal_color = {
  (gulong)0,
  (gushort)0xff,
  (gushort)0xff,
  (gushort)0xff
};

extern label_table word_types[];
extern label_table word_attrs[];

static struct passwd *pw;
static char tmp_file_path[40];

void build_win(app_win *win);
void check_cb(GtkWidget *ok_check, app_win *win);
void word_selection_cb(GtkTreeSelection *selection, app_win *win);
void attr_selection_cb(GtkTreeSelection *selection, app_win *win);
void new_attr_cb(GtkWidget *button, app_win *win);
void save_cb(GtkWidget *button, app_win *win);
void quit_cb(GtkWidget *button, app_win *win);
void update_words_model(struct app_win *aw);
static void add_column(GtkTreeView *treeview, const char *name, int idx);
static void add_word_view_column(struct app_win *aw, GtkTreeView *treeview);
static void add_attr_view_column(struct app_win *aw, GtkTreeView *treeview);

// add_window callback functions
void add_window_commit_cb(const GtkWidget *widget, struct app_win *win); 
void add_window_close_cb(const GtkWidget *close_button, struct app_win *win);
void add_window_clear_cb(const GtkWidget *clear_button, struct app_win *win);
void add_window_show_cb(const GtkWidget *widget, struct app_win *win); 

// resource window callback functions
void resource_window_show_cb(const GtkWidget *widget, struct app_win *win); 
void resource_window_update_cb(const GtkWidget *widget, struct app_win *win); 
void resource_window_add_cb(const GtkWidget *widget, struct app_win *win); 
void resource_window_close_cb(const GtkWidget *button, struct app_win *win);
void resource_window_add_url_cb(const GtkWidget *button, struct app_win *win);
void resource_window_close_add_url_cb(const GtkWidget *button, struct app_win *win);
void resource_window_show_add_url_cb(const GtkWidget *button, struct app_win *win);
void resource_window_update_list(struct app_win *win);


static GtkTreeModel * build_resource_model();

const char *find_label_by_tag(label_table *tab, const char *tag);

#endif
