///    freq_to_transition
//
//ʸ᥯饹A-Bf(A,B)顢
//ʸ᥯饹A->BʬϤޤ
/*
Copyright (C) 2006  hanaoka

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/  


#include <iostream>
#include <string>
#include <iomanip>
using namespace std;

#define SEGSIZE 39
#define EPS 0.01
enum MODE{
  TRANSITION, //ܳΨ
  CONDITIONAL //
};
MODE mode = CONDITIONAL;
bool f_comma = false;
bool f_nz = false;

void print_usage(){
  printf("freq_to_transition\n");
  printf("ʸ᥯饹A-Bf(A,B)顢ʸ᥯饹A->BʬϤޤ\n");
  printf("\n");
  printf(" $ ./freq_to_transition <option> .. < [input-file]\n\n");
  printf("\n");
  printf("-t\n");
  printf("//A->BνиΨp(A,B)M[A][B]Ȥɸ\n");
  printf("\n");
  printf("-c\n");
  printf("//A->BξսиΨp(B|A)M[A][B]Ȥɸ(default)\n");
  printf("\n");
  printf("-a\n");
  printf("//¾ΥץʻѲ\n");
  printf("//ϤCιɽ(֤˥ޤ򶴤)ǹԤ\n");
  printf("\n");
  printf("-z\n");
  printf("//¾ΥץʻѲ\n");
  printf("//Ψܤɽʤ褦ٹޤ\n");
  exit(0);
}

void parse_args(int argc, char **argv){
  for(int i=1; i<argc; ++i){
    char *arg = argv[i];
    if(*arg=='-'){
      ++arg;
      while(*arg != '\0'){
	switch(*arg){
	case 't':
	  mode = TRANSITION;
	  break;
	case 'c':
	  mode = CONDITIONAL;
	  break;	  
	case 'a':
	  f_comma = true;
	  break;
	case 'z':
	  f_nz = true;
	  break;	  
	default :
	  print_usage();
	  break;
	}
	++arg;
      }
    }else{
      print_usage();
    }
  }
}

void output(double result[][SEGSIZE]){
  cout<<setiosflags(ios::scientific)<<setprecision(5);
  for(int i=0; i<SEGSIZE; ++i){
    for(int j=0; j<SEGSIZE; ++j){
      if((i|j) && f_comma)cout<<",";
      cout<<result[i][j];
      cout<<" ";
    }
    cout<<endl;
  }
}

void out_transition(double freq[][SEGSIZE]){
  double result[SEGSIZE][SEGSIZE];
  memset(result, 0, sizeof(result));
  double sum=0;

  for(int i=0; i<SEGSIZE; ++i)
    for(int j=0; j<SEGSIZE; ++j)
      sum += freq[i][j];
  
  for(int i=0; i<SEGSIZE; ++i)
    for(int j=0; j<SEGSIZE; ++j)
      result[i][j] = freq[i][j] / sum;

  output(result);
}

void out_conditional(double freq[][SEGSIZE]){
  double result[SEGSIZE][SEGSIZE];
  memset(result, 0, sizeof(result));
  double sums[SEGSIZE];
  memset(sums, 0, sizeof(sums));

  for(int i=0; i<SEGSIZE; ++i)
    for(int j=0; j<SEGSIZE; ++j)
      sums[i] += freq[i][j];
  
  for(int i=0; i<SEGSIZE; ++i)
    for(int j=0; j<SEGSIZE; ++j)
      result[i][j] = sums[i]? (freq[i][j] / sums[i]) : 0;

  output(result);
}

void calc(double freq[][SEGSIZE]){
  switch(mode){
  case TRANSITION:
    out_transition(freq);
    break;
  case CONDITIONAL:
    out_conditional(freq);
    break;
  default:
    break;
  }
}
    
int main(int argc, char **argv)
{
  double freq[SEGSIZE][SEGSIZE]; //freq[a][b]a->b
  memset(freq, 0, sizeof(freq));
  
  parse_args(argc, argv);
  
  //input
  for(int i=0; i<SEGSIZE; ++i)
    for(int j=0; j<SEGSIZE; ++j){
      cin>>freq[i][j];
      if(f_nz) //̵κٹ
	freq[i][j] += EPS;
    }
  
  calc(freq);
}
