///    make_transition
//
//anthyηǲϴη̤顢
//ʸ᥯饹A->BʬϤޤ
/*
Copyright (C) 2006  hanaoka

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include <iostream>
#include <sstream>
#include <string>
#include <iomanip>
using namespace std;

#define BEGIN 0
#define END 1
#define UNKNOWN -1
#define SEGSIZE 39
enum MODE{
  FREQUENCY, //
  TRANSITION, //ܳΨ
  CONDITIONAL //
};
MODE mode = FREQUENCY;
bool f_comma = false;

int get_seg_class(string &str){
  int pos = str.find("seg_class");
  str = str.substr(pos);
  int eqpos = str.find("=");
  str[eqpos]=' ';
  istringstream stream(str);
  string seg_sign;
  int n;
  stream>>seg_sign>>n;
  //    cout<<n<<endl;
  return n;
}

void print_usage(){
  printf("make_transition\n");
  printf("anthyηǲϴη̤顢ʸ᥯饹A->BʬϤޤ\n");
  printf(" $ ./make <option> .. < [input-file]\n\n");
  printf("-f\n");
  printf("//A->Bf(A,B)M[A][B]Ȥɸ(default)\n");
  printf("\n");
  printf("-t\n");
  printf("//A->BνиΨp(A,B)M[A][B]Ȥɸ\n");
  printf("-c\n");
  printf("//A->BξսиΨp(B|A)M[A][B]Ȥɸ\n");
  printf("\n");
  printf("-a\n");
  printf("//¾ΥץʻѲ\n");
  printf("//ϤCιɽ(֤˥ޤ򶴤)ǹԤ\n");
  exit(0);
}

void parse_args(int argc, char **argv){
  for(int i=1; i<argc; ++i){
    char *arg = argv[i];
    if(*arg=='-'){
      ++arg;
      while(*arg != '\0'){
	switch(*arg){
	case 'c':
	  mode = CONDITIONAL;
	  break;
	case 't':
	  mode = TRANSITION;
	  break;
	case 'f':
	  mode = FREQUENCY;
	  break;
	case 'a':
	  f_comma = true;
	  break;
	default :
	  print_usage();
	  break;
	}
	++arg;
      }
    }else{
      print_usage();
    }
  }
}

void output(long long result[][SEGSIZE]){
  for(int i=0; i<SEGSIZE; ++i){
    for(int j=0; j<SEGSIZE; ++j){
      if((i|j) && f_comma)cout<<",";
      cout<<result[i][j];
      cout<<" ";
    }
    cout<<endl;
  }
}

void output(double result[][SEGSIZE]){
  cout<<setiosflags(ios::scientific)<<setprecision(5);
  for(int i=0; i<SEGSIZE; ++i){
    for(int j=0; j<SEGSIZE; ++j){
      if((i|j) && f_comma)cout<<",";
      cout<<result[i][j];
      cout<<" ";
    }
    cout<<endl;
  }
}

void out_freq(long long freq[][SEGSIZE]){
  output(freq);
}

void out_transition(long long freq[][SEGSIZE]){
  double result[SEGSIZE][SEGSIZE];
  memset(result, 0, sizeof(result));
  long long sum=0;

  for(int i=0; i<SEGSIZE; ++i)
    for(int j=0; j<SEGSIZE; ++j)
      sum += freq[i][j];
  
  for(int i=0; i<SEGSIZE; ++i)
    for(int j=0; j<SEGSIZE; ++j)
      result[i][j] = (double)freq[i][j] / (double)sum;

  output(result);
}

void out_conditional(long long freq[][SEGSIZE]){
  double result[SEGSIZE][SEGSIZE];
  memset(result, 0, sizeof(result));
  long long sums[SEGSIZE];
  memset(sums, 0, sizeof(sums));

  for(int i=0; i<SEGSIZE; ++i)
    for(int j=0; j<SEGSIZE; ++j)
      sums[i] += freq[i][j];
  
  for(int i=0; i<SEGSIZE; ++i)
    for(int j=0; j<SEGSIZE; ++j)
      result[i][j] = sums[i]? ((double)freq[i][j] / (double)sums[i]) : 0;

  output(result);
}

void calc(long long freq[][SEGSIZE]){
  switch(mode){
  case FREQUENCY:
    out_freq(freq);
    break;
  case TRANSITION:
    out_transition(freq);
    break;
  case CONDITIONAL:
    out_conditional(freq);
    break;
  default:
    break;
  }
}
    
int main(int argc, char **argv)
{

  
  long long freq[SEGSIZE][SEGSIZE]; //freq[a][b]a->b
  memset(freq, 0, sizeof(freq));
  string line;
  int now_seg = BEGIN;
  int next_seg = BEGIN;
  
  
  parse_args(argc, argv);
  
  //input and count 
  while(getline(cin,line)){
    if(line.find("indep_word")==0){
      next_seg = get_seg_class(line);
      if(now_seg != UNKNOWN)
	++freq[now_seg][next_seg];
      now_seg = next_seg;
    }
    else if(line.find("unknown")==0){
      next_seg = UNKNOWN;
      now_seg = next_seg;
    }
    else if(line.find("segments")==0){
      now_seg = BEGIN;
    }
    else if(line.find("eos")==0){
      if(now_seg!=BEGIN){
	next_seg = END;
	++freq[now_seg][next_seg];
      }
    } 
  }

  calc(freq);
}
