/*
 * ѥȤʤʸϤɤǡʸĹĴ
 * ǲϤη̤Ϥ
 */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "../include/convdb.h"

static int verbose;

/* ʸĹʸˤ碌 */
static int
trim_segment(anthy_context_t ac, int nth, char *seg)
{
  int len = strlen(seg);
  int resized = 0;
  while (1) {
    char seg_buf[1024];
    int cur_len;

    anthy_get_segment(ac, nth, NTH_UNCONVERTED_CANDIDATE, seg_buf, 1024);
    cur_len = strlen(seg_buf);
    if (len == cur_len) {
      return 1;
    }
    if (!resized) {
      resized = 1;
      print_segment_info(ac, nth);
    }
    if (len > cur_len) {
      anthy_resize_segment(ac, nth, 1);
    } else {
      anthy_resize_segment(ac, nth, -1);
    }
  }
  return 0;
}

/* '|' ʸ˶ڤ줿ʸγʸfnƤ */
static int
for_each_segment(anthy_context_t ac, const char *res_str,
		 int (*fn)(anthy_context_t ac, int nth, char *seg))
{
  char *str, *cur, *cur_seg;
  int nth;
  if (!res_str) {
    return 0;
  }

  str = strdup(res_str);
  cur = str;
  cur ++;
  cur_seg = cur;
  nth = 0;
  while ((cur = strchr(cur, '|'))) {
    *cur = 0;
    /**/
    if (fn) {
      fn(ac, nth, cur_seg);
    }
    /**/
    nth ++;
    cur ++;
    cur_seg = cur;
  }

  free(str);
  
  return 1;
}

static int
find_candidate(anthy_context_t ac, int nth, char *seg)
{
  char seg_buf[1024];
  int i;
  struct anthy_segment_stat ass;

  anthy_get_segment_stat(ac, nth, &ass);
  for (i = 0; i < ass.nr_candidate; i++) {
    anthy_get_segment(ac, nth, i, seg_buf, 1024);
    if (!strcmp(seg_buf, seg)) {
      anthy_commit_segment(ac, nth, i);
    }
  }
  return 0;
}

int
main(int argc, char **argv)
{
  struct res_db *db;
  struct conv_res *cr;
  anthy_context_t ac;
  int i;


  db = create_db();
  for (i = 1; i < argc; i++) {
    if (!strcmp("-v", argv[i])) {
      verbose = 1;
    } else {
      read_db(db, argv[i]);
    }
  }

  anthy_init();
  anthy_conf_override("CONFFILE", "../anthy-conf");
  anthy_conf_override("DIC_FILE", "../mkanthydic/anthy.dic");
  anthy_set_personality("");
  ac = anthy_create_context();

  for (cr = db->res_list.next; cr; cr = cr->next) {
    /*printf("(%s)\n", cr->src_str);*/
    anthy_set_string(ac, cr->src_str);
    /* ʸĹĴ᤹ */
    if (!for_each_segment(ac, cr->res_str, trim_segment)) {
      continue;
    }
    /* 򤹤 */
    if (cr->cand_str) {
      for_each_segment(ac, cr->cand_str, find_candidate);
    }

    if (verbose) {
      anthy_print_context(ac);
    }
    print_context_info(ac);
  }
  return 0;
}
