/*
 * ʸܹ
 *
 * morphological-analyzerνϤ˲Υޡդ
 * ~ θ
 * ! ʸĹθ
 * ^ ʣʸ2Ĥʹߤ
 *
 * generate transition matrix
 */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include "iis.h"

#define MAX_FEATURE 1100
#define MAX_SEG_STRUCT_FEATURE 1100

/* ʸϢܹ */
struct matrix {
  struct input_set *is;
};

/**/
struct seg_struct_info {
  struct input_set *is;
};

struct array {
  int len;
  int f[16];
};

static int dbg_flag;
static int fast_flag;

static void
add_dummy_line(struct input_set *is)
{
  int i;
  int f[MAX_FEATURE];
  for (i = 0; i < MAX_FEATURE; i++) {
    f[i] = i;
  }
  iis_set_features(is, f, MAX_FEATURE, 0.001);
}

static struct matrix *
init_matrix(void)
{
  struct matrix *m;
  m = malloc(sizeof(struct matrix));
  m->is = iis_create(MAX_FEATURE);
  return m;
}

static void
dump_row(FILE *ofp, struct input_set *is)
{
  int i;
  for (i = 0; i < MAX_FEATURE; i++) {
    double lambda = iis_get_lambda(is, i);
    fprintf(ofp, "%f,", lambda);
  }
}

static void
dump_matrix(FILE *ofp, struct matrix *m)
{
  /* max_feature */
  fprintf(ofp, "#define MAX_FEATURE %d\n\n", MAX_FEATURE);
  /* z */
  fprintf(ofp, "static const float g_z = ");
  fprintf(ofp, "%f;\n\n", iis_get_z(m->is));
  /* lambda */
  fprintf(ofp, "static const float g_lambda[] = {\n");
  dump_row(ofp, m->is);
  if (dbg_flag) {
    iis_dump(m->is);
  }
  fprintf(ofp, "};\n");
}

static double
get_sentence_weight(const char *line)
{
  (void)line;
  return 1.0;
}

static void
parse_features(struct array *features, char *s)
{
  char *tok, *str = s;
  tok = strtok(str, ",");
  features->len = 0;
  do {
    features->f[features->len] = atoi(tok);
    features->len++;
    tok = strtok(NULL, ",");
  } while(tok);
}

static void
add_seg_struct_info(struct seg_struct_info *si,
		    struct array *features,
		    double weight)
{
  iis_set_features(si->is, features->f, features->len, weight);
}

static void
read_morph_file(struct seg_struct_info *si, struct matrix *m, FILE *fp)
{
  char line[1024];
  struct array features;
  double weight = 1.0;

  while (fgets(line, 1024, fp)) {
    char *buf = line;
    int error_class = 0;
    if (line[0] == '~' || line[0] == '!' ||
	line[0] == '^') {
      buf ++;
      error_class = 1;
    }
    if (!strncmp(buf, "indep_word", 10) ||
	!strncmp(buf, "eos", 3)) {
      char *s;
      /**/
      s = strstr(buf, "features=");
      if (s) {
	s += 9;
	parse_features(&features, s);
      }
      if (error_class) {
	if (line[0] == '~') {
	  add_seg_struct_info(si, &features, -weight);
	}
      } else {
	/* ³ */
	iis_set_features(m->is, features.f, features.len, weight);
	/* ʸι¤ */
	add_seg_struct_info(si, &features, weight);
      }
    }
  }
}

static void
read_file(struct seg_struct_info *si, struct matrix *m, char *fn)
{
  int classes[1000];
  int nr;
  FILE *ifp;
  ifp = fopen(fn, "r");
  if (!ifp) {
    return ;
  }
  read_morph_file(si, m, ifp);
  fclose(ifp);
}

static void
dump_seg_struct_info_array(FILE *ofp, struct seg_struct_info *si)
{
  int i;
  fprintf(ofp, "#define MAX_SEG_STRUCT_FEATURE %d\n\n", MAX_SEG_STRUCT_FEATURE);
  fprintf(ofp, "static const float g_seg_z = %f;\n", iis_get_z(si->is));
  fprintf(ofp, "static const float g_seg_lambda[] = {\n");
  for (i = 0; i < MAX_SEG_STRUCT_FEATURE; i++) {
    double lambda = iis_get_lambda(si->is, i);
    fprintf(ofp, "%f,", lambda);
  }
  fprintf(ofp, "};\n");
}

static void
dump_line(FILE *ofp, struct input_line *il)
{
  int i;
  fprintf(ofp, "{{");
  for (i = 0; i < 8 || i < il->nr_features; i++) {
    if (i) {
      fprintf(ofp, ", ");
    }
    if (i < il->nr_features) {
      fprintf(ofp, "%d", il->features[i]);
    } else {
      fprintf(ofp, "0");
    }
  }
  fprintf(ofp,",%d,%d", (int)il->negative_weight, (int)il->weight);
  fprintf(ofp, "}},\n");
}

static int
compare_line(const void *p1, const void *p2)
{
  const struct input_line *const *il1 = p1;
  const struct input_line *const *il2 = p2;
  int i;
  for (i = 0; i < (*il1)->nr_features &&
	 i < (*il2)->nr_features; i++) {
    if ((*il1)->features[i] !=
	(*il2)->features[i]) {
      return (*il1)->features[i] - (*il2)->features[i];
    }
  }
  return (*il1)->nr_features - (*il2)->nr_features;
}

static void
dump_cand_features(FILE *ofp, struct input_set *is)
{
  struct input_line *il, **lines;
  int i, nr = 0;
  int weight = 0;

  /* count lines */
  for (il = iis_get_input_line(is); il; il = il->next_line) {
    nr ++;
    weight += (int)il->weight;
  }
  /* copy lines */
  lines = malloc(sizeof(struct input_line *) * nr);
  for (il = iis_get_input_line(is), i = 0; i < nr; i++, il = il->next_line) {
    lines[i] = il;
  }
  /* sort */
  qsort(lines, nr, sizeof(struct input_line *), compare_line);
  /* output */
  fprintf(ofp, "static const int total_line_weight = %d;\n", weight);
  fprintf(ofp, "static const int total_line_count = %d;\n", nr);
  fprintf(ofp, "static const struct feature_freq { const int f[10]; } feature_array[] = {\n");
  for (i = 0; i < nr; i++) {
    dump_line(ofp, lines[i]);
  }
  fprintf(ofp, "};\n");
}

static void
proc_corpus(int nr_fn, char **fns, FILE *ofp)
{
  int i;
  struct matrix *m;
  struct seg_struct_info si;
  double thresh = 0.1;
  /**/
  m = init_matrix();
  si.is = iis_create(MAX_FEATURE);
  for (i = 0; i < nr_fn; i++) {
    read_file(&si, m, fns[i]);
  }
  /**/
  if (fast_flag) {
    thresh = 100;
  }
  /**/
  add_dummy_line(m->is);
  iis_init_lambda_and_delta(m->is);
  iis_iterate(m->is, thresh);

  /* segment transition information */
  fprintf(ofp, "#ifdef TRANSITION_INFO\n");
  /* segment split information */
  dump_matrix(ofp, m);
  fprintf(ofp, "#endif\n");
  /* candidate ordering information */
  fprintf(ofp, "#ifdef CAND_INFO2\n");
  dump_cand_features(ofp, si.is);
  fprintf(ofp, "#endif\n");
}

int
main(int argc, char **argv)
{
  FILE *ofp;
  int i;
  int nr_input = 0;
  char **input_files;

  ofp = NULL;
  input_files = malloc(sizeof(char *) * argc);
  
  for (i = 1; i < argc; i++) {
    char *arg = argv[i];
    if (!strcmp(arg, "-o")) {
      ofp = fopen(argv[i+1], "w");
      i ++;
    } else if (!strcmp(arg, "-d")) {
      dbg_flag = 1;
    } else if (!strcmp(arg, "-f")) {
      fast_flag = 1;
    } else {
      input_files[nr_input] = arg;
      nr_input ++;
    }
  }
  if (!ofp) {
    ofp = stdout;
  }
  proc_corpus(nr_input, input_files, ofp);

  return 0;
}
