/*
 * ʸι¤metaword򥽡Ȥ
 *
 * ʸФʣι¤θ򥽡Ȥ
 *
 */
#include <stdlib.h>
#include <math.h>

#include <segment.h>
#include <ordering.h>
#include <feature_set.h>
#include <splitter.h>
#include "sorter.h"

#define CAND_INFO2
#include "../src-splitter/transition.h"

static int
compare_line(const void *kp, const void *cp)
{
  const int *f = kp;
  const struct feature_freq *c = cp;
  int i;
  for (i = 0; i < 8; i++) {
    if (f[i] != c->f[i]) {
      return f[i] - c->f[i];
    }
  }
  return 0;
}

static double
calc_probability(struct feature_list *fl)
{
  int i, nr;
  int f[10];
  struct feature_freq *res;
  /* ˥ԡ */
  nr = anthy_feature_list_nr(fl);
  for (i = 0; i < 10; i++) {
    if (i < nr) {
      f[i] = anthy_feature_list_nth(fl, i);
    } else {
      f[i] = 0;
    }
  }
  res = bsearch(f, feature_array, total_line_count,
		sizeof(struct feature_freq),
		compare_line);
  if (res) {
    /* Ŭ */
    double pos = (double)res->f[9];
    double neg = (double)res->f[8];
    double total = (double)total_line_count;
    double prob;
    if (pos > 0) { 
      prob = (pos - neg * 50) / total;
    } else {
      prob = (- neg * 100) / total;
    }
    return prob;
  }
  return 0;
}

static void
mw_eval(struct seg_ent *prev_seg, struct seg_ent *seg,
	struct meta_word *mw)
{
  int pc;
  struct feature_list fl;
  double prob;
  anthy_feature_list_init(&fl);
  /**/
  anthy_feature_list_set_cur_class(&fl, mw->seg_class);
  anthy_feature_list_set_dep_word(&fl, mw->dep_word_hash);
  anthy_feature_list_set_dep_class(&fl, mw->dep_class);
  anthy_feature_list_set_mw_features(&fl, mw->mw_features);
  /* ʸ */
  if (prev_seg) {
    pc = prev_seg->best_seg_class;
  } else {
    pc = SEG_HEAD;
  }
  anthy_feature_list_set_prev_class(&fl, pc);
  anthy_feature_list_set_class_trans(&fl, pc, mw->seg_class);
  anthy_feature_list_sort(&fl);
  /* ׻ */
  prob = 0.5 + calc_probability(&fl);
  if (prob < 0) {
    prob = (double)1 / (double)total_line_count;
  }
  /*anthy_feature_list_print(&fl);
    printf(" prob=%f\n", prob);*/
  anthy_feature_list_free(&fl);
  mw->struct_score = RATIO_BASE * RATIO_BASE;
  mw->struct_score *= prob;

  /* ֲǽפȤФƤΤ򤱤롢Τ¤򤱤Ϥ */
  if (mw->type == MW_NOUN_NOUN_SUFFIX) {
    mw->struct_score /= 10;
  }
  if (mw->mw_features & MW_FEATURE_SUFFIX) {
    mw->struct_score /= 2;
  }
  if (mw->mw_features & MW_FEATURE_WEAK) {
    mw->struct_score /= 5;
  }
}

static void
seg_eval(struct seg_ent *prev_seg,
	 struct seg_ent *seg)
{
  int i;
  for (i = 0; i < seg->nr_metaword; i++) {
    mw_eval(prev_seg, seg, seg->mw_array[i]);
  }
}

static void
sl_eval(struct segment_list *seg_list)
{
  int i;
  struct seg_ent *prev_seg = NULL;
  for (i = 0; i < seg_list->nr_segments; i++) {
    struct seg_ent *seg;
    seg = anthy_get_nth_segment(seg_list, i);
    seg_eval(prev_seg, seg);
    prev_seg = seg;
  }
}

static int
metaword_compare_func(const void *p1, const void *p2)
{
  const struct meta_word * const *s1 = p1;
  const struct meta_word * const *s2 = p2;
  return (*s2)->struct_score - (*s1)->struct_score;
}

void
anthy_sort_metaword(struct segment_list *seg_list)
{
  int i;
  /**/
  sl_eval(seg_list);
  /**/
  for (i = 0; i < seg_list->nr_segments; i++) {
    struct seg_ent *seg = anthy_get_nth_segment(seg_list, i);
    qsort(seg->mw_array, seg->nr_metaword, sizeof(struct meta_word *),
	  metaword_compare_func);
  }
}
