/* features
 *
 * ֹỌ̇̄äƴ
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include "segclass.h"
#include "feature_set.h"
/* for MW_FEATURE* constants */
#include "splitter.h"

/* ֹ 
 *
 * 0-19 饹
 * 30-529 °
 * 550-580 ʸ᥯饹(ƤΤ)
 */

#define DEP_TYPE_FEATURE_BASE 20
#define DEP_LT1 27
#define CLASS_TRANS_BASE 30
#define PREV_CLASS_BASE 550
#define FEATURE_SV 542
#define FEATURE_WEAK 543
#define FEATURE_SUFFIX 544
#define FEATURE_PREV_WEAK 545
#define FEATURE_NUM 546
#define FEATURE_CORE1 547
#define DEP_FEATURE_BASE 580

void
anthy_feature_list_init(struct feature_list *fl)
{
  fl->nr = 0;
  fl->size = NR_EM_FEATURES;
}

void
anthy_feature_list_free(struct feature_list *fl)
{
  (void)fl;
}

void
anthy_feature_list_add(struct feature_list *fl, int f)
{
  if (fl->nr < NR_EM_FEATURES) {
    fl->u.index[fl->nr] = f;
    fl->nr++;
  }
}

int
anthy_feature_list_nr(struct feature_list *fl)
{
  return fl->nr;
}

int
anthy_feature_list_nth(struct feature_list *fl, int nth)
{
  return fl->u.index[nth];
}

static int
cmp_short(const void *p1, const void *p2)
{
  return *((short *)p1) - *((short *)p2);
}

void
anthy_feature_list_sort(struct feature_list *fl)
{
  qsort(fl->u.index, fl->nr, sizeof(fl->u.index[0]),
	cmp_short);
}


void
anthy_feature_list_set_cur_class(struct feature_list *fl, int cl)
{
  anthy_feature_list_add(fl, cl);
}

void
anthy_feature_list_set_prev_class(struct feature_list *fl, int pc)
{
  anthy_feature_list_add(fl, pc + PREV_CLASS_BASE);
}

void
anthy_feature_list_set_class_trans(struct feature_list *fl, int pc, int cc)
{
  anthy_feature_list_add(fl, CLASS_TRANS_BASE + pc * SEG_SIZE + cc);
}

void
anthy_feature_list_set_dep_word(struct feature_list *fl, int h)
{
  anthy_feature_list_add(fl, h + DEP_FEATURE_BASE);
}

void
anthy_feature_list_set_dep_class(struct feature_list *fl, int c)
{
  anthy_feature_list_add(fl, c + DEP_TYPE_FEATURE_BASE);
}

void
anthy_feature_list_set_prev_weak(struct feature_list *fl)
{
  anthy_feature_list_add(fl, FEATURE_PREV_WEAK);
}

void
anthy_feature_list_set_mw_features(struct feature_list *fl, int mask)
{
  if (mask & MW_FEATURE_WEAK) {
    anthy_feature_list_add(fl, FEATURE_WEAK);
  }
  if (mask & MW_FEATURE_SUFFIX) {
    anthy_feature_list_add(fl, FEATURE_SUFFIX);
  }
  if (mask & MW_FEATURE_SV) {
    anthy_feature_list_add(fl, FEATURE_SV);
  }
  if (mask & MW_FEATURE_DEP_LT1) {
    anthy_feature_list_add(fl, DEP_LT1);
  }
  if (mask & MW_FEATURE_NUM) {
    anthy_feature_list_add(fl, FEATURE_NUM);
  }
  if (mask & MW_FEATURE_CORE1) {
    anthy_feature_list_add(fl, FEATURE_CORE1);
  }
}

double
anthy_feature_list_inner_product(struct feature_list *fl, const float *v, int len)
{
  int i, nr = anthy_feature_list_nr(fl);
  double res = 0;
  /* Ѥ׻ */
  for (i = 0; i < nr; i++) {
    int f = anthy_feature_list_nth(fl, i);
    if (f >= len) {
      continue;
    }
    res += v[f];
  }
  return res;
}

void
anthy_feature_list_print(struct feature_list *fl)
{
  int i;
  printf("features=");
  for (i = 0; i < fl->nr; i++) {
    if (i) {
      printf(",");
    }
    printf("%d", fl->u.index[i]);
  }
  printf("\n");
}

void
anthy_init_features(void)
{
}
