#include <gtk/gtk.h>
#include <gtk/gtkimmodule.h>

struct code_table{
  GtkWidget *button[256];
  GtkWidget *label[256];
  GtkWidget *table;
  GtkWidget *window;
  GtkWidget *current_page;
  GtkWidget *prev_button, *next_button;
  int base;
  int page_index;
};

static int valid_page[] = {
  0,1,2,3,4,5,6,7,8,9,
  10,11,12,13,14,15,16,17,18,19,
  20,21,22,23,24,25,26,27,28,29,
  30,31,32,33,34,35,36,37,38,39,
  40,41,42,43,44,45,46,47,48,49,
  50,51,52,53,54,55,56,57,58,59,
  60,61,62,63,64,65,66,67,68,69,
  70,71,72,73,74,75,76,77,78,79,
  80,81,82,83,84,85,86,87,88,89,
  90,91,92,93,94,95,96,97,98,99,
  100,101,102,103,104,105,106,107,108,109,
  110,111,112,113,114,115,116,117,118,119,
  120,121,122,123,124,125,126,127,128,129,
  130,131,132,133,134,135,136,137,138,139,
  140,141,142,143,144,145,146,147,148,149,
  150,151,152,153,154,155,156,157,158,159,
  160,161,162,163,164,165,166,167,168,169,
  170,171,172,173,174,175,176,177,178,179,
  180,181,182,183,184,185,186,187,188,189,
  190,191,192,193,194,195,196,197,198,199,
  200,201,202,203,204,205,206,207,208,209,
  210,211,212,213,214,215,/*216,217,218,219,surrogate low*/
  /*220,221,222,223, surrogate high*/224,225,226,227,228,229,
  230,231,232,233,234,235,236,237,238,239,
  240,241,242,243,244,245,246,247,248,249,
  250,251,252,253,254,
  /*255 not UTF8? */
};

typedef struct _IMCodeTabContext
{
  struct _GtkIMContext parent;
  struct code_table ctab;
  struct _GtkIMContext *slave;
} IMCodeTabContext;

static GType type_im_CodeTab;
static GObjectClass *parent_class;

static const GtkIMContextInfo im_CodeTab_info = {
  "CodeTab",
  "CodeTab",
  "gtk+",
  "",
  ""
};

static const GtkIMContextInfo *info_list[] = {
  &im_CodeTab_info
};

#define IM_CODETAB_CONTEXT(obj) (GTK_CHECK_CAST((obj),type_im_CodeTab,IMCodeTabContext))

int ucs2utf(char* utf, long ucs)
{
  char* utf_base = utf;
  
  /* optimize target: 0x0000ffff - 0x00000800 */


  if ((ucs & ~0x000007ff) == 0) {
    if ((ucs & ~0x0000007f) == 0)
      *utf++ = ucs;
    else {
      *utf++ = 0xc0 | (ucs >>  (6 * 1));
      *utf++ = 0x80 | ((ucs >> (6 * 0)) & 0x3f);
    }
  } else if ((ucs & ~0x0000ffff) == 0) {
    if ((ucs & 0x0000d800) != 0x0000d800) {
      *utf++ = 0xe0 | (ucs >>  (6 * 2));
      *utf++ = 0x80 | ((ucs >> (6 * 1)) & 0x3f);
      *utf++ = 0x80 | ((ucs >> (6 * 0)) & 0x3f);
    }
  } else if ((ucs & ~0x001fffff) == 0) {
    *utf++ = 0xf0 | (ucs >>  (6 * 3));
    *utf++ = 0x80 | ((ucs >> (6 * 2)) & 0x3f);
    *utf++ = 0x80 | ((ucs >> (6 * 1)) & 0x3f);
    *utf++ = 0x80 | ((ucs >> (6 * 0)) & 0x3f);
  } else if ((ucs & ~0x03ffffff) == 0) {
    *utf++ = 0xf8 | (ucs >>  (6 * 4));
    *utf++ = 0x80 | ((ucs >> (6 * 3)) & 0x3f);
    *utf++ = 0x80 | ((ucs >> (6 * 2)) & 0x3f);
    *utf++ = 0x80 | ((ucs >> (6 * 1)) & 0x3f);
    *utf++ = 0x80 | ((ucs >> (6 * 0)) & 0x3f);
  } else {
    *utf++ = 0xfc | (ucs >>  (6 * 5));
    *utf++ = 0x80 | ((ucs >> (6 * 4)) & 0x3f);
    *utf++ = 0x80 | ((ucs >> (6 * 3)) & 0x3f);
    *utf++ = 0x80 | ((ucs >> (6 * 2)) & 0x3f);
    *utf++ = 0x80 | ((ucs >> (6 * 1)) & 0x3f);
    *utf++ = 0x80 | ((ucs >> (6 * 0)) & 0x3f);
  }

  *utf = '\0';
  return utf - utf_base;
}

static void
update(struct code_table *ctab)
{
  int x, y;
  char buf[10];
  for (y = 4; y < 16; y++) {
    for (x = 0; x < 16; x++) {
      int idx = x + y * 16;
      char buf[8];
      ucs2utf(buf, idx + ctab->base);
      gtk_label_set(GTK_LABEL(ctab->label[idx]), buf);
    }
  }
  sprintf(buf, "%x", ctab->base);
  gtk_label_set(GTK_LABEL(ctab->current_page), buf);
}

static void
button_click(GtkWidget *w, void *a)
{
  IMCodeTabContext *ic = a;
  struct code_table *c = &ic->ctab;
  int x,y;
  for (y = 0; y < 16; y++) {
    for (x = 0; x < 16; x++) {
      int idx = x+ y* 16;
      if (w == c->button[idx]) {
	char buf[8];
	ucs2utf(buf,ic->ctab.base + idx);
	g_signal_emit_by_name(ic, "commit", buf);
	return ;
      }
    }
  }
  if (w == c->next_button) {
    c->page_index ++;
    if (valid_page[c->page_index] == sizeof(valid_page)/sizeof(int)) {
      c->page_index = 0;
    }
  }else {
    c->page_index --;
    if (c->page_index == -1) {
      c->page_index = (sizeof(valid_page)/sizeof(int)) -1;
    }
  }
  c->base = valid_page[c->page_index]* 256;
  update(c);
}

static void
init_codetab(IMCodeTabContext * ct)
{
  int x,y;
  struct code_table *c = &ct->ctab;
  c->window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  c->table = gtk_table_new(18,18, TRUE);
  gtk_container_set_border_width (GTK_CONTAINER (c->window), 10);
  gtk_container_add (GTK_CONTAINER (c->window), c->table);

  c->next_button = gtk_button_new_with_label(">>");
  gtk_table_attach_defaults(GTK_TABLE(c->table), c->next_button,
			    10,11,16,17);
  gtk_signal_connect(GTK_OBJECT(c->next_button), "clicked",
		     GTK_SIGNAL_FUNC(button_click), (void *)ct);
  gtk_widget_show(c->next_button);

  c->prev_button = gtk_button_new_with_label("<<");
  gtk_table_attach_defaults(GTK_TABLE(c->table), c->prev_button,
			    5,6,16,17);
  gtk_signal_connect(GTK_OBJECT(c->prev_button), "clicked",
		     GTK_SIGNAL_FUNC(button_click), (void *)ct);
  gtk_widget_show(c->prev_button);

  c->current_page = gtk_label_new("");
  gtk_table_attach_defaults(GTK_TABLE(c->table), c->current_page,
			    7,9,16,17);
  gtk_widget_show(c->current_page);

  for (x = 0; x < 16; x++) {
    for (y = 0; y < 16; y++) {
      int idx = x + y* 16;
      c->button[idx] = gtk_button_new();
      c->label[idx] = gtk_label_new(" ");
      gtk_signal_connect(GTK_OBJECT(c->button[idx]), "clicked",
		     GTK_SIGNAL_FUNC(button_click), (void *)ct);
      gtk_container_add(GTK_CONTAINER(c->button[idx]),
			c->label[idx]);
      gtk_table_attach_defaults(GTK_TABLE(c->table),
				c->button[idx],x,x+1,y,y+1);
      gtk_widget_show(c->button[idx]);
      gtk_widget_show(c->label[idx]);
    }
  }
  gtk_widget_show (c->table);
  gtk_widget_show (c->window);
  ct->ctab.base = 0;
  ct->ctab.page_index = 0;
}

static void
im_codetab_commit_cb(GtkIMContext *ic,
		     const gchar *str,
		     IMCodeTabContext *ac)
{
  g_signal_emit_by_name(ac, "commit", str);
}

static void
im_CodeTab_context_finalize(GObject *obj)
{
  IMCodeTabContext *ac = IM_CODETAB_CONTEXT(obj);
  gtk_widget_destroy(ac->ctab.window);
  g_object_unref(ac->slave);
  parent_class->finalize (obj);  
  g_signal_handlers_disconnect_by_func(ac->slave,
				       im_codetab_commit_cb,
				       ac);
  g_object_unref(ac->slave);
}

static gboolean
im_CodeTab_filter_keypress(GtkIMContext *context,
			   GdkEventKey *key)
{
  return FALSE;
}

static gboolean
im_codetab_filter_keypress(GtkIMContext *context,
			   GdkEventKey *key)
{
  IMCodeTabContext *ac = IM_CODETAB_CONTEXT(context);
  return gtk_im_context_filter_keypress(ac->slave, key);
}

static void im_CodeTab_class_init (GtkIMContextClass *class)
{
  GObjectClass *object_class = G_OBJECT_CLASS(class);
  class->filter_keypress = im_codetab_filter_keypress;
  object_class->finalize = im_CodeTab_context_finalize;
  parent_class = g_type_class_peek_parent (class);
}

static void
im_CodeTab_init (GtkIMContext *context)
{
  IMCodeTabContext *ac = IM_CODETAB_CONTEXT(context);
  init_codetab(ac);
  ac->ctab.page_index = 0;
  
  update(&ac->ctab);
  ac->slave = g_object_new(GTK_TYPE_IM_CONTEXT_SIMPLE, NULL);
  g_signal_connect(ac->slave, "commit",
		   G_CALLBACK(im_codetab_commit_cb), ac);
}

static void im_CodeTab_release(GObject *obj)
{
  IMCodeTabContext *ac = IM_CODETAB_CONTEXT(obj);
}

GtkIMContext *
im_module_create (const gchar *context_id)
{
  if (strcmp (context_id, "CodeTab") == 0) {
    GtkObject *obj = g_object_new(type_im_CodeTab, NULL);
    return GTK_IM_CONTEXT (obj);
  }
  return NULL;
}

void im_module_list(const GtkIMContextInfo ***contexts,
		    int *n_contexts)
{
  *contexts = info_list;
  *n_contexts = G_N_ELEMENTS(info_list);
}

void im_module_init(GTypeModule *module)
{
  static const GTypeInfo object_info =
  {
    sizeof(GtkIMContextClass),
    (GBaseInitFunc) NULL,
    (GBaseFinalizeFunc) NULL,
    (GClassInitFunc) im_CodeTab_class_init,
    NULL,
    NULL,
    sizeof(IMCodeTabContext),
    0,
    (GtkObjectInitFunc) im_CodeTab_init,
  };
  type_im_CodeTab = g_type_module_register_type(module,
					      GTK_TYPE_IM_CONTEXT,
					      "GtkIMContextCodeTab",
					      &object_info, 0);
}

void im_module_exit()
{
}
