#include <signal.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>

#include <glib.h>

#include "context.h"

static FILE *primer = NULL, *primew = NULL;
static int prime_running;
static int prime_pid = 0;
static int prime_active;

static char buf[8192];

extern LISP sym_t;

static char *prime_command = "prime";


/**/
pid_t open_pipe_rw(FILE ** fr, FILE ** fw);
void  myExec(char *command);
void  close_tty(void);

void
init_prime()
{
    prime_active = prime_running;
    if (primer != NULL)
	fclose(primer);
    if (primew != NULL)
	fclose(primew);
    primer = primew = NULL;
    if (prime_pid)
	kill(prime_pid, SIGKILL);
    prime_pid = 0;
}

static int
open_prime(char *prime_command)
{
    prime_pid = open_pipe_rw(&primer, &primew);
    if (prime_pid < 0)
	goto err0;
    if (prime_pid == 0) {
	/* child */
	myExec(prime_command);
    }
    return 1;
  err0:
    prime_pid = 0;
    prime_active = prime_running = 0;
    return 0;
}

static char *
prime_send_command_internal(char *str)
{
  GString *tmp = g_string_new("");
 
  if (primer == NULL || primew == NULL)
    if (open_prime(prime_command) == 0)
      return NULL;

  fprintf(primew,str );

 again:
  if (fflush(primew) != 0) {
    switch (errno) {
    case EINTR:
      goto again;
    default:
      goto err;
    }
  }

  while (fgets (buf, sizeof(buf), primer ) != NULL ) {
    if(strcmp( buf, "\n" ) == 0)
      break;

    g_string_append( tmp, buf );
  }
 
  if (tmp->len == 0)
    goto err;

  return tmp->str;

 err:
  /* XXX: backend prime is not working? */
  init_prime();
  prime_active = prime_running = 0;
  return NULL;
  
}


static LISP
prime_send_command(LISP str_)
{
  char *str = get_c_string( str_ );
  char *result;

  result = prime_send_command_internal( str );

  if(result == NULL)
    {
      return NIL;
    }

  return strcons( strlen(result), result );
}

static LISP
init_prime_lib()
{
  int i;
  init_prime();
  open_prime("prime");
  return sym_t;
}


static LISP
prime_add_candidate_list(LISP list, char *cand )
{
  LISP cand_ = strcons( strlen(cand), cand );

  return cons( cand_, list );
}


static LISP
test_print(LISP _str)
{
  char *str = get_c_string(_str);
  printf("%s\n",str);
  free(str);
  return sym_t;
}

static LISP
prime_learn_word(LISP key_, LISP value_, LISP part_, LISP context_, LISP suffix_, LISP rest_)
{
  char *key = get_c_string(key_);
  char *value = get_c_string(value_);
  char *part = get_c_string(part_);
  char *context = get_c_string(context_);
  char *suffix = get_c_string(suffix_);
  char *rest = get_c_string(rest_);

  return NIL;

}


static LISP
prime_get_candidate_list(LISP _preedit, LISP _context)
{
  char *preedit = get_c_string(_preedit);
  char *context = get_c_string(_context);
  char *result;
  char **lines;
  LISP list = NIL;
  
  GString *tmp = g_string_new("");

  if( strcmp(context, "") != 0 ) {
    g_string_printf(tmp, "set_context\t%s\n", context);
    result = prime_send_command_internal(tmp->str);
    
    if( result != NULL ) {
      g_free(result);
    }
  }
  
  g_string_printf(tmp, "l\t%s\n", preedit);
  result = prime_send_command_internal(tmp->str);
  
  if( result != NULL ) {
    lines = g_strsplit(result,"\n",0);
    
    {
      int i;
      char **tmp;
      for(i = 0;i<lines[i]; i++)
	{
	  if(strcmp(lines[i], "") ==0 ) {
	    break;
	  }
	  
	  tmp = g_strsplit(lines[i],"\t",3);

	  if( tmp[1] != NULL ) {
	    list = prime_add_candidate_list( list, tmp[1] );
	    /*	    printf("%s ",tmp[1]);*/
	  }


	  g_free(lines[i]);
	  /*βˤĤƤȤǹͤ뤳*/
	}
      printf("\n");
    }
    
    g_free(result);
  }
  
  return list;
  
}

pid_t
open_pipe_rw(FILE ** fr, FILE ** fw)
{
    int fdr[2];
    int fdw[2];
    pid_t pid;

    if (fr && pipe(fdr) < 0)
	goto err0;
    if (fw && pipe(fdw) < 0)
	goto err1;

    pid = fork();
    if (pid < 0)
	goto err2;
    if (pid == 0) {
	/* child */
	if (fr) {
	    close(fdr[0]);
	    dup2(fdr[1], 1);
	}
	if (fw) {
	    close(fdw[1]);
	    dup2(fdw[0], 0);
	}
    }
    else {
	if (fr) {
	    close(fdr[1]);
	    if (*fr == stdin)
		dup2(fdr[0], 0);
	    else
		*fr = fdopen(fdr[0], "r");
	}
	if (fw) {
	    close(fdw[0]);
	    if (*fw == stdout)
		dup2(fdw[1], 1);
	    else
		*fw = fdopen(fdw[1], "w");
	}
    }
    return pid;
  err2:
    if (fw) {
	close(fdw[0]);
	close(fdw[1]);
    }
  err1:
    if (fr) {
	close(fdr[0]);
	close(fdr[1]);
    }
  err0:
    return (pid_t) - 1;
}

void
myExec(char *command)
{
    execl("/bin/sh", "sh", "-c", command, NULL);
    exit(127);
}

void
uim_init_prime()
{
  init_subr_0("prime-lib-init", init_prime_lib);
  init_subr_1("prime-lib-send-command", prime_send_command);
  init_subr_2("prime-lib-get-candidates", prime_get_candidate_list);
  /*  init_subr_6("prime-lib-learn-word", prime_learn_word);*/
  init_subr_1("print2",test_print );
}
