;; PRIMEϤϲξ֤ǹ(׸ľ)
;;  Ե no-preedit
;;  Ͼ with-preedit
;;  Ѵ converting
;;  ѿ latin
;;  ѱѿ wide-latin
;;
(require "japanese.scm")
(require "generic-key.scm")


;; configs
(define prime-use-candidate-window? #t)
(define prime-candidate-op-count 1)
;; key
(define prime-latin-key
  (lambda (key key-state)
    (or
     (generic-off-key key key-state)
     (= (to-lower-char key) 108))))
(define prime-wide-latin-key
  (lambda (key key-state)
    (and (= (to-lower-char key) 108)
	 (shift-key-mask key-state))))
(define prime-begin-conv-key
  (lambda (key key-state)
    (= key 32)))
(define prime-on-key
  (lambda (key key-state)
    (or
     (and (= (to-lower-char key) 106)
	  (control-key-mask key-state))
     (generic-on-key key key-state))))
(define prime-commit-key
  (lambda (key key-state)
    (or 
     (and (= (to-lower-char key) 106)
	  (control-key-mask key-state))
     (= key 'return))))
(define prime-next-candidate
  (lambda (key key-state)
    (generic-next-candidate-key key key-state)))
(define prime-prev-candidate
  (lambda (key key-state)
    (or
     (generic-prev-candidate-key key key-state)
     (= (to-lower-char key) 120))))

(define prime-kana-toggle
  (lambda (key key-state)
    (= (to-lower-char key) 113)))
(define prime-cancel-key
  (lambda (key key-state)
    (generic-cancel-key key key-state)))

(define prime-backspace-key
  (lambda (key key-state)
    (generic-backspace-key key key-state)))

;; access
(define prime-context-candidates
  (lambda (c)
   (car (nthcdr 10 c))))

(define prime-context-set-candidates!
  (lambda (c cnt)
    (set-car! (nthcdr 10 c) cnt)))

(define prime-context-candidate-window
  (lambda (c)
   (car (nthcdr 9 c))))

(define prime-context-set-candidate-window!
  (lambda (c cnt)
    (set-car! (nthcdr 9 c) cnt)))

(define prime-context-candidate-op-count
  (lambda (c)
   (car (nthcdr 8 c))))
    
(define prime-context-set-candidate-op-count!
  (lambda (c cnt)
    (set-car! (nthcdr 8 c) cnt)))

(define prime-context-rk-context
  (lambda (c)
   (car (nthcdr 7 c))))

(define prime-context-set-rk-context!
  (lambda (c rkc)
    (set-car! (nthcdr 7 c) rkc)))

(define prime-context-nth
  (lambda (c)
    (car (nthcdr 6 c))))

(define prime-context-set-nth!
  (lambda (c nth)
    (set-car! (nthcdr 6 c) nth)))

(define prime-context-tail
  (lambda (c)
    (car (nthcdr 4 c))))

(define prime-context-set-tail!
  (lambda (c tail)
    (set-car! (nthcdr 4 c) tail)))

(define prime-context-set-head!
  (lambda (c head)
    (set-car! (nthcdr 2 c) head)))

(define prime-context-head
  (lambda (c)
    (car (nthcdr 2 c))))

(define prime-context-kana-mode
  (lambda (sc)
    (car (nthcdr 1 sc))))

(define prime-context-set-kana-mode!
  (lambda (sc mode)
    (set-car! (nthcdr 1 sc) mode)))

(define prime-context-state
  (lambda (c)
    (car (nthcdr 0 c))))

(define prime-context-set-state!
  (lambda (c s)
    (set-car! (nthcdr 0 c) s)))
;; state kana head okuri tail candidates nth rk

(define prime-flush
  (lambda (sc)
    (rk-flush (prime-context-rk-context sc))
    (prime-context-set-state! sc 'prime-state-no-preedit)
    (prime-context-set-head! sc '())
    (prime-context-set-tail! sc '())
    (prime-context-set-candidate-op-count! sc 0)
    (prime-context-set-candidate-window! sc #f)))

(define prime-context-new
  (lambda ()
    (let ((c 
	   (copy-list 
	    '(prime-state-latin #t "" "" "" () () () () () () ()))))
      (prime-context-set-head! c ())
      (prime-context-set-rk-context! c
				   (rk-context-new jp-rk-rule #t #f))
      (prime-flush c)
      (prime-context-set-state! c 'prime-state-latin)
      c)))

(define prime-make-string
  (lambda (sl kana)
    (if sl
	(string-append (prime-make-string (cdr sl) kana)
		       (if kana
			   (caar sl)
			   (cdar sl)))
	"")))

(define prime-context-kana-toggle
  (lambda (sc)
    (let ((s (prime-context-kana-mode sc)))
      (set! s (not s))
      (prime-context-set-kana-mode! sc s))))

(define prime-get-string-by-mode
  (lambda (sc res)
    (if res
	(if (prime-context-kana-mode sc)
	    (car res)
	    (cdr res))
	nil)))

(define prime-get-nth-candidate
  (lambda (sc n)
    (if (> n (prime-get-nr-candidates sc))
	nil)
    (car (nthcdr n (prime-context-candidates sc)))
    ))

(define prime-get-nr-candidates
  (lambda (sc)
    (length (prime-context-candidates sc))))

(define prime-get-current-candidate
  (lambda (sc)
    (prime-get-nth-candidate
     sc
     (prime-context-nth sc))))
			   

(define prime-begin-conversion
  (lambda (sc id)
    (let ((res))
      (prime-context-set-candidates!
       sc
       (reverse 
	(prime-lib-get-candidates (prime-make-string (prime-context-head sc) #t) "" )))
      (set! res
	    (prime-get-nth-candidate sc 0))
      (print res)
;      (print (car (nthcdr 0 (prime-context-candidates sc))))
      (print (prime-context-candidates sc))
      (if res
	  (begin
	    (prime-context-set-nth! sc 0)
	    (prime-context-set-state!
	     sc 'prime-state-converting))
	  (prime-flush sc))
      ())))

(define prime-update-preedit
  (lambda (id sc)
    (let ((rkc (prime-context-rk-context sc))
	  (stat (prime-context-state sc)))
      (im-clear-preedit id)
       (if (= stat 'prime-state-with-preedit)
	  (let ((h (prime-make-string 
		    (prime-context-head sc)
		    (prime-context-kana-mode sc))))
	    (if (string? h)
		(im-pushback-preedit
		 id preedit-underline
		 h))))
      (if (= stat 'prime-state-converting)
	  (begin
	    (im-pushback-preedit
	     id preedit-reverse
	     (prime-get-current-candidate sc))))
      (im-pushback-preedit
       id preedit-reverse
       (prime-make-string (prime-context-tail sc)
			(prime-context-kana-mode sc)))
      (im-pushback-preedit id preedit-underline
                           (rk-pending rkc))
      (im-update-preedit id))))
    
(define prime-update-mode
  (lambda (id sc)
    (let ((stat (prime-context-state sc))
	  (mode))
      (set! mode
	    (if (prime-context-kana-mode sc)
		1
		2))
      (if (= stat 'prime-state-latin)
	  (set! mode 0))
      (if (= stat 'prime-state-wide-latin)
	  (set! mode 3))
      (im-update-mode id mode))))

(define prime-proc-state-no-preedit
  (lambda (c key key-state)
    (let* ((sc (context-data c))
	   (id (context-id c))
	   (key-str (charcode->string (to-lower-char key)))
	   (rkc (prime-context-rk-context sc))
	   (res))
      (set! res nil)
      (and
       (if (prime-wide-latin-key key key-state)
	   (begin
	     (prime-context-set-state! sc 'prime-state-wide-latin)
	     (prime-update-mode id sc)
	     #f)
	   #t)
       (if (prime-latin-key key key-state)
	   (begin
	     (prime-context-set-state! sc 'prime-state-latin)
	     (prime-update-mode id sc)
	     #f)
	   #t)
       (if (prime-cancel-key key key-state)
	   (begin
	     (prime-flush sc)
	     #f)
	   #t)
       (if (prime-kana-toggle key key-state)
	   (begin 
	     (prime-context-kana-toggle sc)
	     (prime-update-mode id sc)
	     #f)
	   #t)
       (if (prime-backspace-key key key-state)
	   (if (not (rk-backspace rkc))
	       (begin
		 (im-commit-raw (context-id c))
		 #f)
	       #f)
	   #t)
       (if (or
	    (control-key-mask key-state)
	    (= key 32))
	   (begin
	     (im-commit-raw id)
	     #f)
	   #t)
       (if (and
	    (not (prime-context-head sc))
	    (not (string-find (rk-expect rkc) key-str))
	    (not (rk-pending rkc)))
	   (begin
	     (im-commit-raw id)
	     (prime-flush sc)
	     (prime-update-preedit id sc)
	     #f)
	   #t)
       (if (symbol? key)
	   (begin
	     (prime-flush sc)
	     (im-commit-raw (context-id c))
	     #f)
	   #t)
       (begin
	 (set! res
	       (rk-push-key!
		rkc
		key-str))
	 #t))
      ;; update state
      (if res (begin
		(prime-context-set-head! sc
					     (cons
					      res
					      (prime-context-head sc)))
		(prime-context-set-candidates!
		 sc
		 (reverse 
		  (prime-lib-get-candidates (prime-make-string (prime-context-head sc) #t) "" )))
		(prime-context-set-state! sc 'prime-state-with-preedit)))
	  nil)))

(define prime-proc-state-with-preedit
  (lambda (c key key-state)
    (let* ((sc (context-data c))
	   (id (context-id c))
	   (rkc (prime-context-rk-context sc))
	   (stat (prime-context-state sc))
	   (res))
      (and
       (if (prime-begin-conv-key key key-state)
	   (begin
	     (prime-begin-conversion sc id)
	     #f)
	   #t)
       (if (prime-cancel-key key key-state)
	   (begin
	     (prime-flush sc)
	     #f)
	   #t)
       (if (prime-backspace-key key key-state)
	   (begin
	     (if (not (rk-backspace rkc))
		 (if (> (length (prime-context-head sc)) 0)
		     (prime-context-set-head!
		      sc (cdr (prime-context-head sc)))
		     (begin 
		       (prime-context-set-state! sc 'prime-state-no-preedit)
		       (prime-flush sc))))
	     #f)
	   #t)
       (if (prime-commit-key key key-state)
	   (begin
	     (im-commit id  (prime-make-string (prime-context-head sc) (prime-context-kana-mode sc)))
	     (prime-flush sc)
	     (prime-context-set-state! sc 'prime-state-no-preedit)
	     (prime-update-mode id sc)
	     #f)
	   #t)
       (begin
	 (set! stat (prime-context-state sc))
	 (set! res
	       (rk-push-key!
		rkc
		(charcode->string key)))
	 (if (and res (= stat 'prime-state-with-preedit))
	     (begin
	       (prime-context-set-head! sc
				      (cons
				       res
				       (prime-context-head sc)))))
	 ))
      nil)))

(define prime-proc-state-converting
  (lambda (c key key-state)
    (let ((sc (context-data c))
	  (id (context-id c))
	  (res ()))
      (and
       (if (prime-next-candidate key key-state)
	   (begin
	     (prime-context-set-nth! sc
	      (+ 1 (prime-context-nth sc)))
	     (prime-context-set-candidate-op-count! sc
	      (+ 1 (prime-context-candidate-op-count sc)))
	     (if (not (prime-get-current-candidate sc))
		 (prime-context-set-nth! sc 0))
	     ;; Windowɽ򳫻Ϥ뤫
	     (if
	      (and
	       (not
		(prime-context-candidate-window sc))
	       prime-use-candidate-window?
	       (> (prime-context-candidate-op-count sc)
		  prime-candidate-op-count))
	      (begin
		(prime-context-set-candidate-window! sc #t)
		(im-begin-candidate
		 id
		 (prime-get-nr-candidates sc)
		 0)))
	     ;;
	     (if (prime-context-candidate-window sc)
		 (im-update-candidate id (prime-context-nth sc)))
	     #f)
	   #t)
       (if (prime-prev-candidate key key-state)
	   (begin
	     (if (> (prime-context-nth sc) 0)
		 (prime-context-set-nth! sc (- (prime-context-nth sc) 1))
		 (prime-context-set-nth! sc (- (prime-get-nr-candidates sc) 1)))
	     (if
	      (and
	       (not
		(prime-context-candidate-window sc))
	       prime-use-candidate-window?
	       (> (prime-context-candidate-op-count sc)
		  prime-candidate-op-count))
	      (begin
		(prime-context-set-candidate-window! sc #t)
		(im-begin-candidate
		 id
		 (prime-get-nr-candidates sc)
		 0)))
	     (if (prime-context-candidate-window sc)
		 (im-update-candidate id (prime-context-nth sc)))
	     #f)
	   #t)
       (if (prime-cancel-key key key-state)
	   (begin
	     (if (prime-context-candidate-window sc)
		 (im-end-candidate id))
	     (prime-flush sc)
	     #f)
	   #t)
       (if (prime-commit-key key key-state)
	   (begin
	     (set! res (prime-get-current-candidate sc))
	     (set!
	      res
	      (string-append res
			     (prime-make-string (prime-context-tail sc)
					      (prime-context-kana-mode sc))))
;	     (prime-lib-learn-word
;	      (prime-make-string (prime-context-head sc) #t)
;	      (prime-context-okuri sc)
;	      (prime-context-nth sc))
	     (if (prime-context-candidate-window sc)
		 (im-end-candidate id))
	     (prime-flush sc)
	     (prime-context-set-state! sc 'prime-state-no-preedit)
	     (prime-update-mode id sc)
	     #f)
	   #t)
       (begin
	 (prime-context-set-state! sc 'prime-state-no-preedit)
	 (prime-update-mode id sc)
	 (set! res (prime-get-current-candidate sc))
	 (if (prime-context-candidate-window sc)
	     (im-end-candidate id))
	 (set!
	  res
	  (string-append res 
			 (prime-make-string
			  (prime-context-tail sc)
			  (prime-context-kana-mode sc))))
	 (prime-flush sc)
	 (let ((res2 (prime-proc-state-no-preedit c key key-state)))
	   (set!
	    res
	    (string-append res 
			   (prime-make-string
			    (prime-context-tail sc)
			    (prime-context-kana-mode sc))))
	   (if (string? res2)
	       (set! res
		 (string-append res res2))))))
        res)))

(define prime-proc-state-latin
  (lambda (c key key-state)
    (let ((sc (context-data c))
	  (id (context-id c)))
      (if
       (prime-on-key key key-state)
       (begin
	 (prime-context-set-state! sc 'prime-state-no-preedit)
	 (prime-update-mode (context-id c) sc))
       (im-commit-raw (context-id c)))
      ())))

(define prime-proc-state-wide-latin
  (lambda (c key key-state)
    (let* ((w (jp-wide (charcode->string key)))
	   (id (context-id c))
	   (sc (context-data c)))
      (if (prime-on-key key key-state)
	  (begin
	    (prime-flush sc)
	    (prime-update-mode id sc))
	  (if w
	      (im-commit id w)
	      (im-commit-raw id)))
      ())))

(define prime-push-key
  (lambda (c key key-state)
    (let* ((sc (context-data c))
	   (state (prime-context-state sc))
	   (fun)
	   (res))
      (if (= state 'prime-state-no-preedit)
	  (set! fun prime-proc-state-no-preedit))
      (if (= state 'prime-state-with-preedit)
	  (set! fun prime-proc-state-with-preedit))
      (if (= state 'prime-state-converting)
	  (set! fun prime-proc-state-converting))
      (if (= state 'prime-state-latin)
	  (set! fun prime-proc-state-latin))
      (if (= state 'prime-state-wide-latin)
	  (set! fun prime-proc-state-wide-latin))
      (set! res (fun c key key-state))
      (if res
	  (im-commit (context-id c) res))
      (prime-update-preedit
       (context-id c) sc))))

(define prime-init-handler
  (lambda (id arg)
    (let* ((c (find-context id)))
      (set-context-data! c
			 (prime-context-new))
      (im-clear-mode-list id)
      (im-pushback-mode-list id "RAW")
      (im-pushback-mode-list id "Ҥ餬")
      (im-pushback-mode-list id "")
      (im-pushback-mode-list id "ѱѿ")
      (im-update-mode-list id)
      (im-update-mode id 0))))

(define prime-press-key-handler
  (lambda (id key state)
    (let* ((c (find-context id)))
      (prime-push-key c key state))))

(define prime-release-key-handler
  (lambda (id key state)
    ()))

(define prime-reset-handler
  (lambda (id)
    ()))

(define prime-mode-handler
  (lambda (id mode)
    (let* ((c (find-context id))
	   (sc (context-data c)))
    (prime-flush sc)
    (if (= mode 0)
	(prime-context-set-state! sc 'prime-state-latin))
    (if (= mode 1)
	(begin
	  (prime-context-set-state! sc 'prime-state-with-preedit)
	  (prime-context-set-kana-mode! sc #t)))
    (if (= mode 2)
	(begin
	  (prime-context-set-state! sc 'prime-state-with-preedit)
	  (prime-context-set-kana-mode! sc #f)))
    (if (= mode 3)
	(prime-context-set-state! sc 'prime-state-wide-latin))
    (prime-update-preedit id sc)
    ())))

(define prime-get-candidate-handler
  (lambda (id idx)
    (let* ((c (find-context id))
	   (sc (context-data c)))
      (prime-get-nth-candidate sc idx))))

(define prime-set-candidate-index-handler
  (lambda (id idx)
    (let* ((c (find-context id))
	   (sc (context-data c)))
      (prime-context-set-nth! sc idx)
      (prime-update-preedit  id sc))))

(register-im
 'prime
 "ja"
 "EUC-JP"
 nil
 prime-init-handler
 nil
 prime-mode-handler
 prime-press-key-handler
 prime-release-key-handler
 prime-reset-handler
 prime-get-candidate-handler
 prime-set-candidate-index-handler)
