#include <string.h>
#include "context.h"
#include "siod.h"


extern LISP sym_t;

static LISP
string_equal(LISP x, LISP y)
{
  long xl, yl;
  char *xs, *ys;
  xs = get_c_string_dim(x, &xl);
  ys = get_c_string_dim(y, &yl);
  if (xl != yl) {
    return NIL;
  }
  if (!strncmp(xs, ys, xl)) {
    return (sym_t);
  }
  return NIL;
}

static LISP
charcode2string(LISP x)
{
  char buf[2];
  if (FLONUMP(x)) {
    buf[0] = FLONM(x);
  } else {
    buf[0] = 0;
  }
  buf[1] = 0;
    return strcons (1,buf);
}

static LISP
nthcdr(LISP nth_, LISP lst)
{
  int nth = get_c_long(nth_);
  int i;
  for (i = 0; i < nth; i++) {
    lst = CDR(lst);
  }
  return lst;
}

char *
uim_get_c_string(LISP str)
{
  char *s;
  long len;
  char *buf;
  s = get_c_string_dim(str, &len);
  buf = (char *)malloc(len + 1);
  strncpy(buf, s, len);
  buf[len] = 0;
  return buf;
}

static LISP
str_seq_equal(LISP seq, LISP rule)
{
  int sl = nlength(seq);
  int rl = nlength(rule);
  int i;
  if (sl != rl) {
    return NIL;
  }
  for (i = 0; i < sl; i++) {
    if (!string_equal(CAR(seq), CAR(rule))) {
      return NIL;
    }
    seq = CDR(seq);
    rule = CDR(rule);
  }
  return sym_t;
}

static LISP
str_seq_partial(LISP seq, LISP rule)
{
  int sl = nlength(seq);
  int rl = nlength(rule);
  int i;

  if (sl >= rl) {
    return NIL;
  }
  for (i = 0; i < sl; i++) {
    if (!string_equal(CAR(seq), CAR(rule))) {
      return NIL;
    }
    seq = CDR(seq);
    rule = CDR(rule);
  }
  if (rule && CAR(rule)) {
    return CAR(rule);
  }
  return sym_t;
}

LISP
rk_find_seq(LISP s, LISP rule)
{
  for (; rule != NIL; rule = CDR(rule)) {
    if (str_seq_equal(s, CAR(CAR(CAR(rule))))) {
      return CAR(rule);
    }
  }
  return NIL;
}

LISP
rk_find_partial_seq(LISP s, LISP rule)
{
  for (; rule != NIL; rule = CDR(rule)) {
    if (str_seq_partial(s, CAR(CAR(CAR(rule))))) {
      return CAR(rule);
    }
  }
  return NIL;
}

static LISP
rk_expect_seq(LISP seq, LISP rules)
{
  long flag;
  LISP cur, res = NIL;
  flag = no_interrupt(1);
  for (cur = rules; cur; cur = CDR(cur)) {
    LISP rule = CAR(cur);
    LISP e = str_seq_partial(seq, CAR(CAR(rule)));
    if (e &&
	sym_t != e) {
      res = cons(e, res);
    }
  }
  no_interrupt(flag);
  return res;
}

void
uim_init_util_subrs()
{
  init_subr_2("string-equal?", string_equal);
  init_subr_2("nthcdr", nthcdr);
  init_subr_1("charcode->string", charcode2string);
  init_subr_2("str-seq-equal?", str_seq_equal);
  init_subr_2("str-seq-partial?", str_seq_partial);
  init_subr_2("rk-find-seq", rk_find_seq);
  init_subr_2("rk-find-partial-seq", rk_find_partial_seq);
  init_subr_2("rk-expect-seq", rk_expect_seq);
}
