/*
 * 㼭
 */
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "mkdic.h"

#define LINE_LEN 256


struct use_case {
  int id[2];
  struct use_case *next;
};

struct uc_dict {
  struct use_case uc_head;
  int nr_ucs;
  struct entry_stat *entry_list;
};

static int
find_name(struct uc_dict *dict, char *yomi, char *word, char *wt)
{
  struct entry_stat *es;
  xstr *xs = anthy_cstr_to_xstr(yomi);
  for (es = dict->entry_list; es; es = es->next) {
    if (!anthy_xstrcmp(es->index_str, xs)) {
      int i;
      for (i = 0; i < es->nr_entries; i++) {
	struct word_entry *we = &es->entries[i];
	if (!strcmp(word, we->word) &&
	    !strcmp(wt, we->wt)) {
	  anthy_free_xstr(xs);
	  return we->offset;
	}
      }
    }
  }
  anthy_free_xstr(xs);
  return -1;
}

static int
read_word_line(struct uc_dict *dict, char *buf)
{
  char yomi[LINE_LEN];
  char okuri[LINE_LEN];
  char wt[LINE_LEN];
  char kanji[LINE_LEN];
  int res;

  res = sscanf(buf, "%s %s %s %s", yomi, okuri, wt, kanji);
  if (res != 4) {
    return -1;
  }
  return find_name(dict, yomi, kanji, wt);
}

static void
commit_uc(struct uc_dict *dict, int x, int y)
{
  struct use_case *uc = malloc(sizeof(struct use_case));
  uc->id[0] = x;
  uc->id[1] = y;
  /**/
  uc->next = dict->uc_head.next;
  dict->uc_head.next = uc;
  dict->nr_ucs ++;
}

static
void read_file(struct uc_dict *dict, const char *fn)
{
  char buf[LINE_LEN];
  FILE *uc_file;
  int off, base, cur;
  uc_file = fopen(fn, "r");
  if (!uc_file) {
    return ;
  }
  off = 0;
  while (fgets(buf, LINE_LEN, uc_file)) {
    /**/
    if (buf[0] == '#') {
      continue;
    }
    if (buf[0] == '-') {
      off = 0;
      continue;
    }
    cur = read_word_line(dict, buf);
    if (off == 0) {
      base = cur;
    } else {
      commit_uc(dict, cur, base);
    }
    off ++;
  }
}

static void
build_ucfile(struct uc_dict *dict)
{
  (void)dict;
}

static void
output_ucfile(FILE *out, struct uc_dict *dict)
{
  struct use_case *uc;
  write_nl(out, 0x75646963);/*MAGIC udic*/
  write_nl(out, 0);/*Version*/
  write_nl(out, 16);/*Header Size*/
  write_nl(out, dict->nr_ucs);
  for (uc = dict->uc_head.next; uc; uc = uc->next) {
    write_nl(out, uc->id[0]);
    write_nl(out, uc->id[1]);
  }
}

void
mkucdic(FILE *uc_out, const char *fn, struct entry_stat *es)
{
  struct uc_dict dict;

  dict.entry_list = es;
  dict.uc_head.next = NULL;
  dict.nr_ucs = 0;

  if (!fn) {
    return ;
  }
  read_file(&dict, fn);
  /* ΤȤ⤷ʤ */
  build_ucfile(&dict);
  /**/
  output_ucfile(uc_out, &dict);
  printf("udic: %d use examples.\n", dict.nr_ucs);
}
