;;
(define canna-init-lib-ok? nil)
;;
(define canna-context-id
  (lambda (cc)
    (car (nthcdr 0 cc))))
;;
(define canna-context-set-id!
  (lambda (cc id)
    (set-car! (nthcdr 0 cc) id)))
;;
(define canna-context-new
  (lambda ()
    (let ((c (copy-list '(()))))
      (canna-context-set-id!
       c
       (canna-lib-alloc-id)))))
;;
(define canna-init-handler
  (lambda (id arg)
    (let ((c (find-context id)))
      (set-context-data! c (if canna-init-lib-ok? (canna-context-new)())))
      ())
    ())
;;
(define canna-release-handler
  (lambda (id)
    ()))
;;
(define canna-mode-handler
  (lambda (id mode)
    ()))
;;
(define canna-press-key-handler
  (lambda (id key key-state)
    (canna-lib-push-key id key)
    ()))
;;
(define canna-release-key-handler
  (lambda (id key key-state)
    ()))
;;
(define canna-reset-handler
  (lambda (id)
    ()))

(if (and
     (symbol-bound? 'canna-lib-init)
     (canna-lib-init))
    (set! canna-init-lib-ok? #t))

;;
(define canna-get-candidate-handler
  (lambda (id idx)
    ()))
;;
(define canna-set-candidate-index-handler
  (lambda (id idx)
    ()))
;;
(register-im
 'canna
 "ja"
 "EUC-JP"
 nil
 canna-init-handler
 canna-release-handler
 canna-mode-handler
 canna-press-key-handler
 canna-release-key-handler
 canna-reset-handler
 canna-get-candidate-handler
 canna-set-candidate-index-handler)
