#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <ctype.h>
#include <X11/Xatom.h>
#include "xim.h"
#include "convdisp.h"
#include "ximserver.h"

#ifndef __GNUC__
# ifdef HAVE_ALLOCA_H
#  include <alloca.h>
# endif
#endif

extern Atom xim_servers;

int jstring_get_ctext_len(jstring_t *s)
{
    jstring_t::iterator i;
    bool jp_mode;
    int len;
    int cur;
    
    jp_mode = false;
    len = 0;

    for (i = s->begin(); i != s->end(); i++) {
	cur = *i;
	if (!(cur & 0xff00)) {
	    // 2byteʸǤϤʤ
	    if (jp_mode) {
		jp_mode = false;
		len += 4;
	    } else {
		len += 1;
	    }
	} else {
	    // 2byteʸ
	    if (jp_mode) {
		len += 2;
	    } else {
		len += 6;
		jp_mode = true;
	    }
	}
    }
    if (jp_mode) {
	len += 3;
    }
    return len;
}

char *jstring_to_ctext(jstring_t *s)
{
    int len;
    char *t;
    
    len = jstring_get_ctext_len(s);
    t = (char *)malloc(len+1);
    t[len] = 0;
    
    jstring_t::iterator i;
    bool jp_mode=false;
    int cur,j=0;
    for (i = s->begin(); i != s->end(); i++) {
	cur = *i;
	if (!(cur & 0xff00)) {
	    // 1byteʸ
	    if (jp_mode) {
		t[j++] = 0x1b;
		t[j++] = 0x28;
		t[j++] = 0x42;
		jp_mode = false;
	    }
	    t[j++] = cur & 0xff;
	} else {
	    if (!jp_mode) {
		jp_mode = true;
		t[j++] = 0x1b;
		t[j++] = 0x24;
		t[j++] = 0x29;
		t[j++] = 0x42;
	    }
	    t[j++] = (cur >> 8)|0x80;
	    t[j++] = (cur & 0xff)|0x80;
	}
    }
    if (jp_mode) {
	t[j++] = 0x1b;
	t[j++] = 0x28;
	t[j++] = 0x42;
    }
    return t;
}

char *jstring_to_str(jstring_t *s)
{
    //XmbTextListToTextProperty
    jstring_t::iterator i;
    int l=0;
    char *c;
    for (i = s->begin(); i!= s->end(); i++) {
        l++;
        if (*i > 256) {
            l ++;
        }
    }
    c = (char *)malloc(l+1);
    c[l] = 0;
    l = 0;
    for (i = s->begin() ; i!= s->end(); i++) {
        if (*i < 256) {
            c[l] = *i;
            l++;
        } else {
            c[l] = ((*i)>>8)|0x80;
            c[l+1] = ((*i)&0xff)|0x80;
            l+=2;
        }
    }
    return c;
}

// XXX ư̤
void ctext_to_jstring(char *c, jstring_t *s)
{
    bool jp_mode = false;
    while (*c) {
        if (jp_mode) {
            if (*c != 0x1b) {
                s->push_back(c[0]*256+c[1]);
            } else {
                jp_mode = false;
                c++;c++;c++;
            }
        } else {
            if (*c != 0x1b) {
                s->push_back(*c);
                c++;
            } else {
                jp_mode = true;
                c++;c++;c++;
            }
        }
    }
}

void print_jstring(jstring_t *s)
{
    jstring_t::iterator i;
    printf("length=%d : ", s->size());
    int ch;
    char buf[3];
    for (i = s->begin(); i != s->end(); i++) {
        ch = *i;
	buf[1]=0;
	buf[2]=0;
        if (ch < 256) {
	    buf[0]=ch;
        } else {
	    buf[1]=(ch & 255)|0x80;
	    buf[0]=((ch>>8)&255)|0x80;
        }
	printf(buf);
    }
    printf("\n");
}

void erase_jstring(jstring_t *s)
{
    s->erase(s->begin(), s->end());
}

void append_jstring(jstring_t *d, jstring_t *s)
{
    jstring_t::iterator i;
    for (i = s->begin(); i !=s->end(); i++) {
        d->push_back(*i);
    }
}

// EUCJISξб
void str_to_jstring(jstring_t *d, char *s)
{
    int i,len;
    bool inJis= false;
    len = strlen(s);
    for (i = 0; i < len; i++) {
	if (s[i] == 0x1b) {
	    if (s[i+1] == 0x24 && s[i+2]== 0x42) {
		inJis = true;
	    } else if (s[i+1] == 0x28 && s[i+2] == 0x42) {
		inJis = false;
	    }
	    i += 2;
	} else if(inJis || (s[i] & 0x80)) {
	    //2Хʸ
	    cchar ch;
	    ch = ((s[i]&0x7f)<<8)|(s[i+1]&0x7f);
	    i++;
	    d->push_back(ch);
	} else {
	    d->push_back(s[i]);
	}
    }
}

XimServer::XimServer(char *name, char *lang)
{
    mName = name;
    mLang = lang;
}

InputContext *XimServer::createContext(XimIC *xic)
{
    InputContext *ic = new InputContext(xic);
    uim_context uc = uim_create_context((void *) ic, "EUC-JP",
					NULL, mName, InputContext::commit_cb);
    uim_set_preedit_cb(uc,
		       InputContext::clear_cb,
		       InputContext::pushback_cb,
		       InputContext::update_cb);
    ic->setUC(uc);
    return ic;
}

bool
XimServer::setupConnection()
{
    char *buf = (char *)alloca(15 + strlen(mName));
    sprintf(buf, "@server=uim-%s", mName);
    mServerAtom = XInternAtom(XimServer::gDpy, buf, 0);
    Window owner = XGetSelectionOwner(XimServer::gDpy, mServerAtom);
    if (owner != None) {
	printf("Another instance exists(%s).\n", mName);
	return false;
    }
    mSelectionWin = XCreateSimpleWindow(XimServer::gDpy,
					DefaultRootWindow(XimServer::gDpy),
					0, 0, 1, 1,
					1,0,0);
    XSetSelectionOwner(XimServer::gDpy, mServerAtom, mSelectionWin, CurrentTime);
    XSelectInput(XimServer::gDpy, DefaultRootWindow(XimServer::gDpy), 0);
    XSync(XimServer::gDpy, False);

    Atom type;
    int format;
    unsigned long nr_prop,nr_bytes;
    Atom *prop;
    int mode = PropModePrepend;
    int valuechange = 1;

    XGetWindowProperty(XimServer::gDpy, DefaultRootWindow(XimServer::gDpy),
                       xim_servers, 0, 8192 ,False,
                       XA_ATOM, &type, &format,
                       &nr_prop, &nr_bytes, (unsigned char **)&prop);
    int i;
    if (type != XA_ATOM || format != 32) {
	mode = PropModeReplace;
    } else {
	for (i = 0 ; i < (int)nr_prop ; i++) {
	    if (prop[i] == mServerAtom) {
		mode = PropModeAppend;
		valuechange = 0;
		break;
	    }
	}
    }
    if (nr_prop) {
	XFree(prop);
    }

    XChangeProperty(XimServer::gDpy, DefaultRootWindow(XimServer::gDpy),
		    xim_servers,
		    XA_ATOM, 32,
		    mode, (unsigned char *)&mServerAtom,
		    valuechange ? 1 : 0);
    std::pair<Window, XimServer *> p(mSelectionWin, this);
    gServerMap.insert(p);
    return true;
}

XimServer *XimServer::findServer(Window w)
{
    std::map<Window, XimServer *>::iterator it;
    it = gServerMap.find(w);
    if (it == gServerMap.end()) {
	return NULL;
    }
    return it->second;
}

bool XimServer::isSupportedLanguage(char *lang)
{
    if (!strcmp(lang, "ja")) {
	return true;
    }
    return false;
}

//
// InputContextΥ᥽å
InputContext::InputContext(XimIC *ic)
{
    mXic = ic;
    m_pe = new pe_stat(this);
    mConvdisp = 0;
    mUc = 0;
}

InputContext::~InputContext()
{
    if (mConvdisp) {
	mConvdisp->set_pe(0);
    }
    delete m_pe;
    uim_release_context(mUc);
}

void
InputContext::setUC(uim_context uc)
{
    mUc = uc;
}

void
InputContext::commit_cb(void *ptr, char *str)
{
    InputContext *ic = (InputContext *)ptr;
    XimIC *xic = ic->get_ic();
    jstring_t js;
    str_to_jstring(&js, str);
    xic->commit_jstring(&js);
}

void InputContext::clear_cb(void *ptr)
{
    InputContext *ic = (InputContext *)ptr;
    ic->clear_preedit();
}

void InputContext::pushback_cb(void *ptr, int attr, char *str)
{
    InputContext *ic = (InputContext *)ptr;
    ic->pushback_preedit_string(attr, str);
}

void InputContext::update_cb(void *ptr)
{
    InputContext *ic = (InputContext *)ptr;
    ic->update_preedit();
}

void InputContext::clear_preedit()
{
    m_pe->clear();
}

void InputContext::pushback_preedit_string(int attr, char *str)
{
    int p = 0;
    if (attr & UPeAttr_UnderLine) {
	p |= PE_UNDERLINE;
    }
    if (attr & UPeAttr_Reverse) {
	p |= PE_REVERSE;
    }
    m_pe->new_segment(p);
    jstring_t js;
    str_to_jstring(&js, str);

    jstring_t::iterator it;
    for (it = js.begin(); it != js.end(); it++) {
	m_pe->push_cchar(*it);
    }
}

void InputContext::update_preedit()
{
    if (mConvdisp) {
	mConvdisp->update_preedit();
    }
}

int InputContext::pushKey(keyState *k)
{
    int key = k->key();
    if (key != UKey_Other) {
	int rv;
	rv = uim_press_key(mUc, key, k->modifier());
	if (rv) {
	    return COMMIT_RAW;
	}
    }
    return DO_NOTHING;
}

int InputContext::getMode()
{
}

void InputContext::setMode(int mode)
{
}

jstring_t *InputContext::clear()
{
}

void InputContext::setConvdisp(Convdisp *c)
{
    mConvdisp = c;
    if (mConvdisp) {
	mConvdisp->set_pe(m_pe);
    }
}

void InputContext::commit_jstring(jstring_t *s)
{
    mXic->commit_jstring(s);
}

bool InputContext::extra_input(jstring_t *s)
{
    return false;
}

XimIC *InputContext::get_ic()
{
    return mXic;
}

keyState::keyState(keyEventX *x)
{
    mModifier = 0;
    if (x->state & 1) {
	mModifier += UKey_Shift;
    }
    if (x->state & 2) {
	mModifier |= UKey_Alt;
    }
    if (x->state & 4) {
	mModifier |= UKey_Control;
    }
    if (x->state & 8) {
	mModifier |= UKey_Meta;
    }
    if (x->key_sym < 128 && x->key_sym >= 32) {
	mKey = x->key_sym;
    } else {
	switch (x->key_sym) {
	case XK_BackSpace: mKey = UKey_Backspace; break;
	case XK_Delete: mKey = UKey_Delete; break;
	case XK_Escape: mKey = UKey_Escape; break;
	case XK_Tab: mKey = UKey_Tab; break;
	case XK_Return: mKey = UKey_Return; break;
	case XK_Left: mKey = UKey_Left; break;
	case XK_Up: mKey = UKey_Up; break;
	case XK_Right: mKey = UKey_Right; break;
	case XK_Down: mKey = UKey_Down; break;
	case XK_Prior: mKey = UKey_Prior; break;
	case XK_Next: mKey = UKey_Next; break;
	case XK_Home: mKey = UKey_Home; break;
	case XK_End: mKey = UKey_End; break;
	case XK_Zenkaku_Hankaku: mKey = UKey_Zenkaku_Hankaku; break;
	case XK_F1: mKey = UKey_F1; break;
	case XK_F2: mKey = UKey_F2; break;
	case XK_F3: mKey = UKey_F3; break;
	case XK_F4: mKey = UKey_F4; break;
	case XK_F5: mKey = UKey_F5; break;
	case XK_F6: mKey = UKey_F6; break;
	case XK_F7: mKey = UKey_F7; break;
	case XK_F8: mKey = UKey_F8; break;
	case XK_F9: mKey = UKey_F9; break;
	case XK_F10: mKey = UKey_F10; break;
	case XK_F11: mKey = UKey_F11; break;
	case XK_F12: mKey = UKey_F12; break;
	default: mKey = UKey_Other;
	}
    }
}

int keyState::key()
{
    return mKey;
}


int keyState::modifier()
{
    return mModifier;
}

bool keyState::is_push()
{
    return m_bPush;
}

void keyState::print()
{
    printf("key code=%x,modifier=%d.\n",
	   mKey, mModifier);
}
/*
 * Local variables:
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 */
