// -*- C++ -*-
#ifndef _converter_h_included_
#define _converter_h_included_

#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/keysymdef.h>
#include <stdio.h>
#include <list>
#include <vector>
#include <map>
#include <uim/uim.h>


bool pretrans_register();
int connection_setup();
void main_loop();

//ѴΥݡ
// jstring ʸ

// preeditν
#define PE_NORMAL 0
#define PE_REVERSE 1
#define PE_UNDERLINE 2
#define PE_HILIGHT 4

typedef int cchar;
typedef std::list<cchar> jstring_t;
struct pe_jstring{
    jstring_t s;
    int stat;
};

// ץꥨǥåȤξ
// ˴InputContextΥ󥹥ȥ饯ǥȥ饯ǹԤʤ
class pe_stat {
public:
    pe_stat(class InputContext *);
    void clear();
    void new_segment(int s);
    void push_cchar(cchar );
    int get_char_count();
    std::list<pe_jstring> jstrings; //ʸڤ줿Ρ
    class InputContext *cont;
};

void print_jstring(jstring_t *s);
void erase_jstring(jstring_t *s);
void append_jstring(jstring_t *d,jstring_t *s);
void str_to_jstring(jstring_t *d,char *s);// JIS or EUC
char *jstring_to_str(jstring_t *s);// EUCȤ֤äƤ롣

//
void init_converter();

void global_finalize(int );

// 桼󥿡եȤ
void init_convdisp();

// misc
int pad4(int );

// debug functions
void hex_dump(unsigned char *buf,int len);


// ưץ󡢼˵ưΥޥɥ饤󥪥ץǷޤ롣
// 饤ȤȤΤפ
#define OPT_TRACE 1
// XIM̿פ
#define OPT_TRACE_XIM 2


// byte order
#define BYTEORDER_UNKNOWN 0
#define LSB_FIRST 1
#define MSB_FIRST 2


// 
extern int host_byte_order;
extern int g_option_mask;
extern int scr_width,scr_height;

#define DO_NOTHING 0
#define COMMIT_RAW 1
#define UPDATE_MODE 2

// ȤΥ٥ȤѴԤʤäƱؿǲ
class keyState {
public:
    keyState(class keyEventX *);
    int key();
    int modifier();

    bool is_push();//򲡤Τ(ΥΤǤϤʤ)
    void print();
private:
    int mKey;
    int mModifier;
    bool m_bPush;
};

class XimIC;
class Convdisp;
class InputContext {
public:
    InputContext(XimIC *);
    ~InputContext();
    void setUC(uim_context );
    int pushKey(keyState *e);
    int getMode();
    void setMode(int mode);
    jstring_t * clear();
    void setConvdisp(Convdisp *);
    XimIC *get_ic();
    bool extra_input(jstring_t *s);
    void clear_preedit();
    void pushback_preedit_string(int attr, char *str);
    void update_preedit();
public:
    static void commit_cb(void *, char *);
    static void clear_cb(void *);
    static void pushback_cb(void *, int attr, char *str);
    static void update_cb(void *);
protected:
    void commit_jstring(jstring_t *);
    XimIC *mXic;
    pe_stat *m_pe;
    Convdisp *mConvdisp;
    uim_context mUc;
};

//ĤѴ󥸥ɽ魯e.g.SKK,Canna,Wnn etc
class XimServer {
public:
    XimServer(char *name, char *lang);
    ~XimServer(){};
    InputContext *createContext(XimIC *);

    bool setupConnection();
    void setupNewConnection(XClientMessageEvent *ev);
public:
    static XimServer *findServer(Window w);
    static bool isSupportedLanguage(char *);
    static Display *gDpy;
    static std::map<Window , XimServer *>gServerMap;
private:
    Window mSelectionWin;
    Atom mServerAtom;
    char *mName, *mLang;
};

char *jstring_to_ctext(jstring_t *s);
void ctext_to_jstring(char *,jstring_t *);

#endif
/*
 * Local variables:
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 */
