#include <sys/socket.h>
#include <sys/types.h>
#include <sys/un.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>


int uim_init_client_fd(char *path)
{
    int fd;
    struct sockaddr_un server;

    if(!path)
      return -1;

    memset(&server, 0, sizeof(server));
    
    server.sun_family = PF_UNIX;
    strcpy(server.sun_path, path);

    fd = socket(PF_UNIX, SOCK_STREAM, 0);
    if (fd < 0) {
      perror("fail to create socket");
      return -1;
    }

    if(connect(fd,&server,sizeof(server.sun_family)+ strlen(path))== -1){
      perror("failed to connect to server");
      return -1;
    }

    printf("connected to server at %s\n", path);

    return fd;
}


int uim_helper_client_proc(int fd)
{
 char buf[1024];
 int    ret;

 while (fgets(buf, 1024, stdin)) {
   write(fd, buf, strlen(buf));
   printf("%s",buf);
 }
 return fd;
}

int main(void)
{
  int fd;
  char *path = uim_helper_get_pathname();

  fd = uim_init_client_fd(path);

  if(fd < 0) {
    perror("failed to init fd");
  }

  uim_helper_client_proc(fd);

}
