#include <sys/socket.h>
#include <sys/types.h>
#include <sys/un.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>


#define MAX_CLIENT 32
#define BUFFER_SIZE 1024

/*
  ФΥե뵭һ(file descripter)롣
  δؿȤϥͥåȥطΥץ񤯺ݤˤ
  ǥŪˤ褯ȤΤǡؿν餤ˤܤ̤٤
*/
int init_serv_fd(char *path)
{
    int foo;
    int fd;
    struct sockaddr_un myhost;

    fd = socket(PF_UNIX, SOCK_STREAM, 0);
    if (fd < 0) {
	perror("failed in socket()");
	return -1;
    }

    /*    foo = 1;
    foo = setsockopt(fd, SOL_SOCKET, SO_REUSEADDR, &foo, sizeof(&foo));
    if (foo <0 ) {
        perror("failed to set reuse option");
    }
    */
    myhost.sun_family = PF_UNIX;
    strcpy(myhost.sun_path, path);

    foo = bind(fd,(struct sockaddr *)&myhost,sizeof(myhost.sun_family) + strlen(path));
    if(foo < -1){
	perror("failed in bind()");
	return -1;
    }

    /*SOMAXCONNʤ5򤤤뤳Ȥ¿*/
    foo = listen(fd, SOMAXCONN);
    if ( foo == -1){
	perror("failed in listen()");
	return -1;
    }
    printf("listen%d\n",SOMAXCONN);
    return fd;
}

int proc_func(int fd)
{
  int recieve_len,i,res;
  char buf[BUFFER_SIZE];
  char *content = NULL;
  FILE *rfile;

  rfile = fdopen(fd, "r");

  fgets(buf, sizeof(buf), rfile );
    
    if(!content)
      content = (char*)malloc(strlen(buf));

  /*    else
	content = (char*)realloc(content, strlen(content) + strlen(buf));*/

    strcat(content,buf);
    printf("%s",content);
 

  printf("recieve:%s\n",content);

  free(content);

  return recieve_len;
}

process_connection(int serv_fd, int (*proc_func)(int fd) )
{
  fd_set readfds;
  int clientfd[MAX_CLIENT];
  int nclients = 0;
  int i;
  int fd_biggest = 0;

  fd_biggest = serv_fd;

  while(1) {
    
    FD_ZERO(&readfds);
    
    FD_SET(serv_fd, &readfds);  
    for (i = 0; i < nclients; i ++) {
      FD_SET(clientfd[i], &readfds);
      printf("fd_set %d\n",clientfd[i]);
    }
    
    if ( select(fd_biggest+1, &readfds, NULL, NULL, NULL) < 0 ) {
      perror("select faild");
    }
    
    /* for accept new connection */
    if (FD_ISSET(serv_fd, &readfds)) {
      struct sockaddr_un clientsoc;
      socklen_t len = sizeof(clientsoc);
      int new_fd;
      new_fd = accept(serv_fd, (struct sockaddr *)&clientsoc, &len);
      if(new_fd < 0) {
	perror("accpet failed");
	continue;
      }
      if(fd_biggest < new_fd )
	fd_biggest = new_fd;
	
      clientfd[nclients] = new_fd;
      nclients++;
      printf("accept new fd:%d\n",new_fd);
    }    
    
    /* check data from clients are reached */
    for (i = 0; i < nclients; i ++){
      if (FD_ISSET(clientfd[i], &readfds)) {
	int result;
	/* actual process */
	result = (*proc_func)(clientfd[i]);

	if(result < 0) {
	  close( clientfd[i] );
	  clientfd[i] = clientfd[nclients-1];
	  nclients--;
	}
      }
    }

  }
  
}
int
main(int argc, char **argv)
{
  char *path = uim_helper_get_pathname();
  int serv_fd = init_serv_fd(path);

  if (serv_fd < 0) {
    printf("Failed to init unix domain socket\n");
    return 0;
  }
  printf("Waiting for connection at %s\n", path);

  process_connection(serv_fd, proc_func);

  return 0;
}


