#include <signal.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <stdio.h>


int
uim_ipc_open_command(int old_pid, FILE **read_handler, FILE **write_handler, char *command)
{
  int new_pid;

  if (*read_handler  != NULL)
    fclose(*read_handler);
  if (*write_handler != NULL)
    fclose(*write_handler);
  
  *read_handler = *write_handler = NULL;
  
  /* kill child process if exists */
  if (old_pid)
    kill(old_pid, SIGKILL);

  new_pid = open_pipe_rw(read_handler, write_handler);
  if (new_pid < 0)
    goto err0;
  if (new_pid == 0) {
    /* child */
    myExec(command);
  }
  return new_pid;
 err0:
  return 0;
}

static pid_t
open_pipe_rw(FILE **fr, FILE **fw)
{
    int fdr[2];
    int fdw[2];
    pid_t pid;

    if (fr && pipe(fdr) < 0)
	goto err0;
    if (fw && pipe(fdw) < 0)
	goto err1;

    pid = fork();
    if (pid < 0)
	goto err2;
    if (pid == 0) {
	/* child */
	if (fr) {
	    close(fdr[0]);
	    dup2(fdr[1], 1);
	}
	if (fw) {
	    close(fdw[1]);
	    dup2(fdw[0], 0);
	}
    }
    else {
	if (fr) {
	    close(fdr[1]);
	    if (*fr == stdin)
		dup2(fdr[0], 0);
	    else
		*fr = fdopen(fdr[0], "r");
	}
	if (fw) {
	    close(fdw[0]);
	    if (*fw == stdout)
		dup2(fdw[1], 1);
	    else
		*fw = fdopen(fdw[1], "w");
	}
    }
    return pid;
  err2:
    if (fw) {
	close(fdw[0]);
	close(fdw[1]);
    }
  err1:
    if (fr) {
	close(fdr[0]);
	close(fdr[1]);
    }
  err0:
    return (pid_t) -1;
}

void
myExec(char *command)
{
    execl("/bin/sh", "sh", "-c", command, NULL);
    exit(127);
}
