#include <signal.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>

#include "context.h"

static FILE *primer = NULL, *primew = NULL;
static int prime_pid = 0;

extern LISP sym_t;

static char *prime_command = "prime";

static LISP
prime_send_command(LISP str_)
{
  char *str = get_c_string( str_ );
  char *result;
  LISP ret;

  result = uim_ipc_send_command(&prime_pid, primer, primew, prime_command, str);

  if(result == NULL)
    {
      return NIL;
    }

 ret = strcons( strlen(result), result );
 free(result);
 return ret;

}

static LISP
prime_lib_init(void)
{
  prime_pid = uim_ipc_open_command(prime_pid, &primer, &primew, prime_command );
  if(prime_pid == 0) {
    return NIL;
  }
  return sym_t;
}


static char **
uim_strsplit(char *splittee, char *splitter)
{
  char *cur, *tmp;
  int nr_token = 0;
  int in_token = 0;
  char **res;
  int len;
  int i;

  if(!splittee || !splitter)
    return NULL;


  /* count the number of token */
  cur = splittee;
  while (*cur) {
    if (strchr(splitter, *cur)) {
      in_token = 0;
    } else {
      if (!in_token) {
	nr_token ++;
      }
      in_token = 1;
    }
    cur ++;
  }
  /* allocate buffer */
  res = (char **)malloc(sizeof(char *) * (nr_token + 1) );
  if (!res) {
    return NULL;
  }
  /**/
  cur = splittee;
  for (i = 0; i < nr_token; i++) {
    /* find current token's start */
    while (strchr(splitter, *cur)) {
      cur ++;
    }
    /* calc length */
    len = 0;
    tmp = cur;
    while (!strchr(splitter, *tmp)) {
      len ++;
      tmp ++;
    }
    /* store */
    res[i] = malloc(sizeof(char *) * (len + 1));
    strncpy(res[i], cur, len);
    res[i][len] = 0;
    cur = tmp;
  }
  /**/
  res[nr_token] = NULL;

  return res;
}

static LISP
prime_split_string(LISP _splittee, LISP _splitter)
{
  char *splittee = get_c_string(_splittee);
  char *splitter = get_c_string(_splitter);
  char **strs;
  LISP l = NIL;
  int i;
  int j;

  if(_splittee == NULL || _splitter == NULL)
    return NIL;

  if(splittee == NULL || splitter == NULL)
    return NIL;

   strs = uim_strsplit(splittee, splitter);

   if(!strs || !*strs)
     return NIL;

   for(j = 0;strs[j] != '\0' ; j++){}

   j--;
   
   for(i = j; i >= 0 ; i--)
     {
       l = cons ( strcons( strlen(strs[i]), strs[i] ), l );
            free(strs[i]);
     }
   free(strs);
   return l;
}

void
uim_init_prime(void)
{
  init_subr_0("prime-lib-init", prime_lib_init);
  init_subr_1("prime-lib-send-command", prime_send_command);
  init_subr_2("prime-string-split", prime_split_string);
}
