// -*- C++ -*-
#ifndef _ximserver_h_included_
#define _ximserver_h_included_

#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/keysymdef.h>
#include <stdio.h>
#include <list>
#include <vector>
#include <map>
#include <uim/uim.h>
#include <uim/uim-helper.h>


bool pretrans_register();
int connection_setup();
void main_loop();

//ѴΥݡ
// uString ʸ

// preeditν
#define PE_NORMAL 0
#define PE_REVERSE 1
#define PE_UNDERLINE 2
#define PE_HILIGHT 4

typedef int uchar;
typedef std::list<uchar> uString;
struct pe_ustring{
    uString s;
    int stat;
};

// ץꥨǥåȤξ
// ˴InputContextΥ󥹥ȥ饯ǥȥ饯ǹԤʤ
class pe_stat {
public:
    pe_stat(class InputContext *);
    void clear();
    void new_segment(int s);
    void push_uchar(uchar );
    int get_char_count();
    int caret_pos;
    std::list<pe_ustring> ustrings; //ʸڤ줿Ρ
    class InputContext *cont;
};

void print_ustring(uString *s);
void erase_ustring(uString *s);
void append_ustring(uString *d,uString *s);
void str_to_ustring(uString *d,char *s);// JIS or EUC

//
void init_converter();

void global_finalize(int );

// 桼󥿡եȤ
void init_convdisp();

// misc
int pad4(int );

// debug functions
void hex_dump(unsigned char *buf,int len);


// ưץ󡢼˵ưΥޥɥ饤󥪥ץǷޤ롣
// 饤ȤȤΤפ
#define OPT_TRACE 1
// XIM̿פ
#define OPT_TRACE_XIM 2


// byte order
#define BYTEORDER_UNKNOWN 0
#define LSB_FIRST 1
#define MSB_FIRST 2


// 
extern int host_byte_order;
extern int g_option_mask;
extern int scr_width,scr_height;

#define DO_NOTHING 0
#define COMMIT_RAW 1
#define UPDATE_MODE 2

// ȤΥ٥ȤѴԤʤäƱؿǲ
class keyState {
public:
    keyState(class keyEventX *);
    int key();
    int modifier();

    bool is_push();//򲡤Τ(ΥΤǤϤʤ)
    void print();
private:
    int mKey;
    int mModifier;
    bool m_bPush;
};

class XimIC;
class Convdisp;
class XimServer;
class InputContext {
public:
    InputContext(XimServer *, XimIC *);
    ~InputContext();
    void setUC(uim_context );
    int pushKey(keyState *e);
    int getMode();
    void setMode(int mode);
    uString * clear();
    void setConvdisp(Convdisp *);
    XimIC *get_ic();
    XimServer *getServer();
    bool extra_input(char *s);
    void clear_preedit();
    void pushback_preedit_string(int attr, char *str);
    void update_preedit();
    void candidate_begin(int nr, int index);
    void candidate_update(int index);
    void candidate_end();
public:
    static void commit_cb(void *, char *);
    static void clear_cb(void *);
    static void pushback_cb(void *, int attr, char *str);
    static void update_cb(void *);
    static void candidate_begin_cb(void *ptr, int nr, int index);
    static void candidate_update_cb(void *ptr, int index);
    static void candidate_end_cb(void *ptr);
protected:
    void commit_string(char *);
    XimIC *mXic;
    XimServer *mServer;
    pe_stat *m_pe;
    Convdisp *mConvdisp;
    uim_context mUc;
};

//ĤѴ󥸥ɽ魯e.g.SKK,Canna,Wnn etc
class XimServer {
public:
    XimServer(char *name, char *lang);
    ~XimServer(){};
    InputContext *createContext(XimIC *);

    bool setupConnection();
    void setupNewConnection(XClientMessageEvent *ev);
    char *uStringToCtext(uString *js);
public:
    static XimServer *findServer(Window w);
    static bool isSupportedLanguage(char *);
    static Display *gDpy;
    static std::map<Window , XimServer *>gServerMap;
private:
    Window mSelectionWin;
    Atom mServerAtom;
    char *mName, *mLang;
};

char *string_to_ctext(char *s);

#endif
/*
 * Local variables:
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 */
