#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif  


#include <gtk/gtk.h>
#include <stdlib.h>
#include <locale.h>
#include <panel-applet.h>
#include <gnome.h>
#include <libgnome/libgnome.h>
#include "comm.h"
#include "on.xpm"
#include "off.xpm"

static GtkWidget *opt_menu;
static GtkWidget *draw_win;
static GtkWidget *mode_menu;
static GtkItemFactory *mode_item_fact;
static GtkWidget *mode_button;
static GtkWidget *state_img;

static char hira[]={ 0xe3,0x81,0xb2,0 };
static char hira2[]={ '/',0xe3,0x81,0xb2,0 };


static int event_fd;
static GdkPixbuf *on_pxbuf, *off_pxbuf;
static int jmode_stat;

static void 
display_help_dialog (BonoboUIComponent *uic, gpointer data, const gchar *verbname);
static void
display_about_dialog(BonoboUIComponent *uic, gpointer data, const gchar *verbname);

static void
mode_button_pressed(GtkButton *mode_button, gpointer *user_data);
static void
menu_button_position(GtkMenu *menu, gint *x, gint *y, gboolean *push_in,
		     gpointer *user_data);

static void
activate_event(GtkWidget *g, gpointer p);

static const BonoboUIVerb jmode_menu_verbs [] = {
  /* BONOBO_UI_VERB ("JmodeProperties", display_properties_dialog),*/
  BONOBO_UI_VERB ("JmodeHelp",       display_help_dialog),
  BONOBO_UI_VERB ("JmodeAbout",      display_about_dialog),
  BONOBO_UI_VERB_END
};


static const char jmode_menu_xml [] =
        "<popup name=\"button3\">\n"
        "   <menuitem name=\"Properties Item\" verb=\"JmodeProperties\" _label=\"Properties ...\"\n"
        "             pixtype=\"stock\" pixname=\"gtk-properties\"/>\n"
        "   <menuitem name=\"Help Item\" verb=\"JmodeHelp\" _label=\"Help\"\n"
        "             pixtype=\"stock\" pixname=\"gtk-help\"/>\n"
        "   <menuitem name=\"About Item\" verb=\"JmodeAbout\" _label=\"About ...\"\n"
        "             pixtype=\"stock\" pixname=\"gnome-stock-about\"/>\n"
        "</popup>\n";


GtkItemFactoryEntry mode_menu_items[]={
  {("/a"), NULL, G_CALLBACK(activate_event), 0, "" },
  {  hira2 , NULL, G_CALLBACK(activate_event), 1, "" },
  };

/* Opens gnome help application
 */
static void 
display_help_dialog (BonoboUIComponent *uic, gpointer data, const gchar *verbname)
{
  GError *error = NULL;
  
  gnome_help_display("Jmode", NULL, &error);

  if (error)
    {
      GtkWidget *dialog;
      dialog = gtk_message_dialog_new(NULL, 
				      GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
				      GTK_MESSAGE_ERROR, GTK_BUTTONS_OK,
				      error->message);
      gtk_dialog_run (GTK_DIALOG (dialog));
      gtk_widget_destroy (dialog);
      g_error_free (error);
      error = NULL;
    }
}

/* Just the about window... If it's already open, just focus it
 */
static void
display_about_dialog(BonoboUIComponent *uic, gpointer data, const gchar *verbname)
{
	GdkPixbuf *icon;
	GtkWidget *dialog;
	const char *authors[] = {"Yusuke TABATA <yusuke@cherubim.icw.co.jp> \nTOKUNAGA Hiroyuki <tkng@xem.jp>",NULL};
		
	/* Feel free to put your names here translators :-) */
	char *translators = _("TRANSLATORS");

	//	icon = gdk_pixbuf_new_from_xpm_data(ICON_APPLET);
	
	dialog = GTK_DIALOG(gnome_about_new (_("Jmode Applet"), VERSION, "Copyright 2003 TOKUNAGA Hiroyuki",
					     _("Applet for indicate jmode's status"),
					     (const char **) authors, NULL, 
					     strcmp("TRANSLATORS", translators) ? translators : NULL, 
					     NULL));
	
	gtk_widget_show(GTK_WIDGET(dialog));
}

static void
activate_event(GtkWidget *g, gpointer p)
{
  comm_set_mode((int)p);

      if( (int)p == 0 ) {
	gtk_button_set_label(mode_button,"a");
      }
      else if( (int)p == 1 ) {
	gtk_button_set_label(mode_button, hira);
      }
}


static gint toolbar_expose(GtkWidget *w, GdkEventExpose *e)
{
  if (jmode_stat) {
    gtk_image_set_from_pixbuf(state_img, on_pxbuf);
  } else {
    gtk_image_set_from_pixbuf(state_img, off_pxbuf);
  }
  return FALSE;
}

static void handler(struct comm_event *ev)
{

  if (ev->type == COMM_EVENT_MODE) {

    gtk_option_menu_set_history(GTK_OPTION_MENU(opt_menu), ev->nr);

      if( ev->nr == 0 ) {
	gtk_button_set_label(mode_button,"a");
      }
      else if( ev->nr == 1 ) {
	gtk_button_set_label(mode_button,hira);
      }

  }
  if (ev->type == COMM_EVENT_STAT) {
    jmode_stat = ev->nr;
    toolbar_expose(draw_win, NULL);
  }
}

static void fd_handler(gpointer p, gint fd,
		       GdkInputCondition c)
{
  proc_comm(handler);
}


gchar *translate(const gchar *path, gpointer data)
{
	gchar *retval;
	retval = gettext(path);
	return retval;
}


static GtkWidget * init_toolbar(void)
{
  GtkWidget *hbox;

  hbox = gtk_hbox_new(FALSE, 0);

  mode_item_fact = gtk_item_factory_new(GTK_TYPE_MENU, "<main>", NULL);

  gtk_item_factory_set_translate_func(mode_item_fact, translate,
				      NULL, NULL);
  
  gtk_item_factory_create_items (mode_item_fact, G_N_ELEMENTS (mode_menu_items),
				 mode_menu_items, NULL); 

  mode_button = gtk_button_new_with_label ("a");
  gtk_button_set_relief(GTK_BUTTON(mode_button), GTK_RELIEF_NONE);
  gtk_box_pack_start(GTK_BOX(hbox), mode_button, FALSE, FALSE, 0);

  g_signal_connect(G_OBJECT(mode_button), "button_press_event",
		   G_CALLBACK(mode_button_pressed), mode_button);

  on_pxbuf = gdk_pixbuf_new_from_xpm_data(on_xpm);
  off_pxbuf = gdk_pixbuf_new_from_xpm_data(off_xpm);

  state_img = gtk_image_new_from_pixbuf(off_pxbuf);

  gtk_box_pack_start(GTK_BOX(hbox), state_img, TRUE, TRUE, 2);

  return hbox;
  
}

static void
mode_button_pressed(GtkButton *mode_button,
		    gpointer *user_data)
{
  int x,y;

  menu_button_position(NULL,&x,&y,NULL,mode_button);
  gtk_item_factory_popup(mode_item_fact, x, y, NULL, NULL);

}

static void
menu_button_position(GtkMenu *menu, gint *x, gint *y, gboolean *push_in,
			  gpointer *user_data)
{
        GtkWidget *widget;
        gint wheight;
        gint wx, wy;

	g_return_if_fail(x && y);
 	g_return_if_fail(GTK_IS_BUTTON(user_data));

	widget = GTK_WIDGET(user_data);

	gdk_window_get_origin(widget->window, x, y);

        wheight = widget->requisition.height;
	wx = widget->allocation.x;
        wy = widget->allocation.y;
         
        *y = *y + wy + wheight;
        *x = *x + wx;
}

static gboolean
jmode_applet_new(PanelApplet *applet,
		 const gchar *iid,
		 gpointer     data)
{
  GtkWidget *toolbar;
 
  if (strcmp (iid, "OAFIID:GNOME_JmodeApplet") != 0)
    return FALSE;
  
  event_fd = init_comm();
  jmode_stat = 0;

  toolbar = init_toolbar();
      
 
  gdk_input_add(event_fd, (GdkInputCondition)GDK_INPUT_READ,
		fd_handler, 0);
  

  gtk_container_add (GTK_CONTAINER (applet), toolbar);  
  gtk_widget_show_all (GTK_WIDGET (applet));

  panel_applet_setup_menu(applet,
			  jmode_menu_xml,
			  jmode_menu_verbs,
			  toolbar);

  return TRUE;
}



PANEL_APPLET_BONOBO_FACTORY ("OAFIID:GNOME_JmodeApplet_Factory",
                             PANEL_TYPE_APPLET,
                             "jmode gnome2 Applet",
                             "0",
                             (PanelAppletFactoryCallback)jmode_applet_new,
                             NULL);
