#include <qapplication.h>
#include <qsocketnotifier.h>
#include "qt-main.h"
#include "qt-main-moc.h"
#include "comm.h"

ToolBar *ToolBar::mToolBar;

int main(int argc , char **argv)
{
  QApplication a(argc, argv);
  int fd = init_comm();
  QSocketNotifier qsn((int)fd, QSocketNotifier::Read);

  ToolBar t;
  t.show();

  QObject::connect(&qsn, SIGNAL(activated(int)), &t, SLOT(proc()));

  a.exec();
  return 0;
}

ToolBar::ToolBar(QWidget *parent, const char *name)
  : QWidget(parent, name)
{
  mToolBar = this;
  resize(100, 100);
}

void ToolBar::handler(struct comm_event *ev)
{
  switch (ev->type) {
  case COMM_EVENT_STAT:
    printf("stat changed ->%d\n", ev->nr);
    break;
  case COMM_EVENT_MODE:
    printf("mode changed ->%d\n", ev->nr);
    break;
  }
}

void ToolBar::static_handler(struct comm_event *ev)
{
  mToolBar->handler(ev);
}

void ToolBar::proc()
{
  proc_comm(static_handler);
}
