#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include "xim.h"
#include <X11/Xatom.h>

static Atom jmode_input_mode;
static Atom jmode_input_stat;

class KKConv;

void init_status_indicator()
{
}

void init_ui()
{
    jmode_input_mode = XInternAtom(gDpy, "JMODE_INPUT_MODE", 0);
    jmode_input_stat = XInternAtom(gDpy, "JMODE_INPUT_STAT", 0);
}

void ui_update_ic_stat()
{
    int s;
    if (XimIC::isAnyActive()) {
	s = 1;
    } else {
	s = 0;
    }
    XChangeProperty(gDpy, DefaultRootWindow(gDpy), jmode_input_stat,
		    XA_INTEGER,
		    32, PropModeReplace, (unsigned char *)&s, 1);
}

void ui_update_input_mode(int s)
{
    XChangeProperty(gDpy, DefaultRootWindow(gDpy), jmode_input_mode,
		    XA_INTEGER,
		    32, PropModeReplace, (unsigned char *)&s, 1);
}

/*
 * Local variables:
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 */
