/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.pdf_brewer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.osdn.pdf_brewer.BrewerData;
import net.osdn.pdf_brewer.Context;
import net.osdn.pdf_brewer.FontLoader;
import net.osdn.pdf_brewer.TextBuffer;
import net.osdn.pdf_brewer.instruction.Instruction;
import net.osdn.pdf_brewer.instruction.text.TextBufferingInstruction;
import org.apache.fontbox.ttf.TrueTypeCollection;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDTrueTypeFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;

public class PdfBrewer {
    private static PDFont FONT_NULL;
    private String producer;
    private String creator;
    private PDRectangle mediaBox;
    private PDDocument document;
    private PDPage page;
    private PDPageContentStream stream;
    private Map<String, PDFont> fonts = new HashMap<String, PDFont>();
    private Set<TrueTypeCollection> ttcLoaded = new HashSet<TrueTypeCollection>();

    public static String getDefaultProducer() {
        String version;
        Package pkg = PDDocument.class.getPackage();
        String title = pkg.getSpecificationTitle();
        if (title == null || title.trim().length() == 0) {
            title = "Apache PDFBox";
        }
        if ((version = pkg.getSpecificationVersion()) == null) {
            version = "";
        }
        return title + " " + version;
    }

    public static String getDefaultCreator() {
        String version;
        Package pkg = PdfBrewer.class.getPackage();
        String title = pkg.getSpecificationTitle();
        if (title == null || title.trim().length() == 0) {
            title = "PDF Brewer";
        }
        if ((version = pkg.getSpecificationVersion()) == null) {
            version = "";
        }
        return title + " " + version;
    }

    public PdfBrewer() {
        this.document = new PDDocument();
        PDDocumentInformation info = this.document.getDocumentInformation();
        this.producer = PdfBrewer.getDefaultProducer();
        info.setProducer(this.producer);
        this.creator = PdfBrewer.getDefaultCreator();
        info.setCreator(this.creator);
    }

    public String getProducer() {
        return this.producer;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setTitle(String title) {
        PDDocumentInformation info = this.document.getDocumentInformation();
        info.setTitle(title);
    }

    public void setAuthor(String author) {
        PDDocumentInformation info = this.document.getDocumentInformation();
        info.setAuthor(author);
    }

    public PDDocument getDocument() {
        return this.document;
    }

    public PDPage getPage() {
        return this.page;
    }

    public PDPageContentStream getContentStream() {
        return this.stream;
    }

    public void newPage() throws IOException {
        if (this.stream != null) {
            this.stream.close();
        }
        this.page = new PDPage(this.mediaBox);
        this.document.addPage(this.page);
        this.stream = new PDPageContentStream(this.document, this.page);
    }

    public PDFont loadFont(String fontName) throws IOException {
        PDFont font = null;
        TrueTypeFont ttf = FontLoader.get(fontName);
        if (ttf != null) {
            font = this.fonts.get(ttf.getName());
            if (font == null) {
                File file = FontLoader.getFile(ttf);
                if (file != null) {
                    TrueTypeCollection ttc = new TrueTypeCollection(file);
                    font = PDType0Font.load((PDDocument)this.document, (TrueTypeFont)ttc.getFontByName(ttf.getName()), (boolean)true);
                    this.ttcLoaded.add(ttc);
                } else {
                    font = PDType0Font.load((PDDocument)this.document, (TrueTypeFont)ttf, (boolean)true);
                }
                this.fonts.put(ttf.getName(), font);
            }
        } else {
            font = FONT_NULL;
        }
        if (font == FONT_NULL) {
            return null;
        }
        return font;
    }

    public void process(BrewerData pb) throws IOException {
        ArrayDeque<Context> stack = new ArrayDeque<Context>();
        this.mediaBox = pb.getMediaBox();
        if (this.mediaBox == null) {
            this.mediaBox = PDRectangle.A4;
        }
        Context context = new Context(new Context(this.mediaBox), 0);
        TextBuffer textBuffer = new TextBuffer();
        if (pb.getTitle() != null) {
            this.setTitle(pb.getTitle());
        }
        if (pb.getAuthor() != null) {
            this.setAuthor(pb.getAuthor());
        }
        this.newPage();
        List<Instruction> instructions = pb.getInstructions();
        for (Instruction instruction : instructions) {
            while (instruction.getIndent() < context.getIndent()) {
                if (!textBuffer.isEmpty()) {
                    textBuffer.process(this, context);
                    textBuffer.clear();
                }
                context = (Context)stack.pop();
            }
            if (instruction.getIndent() > context.getIndent()) {
                if (!textBuffer.isEmpty()) {
                    textBuffer.process(this, context);
                    textBuffer.clear();
                }
                stack.push(context);
                context = new Context(context, instruction.getIndent());
            }
            if (instruction instanceof TextBufferingInstruction) {
                textBuffer.add((TextBufferingInstruction)instruction);
                continue;
            }
            if (!textBuffer.isEmpty()) {
                textBuffer.process(this, context);
                textBuffer.clear();
            }
            instruction.process(this, context);
        }
        if (!textBuffer.isEmpty()) {
            textBuffer.process(this, context);
            textBuffer.clear();
        }
    }

    public void save(String pathname) throws IOException {
        this.save(new FileOutputStream(pathname));
    }

    public void save(File file) throws IOException {
        this.save(new FileOutputStream(file));
    }

    public void save(OutputStream output) throws IOException {
        if (this.stream != null) {
            this.stream.close();
            this.stream = null;
        }
        PDDocumentInformation info = this.document.getDocumentInformation();
        Calendar date = Calendar.getInstance();
        info.setCreationDate(date);
        info.setModificationDate(date);
        this.document.save(output);
        this.document.close();
        for (TrueTypeCollection ttc : this.ttcLoaded) {
            ttc.close();
        }
    }

    static {
        try {
            FONT_NULL = new PDTrueTypeFont(new COSDictionary());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

