/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.pdf_brewer.ui;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import javafx.application.Platform;
import javafx.beans.property.FloatProperty;
import javafx.beans.property.SimpleFloatProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.embed.swing.SwingFXUtils;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import net.osdn.pdf_brewer.ui.SpinnerImageView;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.rendering.PDFRenderer;

public class PdfPane
extends Pane {
    private ImageView imageView;
    private SpinnerImageView spinner;
    private Color backgroundColor;
    private PDDocument document;
    private int pageIndex = -1;
    private FloatProperty scaleProperty = new SimpleFloatProperty(0.0f);
    private Bounds pageBounds = new BoundingBox(0.0, 0.0, 0.0, 0.0);
    private WritableImage wimg;
    private ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        }
    });
    private FutureTask<BufferedImage> renderTask;

    public PdfPane() {
        this.setBackgroundColor(Color.GRAY);
        this.imageView = new ImageView();
        this.spinner = new SpinnerImageView();
        this.spinner.setVisible(false);
        this.getChildren().addAll((Object[])new Node[]{this.imageView, this.spinner});
        ChangeListener<Number> resizeListener = new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                try {
                    PdfPane.this.spinner.setLayoutX((PdfPane.this.getWidth() - PdfPane.this.spinner.getWidth()) / 2.0);
                    PdfPane.this.spinner.setLayoutY((PdfPane.this.getHeight() - PdfPane.this.spinner.getHeight()) / 2.0);
                    PdfPane.this.render(PdfPane.this.document, PdfPane.this.pageIndex);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        this.widthProperty().addListener((ChangeListener)resizeListener);
        this.heightProperty().addListener((ChangeListener)resizeListener);
    }

    protected SpinnerImageView getSpinnerImageView() {
        return this.spinner;
    }

    public FloatProperty scaleProperty() {
        return this.scaleProperty;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
        this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)this.backgroundColor, null, null)}));
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setDocument(PDDocument document) {
        this.pageIndex = 0;
        this.document = document;
    }

    public PDDocument getDocument() {
        return this.document;
    }

    public void setPage(int pageIndex) throws IOException {
        if (this.document != null) {
            if (pageIndex < 0) {
                pageIndex = 0;
            }
            if (pageIndex >= this.document.getNumberOfPages()) {
                pageIndex = this.document.getNumberOfPages() - 1;
            }
            this.pageIndex = pageIndex;
        }
        this.render(this.document, pageIndex);
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public Bounds getPageBounds() {
        return this.pageBounds;
    }

    private void render(PDDocument document, int pageIndex) throws IOException {
        int imgHeight;
        int imgWidth;
        if (document == null) {
            return;
        }
        PDPage page = document.getPage(pageIndex);
        PDRectangle mediaBox = page.getMediaBox();
        float pageWidth = mediaBox.getWidth();
        float pageHeight = mediaBox.getHeight();
        double width = this.getWidth();
        double height = this.getHeight();
        double preferredWidth = height * (double)pageWidth / (double)pageHeight;
        double preferredHeight = width * (double)pageHeight / (double)pageWidth;
        if (preferredWidth <= width) {
            imgWidth = (int)preferredWidth;
            imgHeight = (int)height;
        } else {
            imgWidth = (int)width;
            imgHeight = (int)preferredHeight;
        }
        int x = (int)((width - (double)imgWidth) / 2.0);
        int y = (int)((height - (double)imgHeight) / 2.0);
        this.imageView.setLayoutX((double)x);
        this.imageView.setLayoutY((double)y);
        this.pageBounds = new BoundingBox((double)x, (double)y, (double)imgWidth, (double)imgHeight);
        float scale = (float)imgHeight / pageHeight;
        this.scaleProperty.set(scale);
        if (scale > 0.0f && imgWidth > 0 && imgHeight > 0) {
            if (this.renderTask != null && !this.renderTask.isDone()) {
                this.renderTask.cancel(true);
            }
            this.renderTask = new RenderTask(new RenderCallable(document, pageIndex, scale, imgWidth, imgHeight));
            this.executor.execute(this.renderTask);
        }
    }

    private class RenderCallable
    implements Callable<BufferedImage> {
        private PDDocument document;
        private int pageIndex;
        private float scale;
        private int imgWidth;
        private int imgHeight;
        private BufferedImage bimg;
        private boolean isCancelled;
        private volatile boolean isDone;

        public RenderCallable(PDDocument document, int pageIndex, float scale, int imgWidth, int imgHeight) {
            this.document = document;
            this.pageIndex = pageIndex;
            this.scale = scale;
            this.imgWidth = imgWidth;
            this.imgHeight = imgHeight;
        }

        @Override
        public BufferedImage call() throws Exception {
            this.bimg = new BufferedImage(this.imgWidth, this.imgHeight, 1);
            Graphics2D graphics = (Graphics2D)this.bimg.getGraphics();
            graphics.setColor(java.awt.Color.WHITE);
            graphics.fillRect(0, 0, this.imgWidth, this.imgHeight);
            graphics.setBackground(java.awt.Color.WHITE);
            if (this.isCancelled) {
                return null;
            }
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    if (!RenderCallable.this.isCancelled && !RenderCallable.this.isDone) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                PdfPane.this.spinner.setVisible(true);
                                PdfPane.this.wimg = SwingFXUtils.toFXImage((BufferedImage)RenderCallable.this.bimg, (WritableImage)PdfPane.this.wimg);
                                PdfPane.this.imageView.setImage((Image)PdfPane.this.wimg);
                            }
                        });
                    }
                }
            }, 200L);
            PDFRenderer renderer = new PDFRenderer(this.document);
            renderer.renderPageToGraphics(this.pageIndex, graphics, this.scale);
            this.isDone = true;
            if (this.isCancelled) {
                return null;
            }
            return this.bimg;
        }
    }

    private class RenderTask
    extends FutureTask<BufferedImage> {
        private RenderCallable callable;

        public RenderTask(RenderCallable callable) {
            super(callable);
            this.callable = callable;
        }

        @Override
        protected void done() {
            if (!this.isCancelled()) {
                try {
                    final BufferedImage bimg = (BufferedImage)this.get();
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            PdfPane.this.wimg = SwingFXUtils.toFXImage((BufferedImage)bimg, (WritableImage)PdfPane.this.wimg);
                            PdfPane.this.imageView.setImage((Image)PdfPane.this.wimg);
                            PdfPane.this.spinner.setVisible(false);
                        }
                    });
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.callable.isCancelled = true;
            return super.cancel(mayInterruptIfRunning);
        }
    }
}

