/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.pdf_brewer;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.fontbox.ttf.NameRecord;
import org.apache.fontbox.ttf.NamingTable;
import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeCollection;
import org.apache.fontbox.ttf.TrueTypeFont;

public class FontLoader {
    public static final List<String> FILENAMES_YUGOTHIC = Arrays.asList("yugothib.ttf", "yugothic-bold.ttf", "yugothic.ttf", "yugothil.ttf", "yugothb.ttc", "yugothl.ttc", "yugothm.ttc", "yugothr.ttc");
    public static final List<String> FILENAMES_YUMINCHO = Arrays.asList("yumin.ttf", "yumindb.ttf", "yuminl.ttf");
    public static final List<String> FILENAMES_NOTO_GOTHIC = Arrays.asList("KenEiGothicN-Ligh.ttf", "KenEiGothicN-SemiLight.ttf", "KenEiGothicN-Regular.ttf", "GenShinGothic-Regular.ttf", "GenShinGothic-Bold.ttf");
    public static final List<String> FILENAMES_NOTO_MINCHO = Arrays.asList("GenEiKoburiMin6-R.ttf", "GenYoMinJP-Regular.ttf", "GenYoMinJP-SemiBold.ttf", "GenYoMinJP-Bold.ttf");
    public static final List<String> FILENAMES_IPA_GOTHIC = Arrays.asList("ipaexg.ttf");
    public static final List<String> FILENAMES_IPA_MINCHO = Arrays.asList("ipaexm.ttf");
    private Map<String, TrueTypeFont> fonts = new HashMap<String, TrueTypeFont>();
    private Map<TrueTypeFont, File> ttcFiles = new HashMap<TrueTypeFont, File>();

    public static File getDefaultFontDir() {
        String windir = System.getenv("windir");
        if (windir != null) {
            return new File(windir, "Fonts");
        }
        return null;
    }

    public FontLoader(File fontDir) {
        this(fontDir, null, null);
    }

    public FontLoader(File fontDir, Collection<String> fileNames, Collection<String> fontNames) {
        this.load(fontDir, fileNames, fontNames);
        TrueTypeFont serif = this.getFont("YuMincho-Regular");
        TrueTypeFont serifBold = this.getFont("YuMincho-Demibold");
        TrueTypeFont sansSerif = this.getFont("YuGothic-Regular");
        TrueTypeFont sansSerifBold = this.getFont("YuGothic-Bold");
        if (serif == null) {
            serif = this.getFont("geneikoburimin6-r");
        }
        if (serif == null) {
            serif = this.getFont("r-\u6e90\u69d8\u660e\u671d");
        }
        if (serifBold == null) {
            serifBold = this.getFont("b-\u6e90\u69d8\u660e\u671d");
        }
        if (serif == null) {
            serif = this.getFont("genyominjp-regular");
        }
        if (serifBold == null) {
            serifBold = this.getFont("bold-genyominjp");
        }
        if (serifBold == null) {
            serifBold = this.getFont("genyominjp-sb");
        }
        if (serifBold == null) {
            serifBold = this.getFont("genyominjp-semibold");
        }
        if (sansSerif == null) {
            sansSerif = this.getFont("keneigothicn-light");
        }
        if (sansSerif == null) {
            sansSerif = this.getFont("keneigothicn-semilight");
        }
        if (sansSerif == null) {
            sansSerif = this.getFont("keneigothicn-regular");
        }
        if (sansSerif == null) {
            sansSerif = this.getFont("genshingothic-regular");
        }
        if (sansSerifBold == null) {
            sansSerifBold = this.getFont("bold-genshingothic");
        }
        if (serif == null) {
            serif = this.getFont("ipaexmincho");
        }
        if (serifBold == null) {
            serifBold = this.getFont("ipaexmincho");
        }
        if (sansSerif == null) {
            sansSerif = this.getFont("ipaexgothic");
        }
        if (sansSerifBold == null) {
            sansSerifBold = this.getFont("ipaexgothic");
        }
        if (serif != null) {
            try {
                this.register("serif", serif);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (serifBold != null) {
            try {
                this.register("serif-Bold", serifBold);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (sansSerif != null) {
            try {
                this.register("sansSerif", sansSerif);
                this.register("sans-Serif", sansSerif);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (sansSerifBold != null) {
            try {
                this.register("sansSerif-Bold", sansSerifBold);
                this.register("sans-Serif-Bold", sansSerifBold);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public List<TrueTypeFont> listFonts() {
        ArrayList<TrueTypeFont> list = new ArrayList<TrueTypeFont>(this.fonts.values());
        Collections.sort(list, new Comparator<TrueTypeFont>(){

            @Override
            public int compare(TrueTypeFont o1, TrueTypeFont o2) {
                try {
                    return o1.getName().compareTo(o2.getName());
                }
                catch (IOException e) {
                    return 0;
                }
            }
        });
        return list;
    }

    public TrueTypeFont getFont(String name) {
        if (name == null || name.isBlank()) {
            return null;
        }
        TrueTypeFont ttf = this.fonts.get(this.normalize(name));
        if (ttf != null) {
            return ttf;
        }
        ttf = this.fonts.get(this.normalize(name + "-Regular"));
        if (ttf != null) {
            return ttf;
        }
        ttf = this.fonts.get(this.normalize(name + "-\u6a19\u6e96"));
        if (ttf != null) {
            return ttf;
        }
        return null;
    }

    public File getTtcFile(TrueTypeFont ttf) throws IOException {
        return this.ttcFiles.get(ttf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File dir, Collection<String> fileNames, Collection<String> fontNames) {
        File[] ttcFiles;
        File[] ttfFiles;
        if (dir == null) {
            return;
        }
        HashSet<String> fileNameSet = null;
        if (fileNames != null) {
            fileNameSet = new HashSet<String>();
            for (String string : fileNames) {
                fileNameSet.add(string.toLowerCase());
            }
        }
        HashSet<String> fontNameSet = null;
        if (fontNames != null) {
            fontNameSet = new HashSet<String>();
            for (String fontName : fontNames) {
                fontNameSet.add(this.normalize(fontName));
            }
        }
        TTFParser tTFParser = new TTFParser();
        for (File file : ttfFiles = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".ttf");
            }
        })) {
            if (fileNameSet != null && !fileNameSet.contains(file.getName().toLowerCase())) continue;
            TrueTypeFont ttf = null;
            try {
                ttf = tTFParser.parse(file);
                if (fontNameSet == null) {
                    this.register(ttf);
                    ttf = null;
                    continue;
                }
                List<String> normalizedNames = this.getNormalizedNames(ttf);
                if (Collections.disjoint(fontNameSet, normalizedNames)) continue;
                for (String s : normalizedNames) {
                    this.register(s, ttf);
                    ttf = null;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (ttf != null) {
                    try {
                        ttf.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        for (final File file : ttcFiles = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".ttc");
            }
        })) {
            if (fileNameSet != null && !fileNameSet.contains(file.getName().toLowerCase())) continue;
            TrueTypeCollection ttc = null;
            try {
                final HashSet<String> _fontNameSet = fontNameSet;
                ttc = new TrueTypeCollection(file);
                ttc.processAllFonts(new TrueTypeCollection.TrueTypeFontProcessor(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void process(TrueTypeFont ttf) throws IOException {
                        try {
                            if (_fontNameSet == null) {
                                FontLoader.this.register(ttf);
                                FontLoader.this.ttcFiles.put(ttf, file);
                                ttf = null;
                            } else {
                                List<String> normalizedNames = FontLoader.this.getNormalizedNames(ttf);
                                if (!Collections.disjoint(_fontNameSet, normalizedNames)) {
                                    for (String s : normalizedNames) {
                                        FontLoader.this.register(s, ttf);
                                    }
                                    FontLoader.this.ttcFiles.put(ttf, file);
                                    ttf = null;
                                }
                            }
                        }
                        finally {
                            if (ttf != null) {
                                try {
                                    ttf.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (ttc != null) {
                    try {
                        ttc.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public void register(TrueTypeFont ttf) throws IOException {
        this.register(null, ttf);
    }

    public void register(String name, TrueTypeFont ttf) throws IOException {
        if (name != null) {
            this.fonts.put(this.normalize(name), ttf);
            return;
        }
        for (String nomalizedName : this.getNormalizedNames(ttf)) {
            this.fonts.put(nomalizedName, ttf);
        }
    }

    public List<String> getNormalizedNames(TrueTypeFont ttf) throws IOException {
        String postScriptName;
        ArrayList<String> names = new ArrayList<String>();
        String fontName = ttf.getName();
        if (fontName != null && !fontName.isBlank()) {
            names.add(this.normalize(fontName));
        }
        NamingTable table = ttf.getNaming();
        String fontFamily = table.getFontFamily();
        String fontSubFamily = table.getFontSubFamily();
        if (fontFamily != null && !fontFamily.isBlank() && fontSubFamily != null && !fontSubFamily.isBlank()) {
            names.add(this.normalize(fontFamily + "-" + fontSubFamily));
        }
        if ((postScriptName = table.getPostScriptName()) != null && !postScriptName.isBlank()) {
            names.add(this.normalize(postScriptName));
        }
        HashSet<Integer> languages = new HashSet<Integer>();
        HashMap<Integer, String> fontFamilies1 = new HashMap<Integer, String>();
        HashMap<Integer, String> fontSubFamilies2 = new HashMap<Integer, String>();
        HashMap<Integer, String> fontFamilies16 = new HashMap<Integer, String>();
        HashMap<Integer, String> fontSubFamilies17 = new HashMap<Integer, String>();
        List records = table.getNameRecords();
        for (NameRecord record : records) {
            if (record.getNameId() == 1) {
                languages.add(record.getLanguageId());
                fontFamilies1.put(record.getLanguageId(), record.getString());
                continue;
            }
            if (record.getNameId() == 2) {
                languages.add(record.getLanguageId());
                fontSubFamilies2.put(record.getLanguageId(), record.getString());
                continue;
            }
            if (record.getNameId() == 16) {
                languages.add(record.getLanguageId());
                fontFamilies16.put(record.getLanguageId(), record.getString());
                continue;
            }
            if (record.getNameId() != 17) continue;
            languages.add(record.getLanguageId());
            fontSubFamilies17.put(record.getLanguageId(), record.getString());
        }
        for (Integer languageId : languages) {
            fontFamily = (String)fontFamilies1.get(languageId);
            if (fontFamily != null && !fontFamily.isBlank()) {
                fontSubFamily = (String)fontSubFamilies2.get(languageId);
                if (fontSubFamily != null && !fontSubFamily.isBlank()) {
                    names.add(this.normalize(fontFamily + "-" + fontSubFamily));
                } else {
                    names.add(this.normalize(fontFamily));
                }
            }
            if ((fontFamily = (String)fontFamilies16.get(languageId)) == null || fontFamily.isBlank()) continue;
            fontSubFamily = (String)fontSubFamilies17.get(languageId);
            if (fontSubFamily != null && !fontSubFamily.isBlank()) {
                names.add(this.normalize(fontFamily + "-" + fontSubFamily));
                continue;
            }
            names.add(this.normalize(fontFamily));
        }
        return names;
    }

    private String normalize(String name) {
        String s = name.replace('\t', '-').replace('\u3000', '-').replace(' ', '-').toLowerCase();
        while (s.contains("--")) {
            s = s.replace("--", "-");
        }
        s = Normalizer.normalize(s, Normalizer.Form.NFKC);
        Object[] tokens = s.split("-");
        Arrays.sort(tokens);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tokens.length; ++i) {
            sb.append((String)tokens[i]);
            if (i + 1 >= tokens.length) continue;
            sb.append('-');
        }
        return sb.toString();
    }

    public void close() {
        this.ttcFiles.clear();
        for (TrueTypeFont ttf : this.fonts.values()) {
            try {
                ttf.close();
            }
            catch (IOException iOException) {}
        }
        this.fonts.clear();
    }
}

