/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.aoiro;

import java.io.PrintStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.osdn.aoiro.model.AccountTitle;
import net.osdn.aoiro.model.AccountType;
import net.osdn.aoiro.model.Creditor;
import net.osdn.aoiro.model.Debtor;
import net.osdn.aoiro.model.JournalEntry;
import net.osdn.aoiro.model.ProportionalDivision;
import net.osdn.aoiro.report.layout.BalanceSheetLayout;

public class AccountSettlement {
    private boolean isSoloProprietorship;
    private LocalDate date;
    private Set<AccountTitle> accountTitles;
    private PrintStream out;

    public AccountSettlement(Set<AccountTitle> accountTitles, boolean isSoloproprietorship) {
        this.accountTitles = accountTitles;
        this.isSoloProprietorship = isSoloproprietorship;
    }

    public void setPrintStream(PrintStream out) {
        this.out = out;
    }

    public void addClosingEntries(List<JournalEntry> journalEntries, BalanceSheetLayout bsLayout, List<ProportionalDivision> proportionalDivisions) {
        String description;
        Iterator debtor;
        JournalEntry entry;
        Object creditor;
        Object creditor2;
        Object debtor2;
        Debtor debtor3;
        Object debtor4;
        Object creditor3;
        if (this.date == null) {
            this.date = AccountSettlement.getClosingDate(journalEntries, this.isSoloProprietorship);
        }
        if (this.date == null) {
            throw new IllegalStateException("\u6c7a\u7b97\u65e5\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        ArrayList<AccountTitle> order = new ArrayList<AccountTitle>(this.accountTitles);
        if (proportionalDivisions != null) {
            Iterator<AccountTitle> withdrawalsByOwner = AccountTitle.getByDisplayName(this.accountTitles, "\u4e8b\u696d\u4e3b\u8cb8");
            AccountTitle investmentsByOwner = AccountTitle.getByDisplayName(this.accountTitles, "\u4e8b\u696d\u4e3b\u501f");
            if (withdrawalsByOwner != null && investmentsByOwner != null) {
                ArrayList<Debtor> debtors = new ArrayList<Debtor>();
                ArrayList<Creditor> creditors = new ArrayList<Creditor>();
                int year = 0;
                if (journalEntries.size() > 0) {
                    year = journalEntries.get(0).getDate().getYear();
                }
                if (year >= 2022) {
                    for (ProportionalDivision proportionalDivision : proportionalDivisions) {
                        BigDecimal businessRatio = BigDecimal.valueOf(proportionalDivision.getBusinessRatio()).setScale(2, RoundingMode.HALF_EVEN);
                        long debtorTotal = 0L;
                        long creditorTotal = 0L;
                        for (int i = 0; i < journalEntries.size(); ++i) {
                            long v;
                            BigDecimal amount;
                            JournalEntry entry2 = journalEntries.get(i);
                            for (Debtor debtor5 : entry2.getDebtors()) {
                                if (!debtor5.getAccountTitle().equals(proportionalDivision.getAccountTitle())) continue;
                                amount = BigDecimal.valueOf(debtor5.getAmount());
                                v = amount.multiply(businessRatio).setScale(0, RoundingMode.UP).longValueExact();
                                debtorTotal += debtor5.getAmount() - v;
                            }
                            for (Creditor creditor4 : entry2.getCreditors()) {
                                if (!creditor4.getAccountTitle().equals(proportionalDivision.getAccountTitle())) continue;
                                amount = BigDecimal.valueOf(creditor4.getAmount());
                                v = amount.multiply(businessRatio).setScale(0, RoundingMode.UP).longValueExact();
                                creditorTotal += creditor4.getAmount() - v;
                            }
                        }
                        if (debtorTotal > creditorTotal) {
                            long total = debtorTotal - creditorTotal;
                            creditors.add(new Creditor(proportionalDivision.getAccountTitle(), total));
                            continue;
                        }
                        if (creditorTotal <= debtorTotal) continue;
                        long total = creditorTotal - debtorTotal;
                        debtors.add(new Debtor(proportionalDivision.getAccountTitle(), total));
                    }
                } else {
                    for (ProportionalDivision proportionalDivision : proportionalDivisions) {
                        double total;
                        long longTotal;
                        long debtorTotal = 0L;
                        long creditorTotal = 0L;
                        for (int i = 0; i < journalEntries.size(); ++i) {
                            JournalEntry entry3 = journalEntries.get(i);
                            for (Debtor debtor6 : entry3.getDebtors()) {
                                if (!debtor6.getAccountTitle().equals(proportionalDivision.getAccountTitle())) continue;
                                debtorTotal += debtor6.getAmount();
                            }
                            for (Creditor creditor5 : entry3.getCreditors()) {
                                if (!creditor5.getAccountTitle().equals(proportionalDivision.getAccountTitle())) continue;
                                creditorTotal += creditor5.getAmount();
                            }
                        }
                        if (debtorTotal > creditorTotal) {
                            double total2 = (double)(debtorTotal - creditorTotal) * (1.0 - proportionalDivision.getBusinessRatio());
                            long longTotal2 = Math.round(total2);
                            if (longTotal2 == 0L) continue;
                            creditors.add(new Creditor(proportionalDivision.getAccountTitle(), longTotal2));
                            continue;
                        }
                        if (creditorTotal <= debtorTotal || (longTotal = Math.round(total = (double)(creditorTotal - debtorTotal) * (1.0 - proportionalDivision.getBusinessRatio()))) == 0L) continue;
                        debtors.add(new Debtor(proportionalDivision.getAccountTitle(), longTotal));
                    }
                }
                if (debtors.size() > 0) {
                    Collections.sort(debtors, Comparator.comparingInt(o -> order.indexOf(o.getAccountTitle())));
                    long creditorTotal = 0L;
                    for (Debtor debtor7 : debtors) {
                        creditorTotal += debtor7.getAmount();
                    }
                    creditor3 = new Creditor(investmentsByOwner, creditorTotal);
                    JournalEntry entry4 = new JournalEntry(this.date, "\u5bb6\u4e8b\u6309\u5206", debtors, Arrays.asList(creditor3));
                    journalEntries.add(entry4);
                }
                if (creditors.size() > 0) {
                    Collections.sort(creditors, Comparator.comparingInt(o -> order.indexOf(o.getAccountTitle())));
                    long debtorTotal = 0L;
                    for (Creditor creditor6 : creditors) {
                        debtorTotal += creditor6.getAmount();
                    }
                    debtor4 = new Debtor((AccountTitle)((Object)withdrawalsByOwner), debtorTotal);
                    JournalEntry entry5 = new JournalEntry(this.date, "\u5bb6\u4e8b\u6309\u5206", Arrays.asList(debtor4), creditors);
                    journalEntries.add(entry5);
                }
                if (this.out != null && (debtors.size() > 0 || creditors.size() > 0)) {
                    this.out.println("  \u5bb6\u4e8b\u6309\u5206\u306e\u632f\u66ff\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
                }
            }
        }
        for (AccountTitle accountTitle : bsLayout.getAccountTitlesByNode(bsLayout.getNode("\u4e8b\u696d\u4e3b\u8cb8"))) {
            AccountTitle investmentsByOwner;
            JournalEntry entry6;
            if (accountTitle.getDisplayName().equals("\u4e8b\u696d\u4e3b\u8cb8")) continue;
            long total = 0L;
            List<JournalEntry> entries = AccountSettlement.getJournalEntriesByAccount(journalEntries, accountTitle);
            for (JournalEntry entry7 : entries) {
                for (Debtor debtor8 : entry7.getDebtors()) {
                    if (!debtor8.getAccountTitle().equals(accountTitle)) continue;
                    total += debtor8.getAmount();
                }
                for (Creditor creditor7 : entry7.getCreditors()) {
                    if (!creditor7.getAccountTitle().equals(accountTitle)) continue;
                    total -= creditor7.getAmount();
                }
            }
            if (total == 0L) continue;
            if (total > 0L) {
                AccountTitle withdrawalsByOwner = AccountTitle.getByDisplayName(this.accountTitles, "\u4e8b\u696d\u4e3b\u8cb8");
                if (withdrawalsByOwner == null) continue;
                debtor3 = new Debtor(withdrawalsByOwner, total);
                creditor3 = new Creditor(accountTitle, total);
                entry6 = new JournalEntry(this.date, "\u4e8b\u696d\u4e3b\u8cb8\u3078\u306e\u632f\u66ff", Arrays.asList(debtor3), Arrays.asList(creditor3));
                journalEntries.add(entry6);
                continue;
            }
            if (total >= 0L || (investmentsByOwner = AccountTitle.getByDisplayName(this.accountTitles, "\u4e8b\u696d\u4e3b\u501f")) == null) continue;
            debtor3 = new Debtor(accountTitle, -total);
            creditor3 = new Creditor(investmentsByOwner, -total);
            entry6 = new JournalEntry(this.date, "\u4e8b\u696d\u4e3b\u501f\u3078\u306e\u632f\u66ff", Arrays.asList(debtor3), Arrays.asList(creditor3));
            journalEntries.add(entry6);
        }
        for (AccountTitle accountTitle : bsLayout.getAccountTitlesByNode(bsLayout.getNode("\u4e8b\u696d\u4e3b\u501f"))) {
            AccountTitle withdrawalsByOwner;
            JournalEntry entry8;
            if (accountTitle.getDisplayName().equals("\u4e8b\u696d\u4e3b\u501f")) continue;
            long total = 0L;
            List<JournalEntry> entries = AccountSettlement.getJournalEntriesByAccount(journalEntries, accountTitle);
            for (JournalEntry entry7 : entries) {
                for (Debtor debtor9 : entry7.getDebtors()) {
                    if (!debtor9.getAccountTitle().equals(accountTitle)) continue;
                    total -= debtor9.getAmount();
                }
                for (Creditor creditor8 : entry7.getCreditors()) {
                    if (!creditor8.getAccountTitle().equals(accountTitle)) continue;
                    total += creditor8.getAmount();
                }
            }
            if (total == 0L) continue;
            if (total > 0L) {
                AccountTitle investmentsByOwner = AccountTitle.getByDisplayName(this.accountTitles, "\u4e8b\u696d\u4e3b\u501f");
                if (investmentsByOwner == null) continue;
                debtor3 = new Debtor(accountTitle, total);
                creditor3 = new Creditor(investmentsByOwner, total);
                entry8 = new JournalEntry(this.date, "\u4e8b\u696d\u4e3b\u501f\u3078\u306e\u632f\u66ff", Arrays.asList(debtor3), Arrays.asList(creditor3));
                journalEntries.add(entry8);
                continue;
            }
            if (total >= 0L || (withdrawalsByOwner = AccountTitle.getByDisplayName(this.accountTitles, "\u4e8b\u696d\u4e3b\u8cb8")) == null) continue;
            debtor3 = new Debtor(withdrawalsByOwner, -total);
            creditor3 = new Creditor(accountTitle, -total);
            entry8 = new JournalEntry(this.date, "\u4e8b\u696d\u4e3b\u8cb8\u3078\u306e\u632f\u66ff", Arrays.asList(debtor3), Arrays.asList(creditor3));
            journalEntries.add(entry8);
        }
        LinkedHashSet<AccountTitle> revenueAccountTitles = new LinkedHashSet<AccountTitle>();
        LinkedHashSet<AccountTitle> expenseAccountTitles = new LinkedHashSet<AccountTitle>();
        LinkedHashSet<AccountTitle> assetsAccountTitles = new LinkedHashSet<AccountTitle>();
        LinkedHashSet<AccountTitle> liabilitiesAccountTitles = new LinkedHashSet<AccountTitle>();
        LinkedHashSet<AccountTitle> equityAccountTitles = new LinkedHashSet<AccountTitle>();
        for (JournalEntry entry7 : journalEntries) {
            for (Creditor creditor9 : entry7.getCreditors()) {
                if (creditor9.getAccountTitle().getType() == AccountType.Revenue) {
                    revenueAccountTitles.add(creditor9.getAccountTitle());
                }
                if (creditor9.getAccountTitle().getType() == AccountType.Expense) {
                    expenseAccountTitles.add(creditor9.getAccountTitle());
                }
                if (creditor9.getAccountTitle().getType() == AccountType.Assets) {
                    assetsAccountTitles.add(creditor9.getAccountTitle());
                }
                if (creditor9.getAccountTitle().getType() != AccountType.Liabilities) continue;
                liabilitiesAccountTitles.add(creditor9.getAccountTitle());
            }
            for (Debtor debtor10 : entry7.getDebtors()) {
                if (debtor10.getAccountTitle().getType() == AccountType.Revenue) {
                    revenueAccountTitles.add(debtor10.getAccountTitle());
                }
                if (debtor10.getAccountTitle().getType() == AccountType.Expense) {
                    expenseAccountTitles.add(debtor10.getAccountTitle());
                }
                if (debtor10.getAccountTitle().getType() == AccountType.Assets) {
                    assetsAccountTitles.add(debtor10.getAccountTitle());
                }
                if (debtor10.getAccountTitle().getType() != AccountType.Liabilities) continue;
                liabilitiesAccountTitles.add(debtor10.getAccountTitle());
            }
        }
        long incomeSummary = 0L;
        ArrayList<Debtor> debtors = new ArrayList<Debtor>();
        long debtorsTotal = 0L;
        ArrayList<Creditor> creditors = new ArrayList<Creditor>();
        long creditorsTotal = 0L;
        for (AccountTitle accountTitle : revenueAccountTitles) {
            long total = 0L;
            List<JournalEntry> entries = AccountSettlement.getJournalEntriesByAccount(journalEntries, accountTitle);
            for (JournalEntry entry9 : entries) {
                for (Creditor creditor10 : entry9.getCreditors()) {
                    if (!creditor10.getAccountTitle().equals(accountTitle)) continue;
                    total += creditor10.getAmount();
                }
                for (Debtor debtor11 : entry9.getDebtors()) {
                    if (!debtor11.getAccountTitle().equals(accountTitle)) continue;
                    total -= debtor11.getAmount();
                }
            }
            if (total >= 0L) {
                debtor2 = new Debtor(accountTitle, total);
                debtors.add((Debtor)debtor2);
                debtorsTotal += total;
            } else {
                creditor2 = new Creditor(accountTitle, -total);
                creditors.add((Creditor)creditor2);
                creditorsTotal += -total;
            }
            incomeSummary += total;
        }
        if (debtors.size() > 0) {
            Collections.sort(debtors, Comparator.comparingInt(o -> order.indexOf(o.getAccountTitle())));
            creditor = new Creditor(AccountTitle.INCOME_SUMMARY, debtorsTotal);
            entry = new JournalEntry(this.date, "\u53ce\u76ca\u306e\u640d\u76ca\u632f\u66ff", debtors, Arrays.asList(creditor));
            journalEntries.add(entry);
        }
        if (creditors.size() > 0) {
            Collections.sort(creditors, Comparator.comparingInt(o -> order.indexOf(o.getAccountTitle())));
            debtor = new Debtor(AccountTitle.INCOME_SUMMARY, creditorsTotal);
            entry = new JournalEntry(this.date, "\u53ce\u76ca\u306e\u640d\u76ca\u632f\u66ff", Arrays.asList(debtor), creditors);
            journalEntries.add(entry);
        }
        if (this.out != null) {
            this.out.println("  \u53ce\u76ca\u306e\u640d\u76ca\u632f\u66ff\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
        }
        debtors = new ArrayList();
        debtorsTotal = 0L;
        creditors = new ArrayList();
        creditorsTotal = 0L;
        for (AccountTitle accountTitle : expenseAccountTitles) {
            long total = 0L;
            List<JournalEntry> entries = AccountSettlement.getJournalEntriesByAccount(journalEntries, accountTitle);
            for (JournalEntry entry9 : entries) {
                for (Debtor debtor11 : entry9.getDebtors()) {
                    if (!debtor11.getAccountTitle().equals(accountTitle)) continue;
                    total += debtor11.getAmount();
                }
                for (Creditor creditor10 : entry9.getCreditors()) {
                    if (!creditor10.getAccountTitle().equals(accountTitle)) continue;
                    total -= creditor10.getAmount();
                }
            }
            if (total >= 0L) {
                creditor2 = new Creditor(accountTitle, total);
                creditors.add((Creditor)creditor2);
                creditorsTotal += total;
            } else {
                debtor2 = new Debtor(accountTitle, -total);
                debtors.add((Debtor)debtor2);
                debtorsTotal += -total;
            }
            incomeSummary -= total;
        }
        if (creditors.size() > 0) {
            Collections.sort(creditors, Comparator.comparingInt(o -> order.indexOf(o.getAccountTitle())));
            debtor = new Debtor(AccountTitle.INCOME_SUMMARY, creditorsTotal);
            entry = new JournalEntry(this.date, "\u8cbb\u7528\u306e\u640d\u76ca\u632f\u66ff", Arrays.asList(debtor), creditors);
            journalEntries.add(entry);
        }
        if (debtors.size() > 0) {
            Collections.sort(debtors, Comparator.comparingInt(o -> order.indexOf(o.getAccountTitle())));
            creditor = new Creditor(AccountTitle.INCOME_SUMMARY, debtorsTotal);
            entry = new JournalEntry(this.date, "\u8cbb\u7528\u306e\u640d\u76ca\u632f\u66ff", debtors, Arrays.asList(creditor));
            journalEntries.add(entry);
        }
        if (this.out != null) {
            this.out.println("  \u8cbb\u7528\u306e\u640d\u76ca\u632f\u66ff\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
        }
        for (JournalEntry entry10 : journalEntries) {
            for (Creditor creditor11 : entry10.getCreditors()) {
                if (creditor11.getAccountTitle().getType() == AccountType.Assets) {
                    assetsAccountTitles.add(creditor11.getAccountTitle());
                }
                if (creditor11.getAccountTitle().getType() != AccountType.Liabilities) continue;
                liabilitiesAccountTitles.add(creditor11.getAccountTitle());
            }
            for (Debtor debtor12 : entry10.getDebtors()) {
                if (debtor12.getAccountTitle().getType() == AccountType.Assets) {
                    assetsAccountTitles.add(debtor12.getAccountTitle());
                }
                if (debtor12.getAccountTitle().getType() != AccountType.Liabilities) continue;
                liabilitiesAccountTitles.add(debtor12.getAccountTitle());
            }
        }
        if (incomeSummary >= 0L) {
            debtor4 = new Debtor(AccountTitle.INCOME_SUMMARY, incomeSummary);
            Creditor creditor12 = this.isSoloProprietorship ? new Creditor(AccountTitle.PRETAX_INCOME, incomeSummary) : new Creditor(AccountTitle.RETAINED_EARNINGS, incomeSummary);
            JournalEntry entry11 = new JournalEntry(this.date, "\u640d\u76ca\u306e\u8cc7\u672c\u632f\u66ff", Arrays.asList(debtor4), Arrays.asList(creditor12));
            journalEntries.add(entry11);
        } else if (incomeSummary < 0L) {
            debtor4 = this.isSoloProprietorship ? new Debtor(AccountTitle.PRETAX_INCOME, -incomeSummary) : new Debtor(AccountTitle.RETAINED_EARNINGS, -incomeSummary);
            Creditor creditor13 = new Creditor(AccountTitle.INCOME_SUMMARY, -incomeSummary);
            JournalEntry entry12 = new JournalEntry(this.date, "\u640d\u76ca\u306e\u8cc7\u672c\u632f\u66ff", Arrays.asList(debtor4), Arrays.asList(creditor13));
            journalEntries.add(entry12);
        }
        if (this.out != null) {
            this.out.println("  \u640d\u76ca\u306e\u8cc7\u672c\u632f\u66ff\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
        }
        debtors = new ArrayList<Debtor>();
        debtorsTotal = 0L;
        creditors = new ArrayList();
        creditorsTotal = 0L;
        for (AccountTitle accountTitle : assetsAccountTitles) {
            long total = 0L;
            List<JournalEntry> entries = AccountSettlement.getJournalEntriesByAccount(journalEntries, accountTitle);
            for (JournalEntry entry9 : entries) {
                for (Debtor debtor11 : entry9.getDebtors()) {
                    if (!debtor11.getAccountTitle().equals(accountTitle)) continue;
                    total += debtor11.getAmount();
                }
                for (Creditor creditor10 : entry9.getCreditors()) {
                    if (!creditor10.getAccountTitle().equals(accountTitle)) continue;
                    total -= creditor10.getAmount();
                }
            }
            if (total >= 0L) {
                creditor2 = new Creditor(accountTitle, total);
                creditors.add((Creditor)creditor2);
                creditorsTotal += total;
                continue;
            }
            if (total >= 0L) continue;
            debtor2 = new Debtor(accountTitle, -total);
            debtors.add((Debtor)debtor2);
            debtorsTotal += -total;
        }
        if (creditors.size() > 0) {
            Collections.sort(creditors, Comparator.comparingInt(o -> order.indexOf(o.getAccountTitle())));
            debtor = new Debtor(AccountTitle.BALANCE, creditorsTotal);
            entry = new JournalEntry(this.date, "\u8cc7\u7523\u306e\u6b8b\u9ad8\u632f\u66ff", Arrays.asList(debtor), creditors);
            journalEntries.add(entry);
        }
        if (debtors.size() > 0) {
            Collections.sort(debtors, Comparator.comparingInt(o -> order.indexOf(o.getAccountTitle())));
            creditor = new Creditor(AccountTitle.BALANCE, debtorsTotal);
            entry = new JournalEntry(this.date, "\u8cc7\u7523\u306e\u6b8b\u9ad8\u632f\u66ff", debtors, Arrays.asList(creditor));
            journalEntries.add(entry);
        }
        if (this.out != null) {
            this.out.println("  \u8cc7\u7523\u306e\u6b8b\u9ad8\u632f\u66ff\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
        }
        debtors = new ArrayList();
        debtorsTotal = 0L;
        creditors = new ArrayList();
        creditorsTotal = 0L;
        for (AccountTitle accountTitle : liabilitiesAccountTitles) {
            long total = 0L;
            List<JournalEntry> entries = AccountSettlement.getJournalEntriesByAccount(journalEntries, accountTitle);
            for (JournalEntry entry9 : entries) {
                for (Creditor creditor10 : entry9.getCreditors()) {
                    if (!creditor10.getAccountTitle().equals(accountTitle)) continue;
                    total += creditor10.getAmount();
                }
                for (Debtor debtor11 : entry9.getDebtors()) {
                    if (!debtor11.getAccountTitle().equals(accountTitle)) continue;
                    total -= debtor11.getAmount();
                }
            }
            if (total >= 0L) {
                debtor2 = new Debtor(accountTitle, total);
                debtors.add((Debtor)debtor2);
                debtorsTotal += total;
                continue;
            }
            if (total >= 0L) continue;
            creditor2 = new Creditor(accountTitle, -total);
            creditors.add((Creditor)creditor2);
            creditorsTotal += -total;
        }
        if (debtors.size() > 0) {
            Collections.sort(debtors, Comparator.comparingInt(o -> order.indexOf(o.getAccountTitle())));
            creditor = new Creditor(AccountTitle.BALANCE, debtorsTotal);
            entry = new JournalEntry(this.date, "\u8ca0\u50b5\u306e\u6b8b\u9ad8\u632f\u66ff", debtors, Arrays.asList(creditor));
            journalEntries.add(entry);
        }
        if (creditors.size() > 0) {
            Collections.sort(creditors, Comparator.comparingInt(o -> order.indexOf(o.getAccountTitle())));
            debtor = new Debtor(AccountTitle.BALANCE, creditorsTotal);
            entry = new JournalEntry(this.date, "\u8ca0\u50b5\u306e\u6b8b\u9ad8\u632f\u66ff", Arrays.asList(debtor), creditors);
            journalEntries.add(entry);
        }
        if (this.out != null) {
            this.out.println("  \u8ca0\u50b5\u306e\u6b8b\u9ad8\u632f\u66ff\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
        }
        for (JournalEntry entry13 : journalEntries) {
            for (Creditor creditor11 : entry13.getCreditors()) {
                if (creditor11.getAccountTitle().getType() != AccountType.Equity) continue;
                equityAccountTitles.add(creditor11.getAccountTitle());
            }
            for (Debtor debtor12 : entry13.getDebtors()) {
                if (debtor12.getAccountTitle().getType() != AccountType.Equity) continue;
                equityAccountTitles.add(debtor12.getAccountTitle());
            }
        }
        debtors = new ArrayList<Debtor>();
        debtorsTotal = 0L;
        creditors = new ArrayList();
        creditorsTotal = 0L;
        for (AccountTitle accountTitle : equityAccountTitles) {
            long total = 0L;
            List<JournalEntry> entries = AccountSettlement.getJournalEntriesByAccount(journalEntries, accountTitle);
            for (JournalEntry entry9 : entries) {
                for (Creditor creditor10 : entry9.getCreditors()) {
                    if (!creditor10.getAccountTitle().equals(accountTitle)) continue;
                    total += creditor10.getAmount();
                }
                for (Debtor debtor11 : entry9.getDebtors()) {
                    if (!debtor11.getAccountTitle().equals(accountTitle)) continue;
                    total -= debtor11.getAmount();
                }
            }
            if (total >= 0L) {
                debtor2 = new Debtor(accountTitle, total);
                debtors.add((Debtor)debtor2);
                debtorsTotal += total;
                continue;
            }
            if (total >= 0L) continue;
            creditor2 = new Creditor(accountTitle, -total);
            creditors.add((Creditor)creditor2);
            creditorsTotal += -total;
        }
        String string = description = this.isSoloProprietorship ? "\u8cc7\u672c\u306e\u6b8b\u9ad8\u632f\u66ff" : "\u7d14\u8cc7\u7523\u306e\u6b8b\u9ad8\u632f\u66ff";
        if (debtors.size() > 0) {
            Creditor creditor5;
            Collections.sort(debtors, Comparator.comparingInt(o -> order.indexOf(o.getAccountTitle())));
            creditor5 = new Creditor(AccountTitle.BALANCE, debtorsTotal);
            JournalEntry incomeSummaryEntry = new JournalEntry(this.date, description, debtors, Arrays.asList(creditor5));
            journalEntries.add(incomeSummaryEntry);
        }
        if (creditors.size() > 0) {
            Debtor debtor6;
            Collections.sort(creditors, Comparator.comparingInt(o -> order.indexOf(o.getAccountTitle())));
            debtor6 = new Debtor(AccountTitle.BALANCE, creditorsTotal);
            JournalEntry incomeSummaryEntry = new JournalEntry(this.date, description, Arrays.asList(debtor6), creditors);
            journalEntries.add(incomeSummaryEntry);
        }
        if (this.out != null) {
            this.out.println("  " + description + "\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
        }
    }

    public static LocalDate getOpeningDate(List<JournalEntry> journalEntries, boolean isSoloProprietorship) {
        LocalDate date = null;
        for (JournalEntry entry : journalEntries) {
            if (date == null) {
                date = entry.getDate();
                continue;
            }
            LocalDate date2 = entry.getDate();
            if (date2 == null || !date2.isBefore(date)) continue;
            date = date2;
        }
        return date;
    }

    public static LocalDate getClosingDate(List<JournalEntry> journalEntries, boolean isSoloProprietorship) {
        LocalDate date = null;
        if (isSoloProprietorship) {
            if (journalEntries.size() > 0) {
                for (JournalEntry entry : journalEntries) {
                    if (entry.getDate() == null) continue;
                    date = LocalDate.of(entry.getDate().getYear(), 12, 31);
                    break;
                }
            }
        } else {
            LocalDate opening = null;
            for (JournalEntry entry : journalEntries) {
                if (opening == null) {
                    opening = entry.getDate();
                    continue;
                }
                LocalDate opening2 = entry.getDate();
                if (opening2 == null || !opening2.isBefore(opening2)) continue;
                opening = opening2;
            }
            if (opening != null) {
                date = opening.plusYears(1L).minusMonths(1L);
                date = date.withDayOfMonth(date.lengthOfMonth());
            }
        }
        return date;
    }

    public static List<JournalEntry> getJournalEntriesByAccount(List<JournalEntry> journalEntries, AccountTitle accountTitle) {
        ArrayList<JournalEntry> entriesByAccount = new ArrayList<JournalEntry>();
        if (accountTitle != null) {
            block0: for (JournalEntry entry : journalEntries) {
                for (Debtor debtor : entry.getDebtors()) {
                    if (!accountTitle.equals(debtor.getAccountTitle())) continue;
                    entriesByAccount.add(entry);
                    continue block0;
                }
                for (Creditor creditor : entry.getCreditors()) {
                    if (!accountTitle.equals(creditor.getAccountTitle())) continue;
                    entriesByAccount.add(entry);
                    continue block0;
                }
            }
        }
        return entriesByAccount;
    }
}

