/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.aoiro.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.osdn.aoiro.model.Node;

public class NodeUtil {
    public static <T> List<Node<T>> findByName(Node<T> root, String name) {
        ArrayList<Node<T>> list = new ArrayList<Node<T>>();
        for (Node<T> child : root.getChildren()) {
            List<Node<T>> subList;
            if (child.getName().equals(name)) {
                list.add(child);
            }
            if ((subList = NodeUtil.findByName(child, name)).size() <= 0) continue;
            list.addAll(subList);
        }
        return list;
    }

    public static <T> Map<Node<T>, List<Node<T>>> createAncestors(Node<T> root) {
        HashMap<Node<T>, List<Node<T>>> map = new HashMap<Node<T>, List<Node<T>>>();
        LinkedList<Node<T>> ancestors = new LinkedList<Node<T>>();
        NodeUtil._createAncestors(root, map, ancestors);
        return map;
    }

    private static <T> void _createAncestors(Node<T> root, Map<Node<T>, List<Node<T>>> map, LinkedList<Node<T>> ancestors) {
        LinkedList<Node<T>> _ancestors = new LinkedList<Node<T>>(ancestors);
        _ancestors.addFirst(root);
        for (Node<T> child : root.getChildren()) {
            map.put(child, _ancestors);
            NodeUtil._createAncestors(child, map, _ancestors);
        }
    }
}

